@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import com.pulumi.core.Either
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Workload instance model properties.
 * @property allowedOperations Gets or sets the allowed scenarios on the workload instance.
 * @property currentJob
 * @property customProperties Workload instance model custom properties.
 * @property displayName Gets or sets the display name.
 * @property healthErrors Gets or sets the list of health errors.
 * @property lastSuccessfulReplicationCycleTime Gets or sets the Last successful replication cycle time.
 * @property masterSiteName Gets or Sets the master site name.
 * @property migrateAgentId Gets or sets the migrate agent id associated with the workload instance.
 * @property name Gets or sets the workload instance name.
 * @property provisioningState Gets or sets the provisioning state of the workload instance.
 * @property replicationHealth Gets or sets the replication health of the workload instance.
 * @property replicationStatus Gets or sets the replication state of the workload instance.
 * @property replicationStatusDescription Gets or sets the workload replication state description.
 * @property sourceName Gets or sets the source name.
 * @property sourcePlatform Gets or sets the source platform.
 */
public data class WorkloadInstanceModelPropertiesResponse(
    public val allowedOperations: List<String>,
    public val currentJob: WorkloadInstanceModelPropertiesResponseCurrentJob,
    public val customProperties:
    Either<ApacheTomcatWorkloadInstanceModelCustomPropertiesResponse, IISWorkloadInstanceModelCustomPropertiesResponse>? =
        null,
    public val displayName: String? = null,
    public val healthErrors: List<HealthErrorModelResponse>,
    public val lastSuccessfulReplicationCycleTime: String,
    public val masterSiteName: String? = null,
    public val migrateAgentId: String? = null,
    public val name: String? = null,
    public val provisioningState: String,
    public val replicationHealth: String,
    public val replicationStatus: String,
    public val replicationStatusDescription: String,
    public val sourceName: String? = null,
    public val sourcePlatform: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.WorkloadInstanceModelPropertiesResponse):
            WorkloadInstanceModelPropertiesResponse = WorkloadInstanceModelPropertiesResponse(
            allowedOperations = javaType.allowedOperations().map({ args0 -> args0 }),
            currentJob = javaType.currentJob().let({ args0 ->
                com.pulumi.azurenative.migrate.kotlin.outputs.WorkloadInstanceModelPropertiesResponseCurrentJob.Companion.toKotlin(args0)
            }),
            customProperties = javaType.customProperties().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.migrate.kotlin.outputs.ApacheTomcatWorkloadInstanceModelCustomPropertiesResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.migrate.kotlin.outputs.IISWorkloadInstanceModelCustomPropertiesResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }).orElse(null),
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            healthErrors = javaType.healthErrors().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.HealthErrorModelResponse.Companion.toKotlin(args0)
                })
            }),
            lastSuccessfulReplicationCycleTime = javaType.lastSuccessfulReplicationCycleTime(),
            masterSiteName = javaType.masterSiteName().map({ args0 -> args0 }).orElse(null),
            migrateAgentId = javaType.migrateAgentId().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            replicationHealth = javaType.replicationHealth(),
            replicationStatus = javaType.replicationStatus(),
            replicationStatusDescription = javaType.replicationStatusDescription(),
            sourceName = javaType.sourceName().map({ args0 -> args0 }).orElse(null),
            sourcePlatform = javaType.sourcePlatform().map({ args0 -> args0 }).orElse(null),
        )
    }
}
