@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin

import com.pulumi.azurenative.mobilenetwork.PacketCaptureArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Packet capture session resource.
 * Azure REST API version: 2023-06-01.
 * Other available API versions: 2023-09-01.
 * ## Example Usage
 * ### Create packet capture
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var packetCapture = new AzureNative.MobileNetwork.PacketCapture("packetCapture", new()
 *     {
 *         BytesToCapturePerPacket = 10000,
 *         NetworkInterfaces = new[]
 *         {
 *             "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobileNetwork/packetCoreControlPlanes/TestPacketCoreCP",
 *             "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobileNetwork/packetCoreControlPlanes/TestPacketCoreCP/packetCoreDataPlanes/TestPacketCoreDP",
 *             "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobileNetwork/packetCoreControlPlanes/TestPacketCoreCP/packetCoreDataPlanes/TestPacketCoreDP/attachedDataNetworks/TestADN",
 *         },
 *         PacketCaptureName = "pc1",
 *         PacketCoreControlPlaneName = "TestPacketCoreCP",
 *         ResourceGroupName = "rg1",
 *         TimeLimitInSeconds = 100,
 *         TotalBytesPerSession = 100000,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/mobilenetwork/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := mobilenetwork.NewPacketCapture(ctx, "packetCapture", &mobilenetwork.PacketCaptureArgs{
 * 			BytesToCapturePerPacket: pulumi.Float64(10000),
 * 			NetworkInterfaces: pulumi.StringArray{
 * 				pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobileNetwork/packetCoreControlPlanes/TestPacketCoreCP"),
 * 				pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobileNetwork/packetCoreControlPlanes/TestPacketCoreCP/packetCoreDataPlanes/TestPacketCoreDP"),
 * 				pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobileNetwork/packetCoreControlPlanes/TestPacketCoreCP/packetCoreDataPlanes/TestPacketCoreDP/attachedDataNetworks/TestADN"),
 * 			},
 * 			PacketCaptureName:          pulumi.String("pc1"),
 * 			PacketCoreControlPlaneName: pulumi.String("TestPacketCoreCP"),
 * 			ResourceGroupName:          pulumi.String("rg1"),
 * 			TimeLimitInSeconds:         pulumi.Int(100),
 * 			TotalBytesPerSession:       pulumi.Float64(100000),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.mobilenetwork.PacketCapture;
 * import com.pulumi.azurenative.mobilenetwork.PacketCaptureArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var packetCapture = new PacketCapture("packetCapture", PacketCaptureArgs.builder()
 *             .bytesToCapturePerPacket(10000)
 *             .networkInterfaces(
 *                 "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobileNetwork/packetCoreControlPlanes/TestPacketCoreCP",
 *                 "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobileNetwork/packetCoreControlPlanes/TestPacketCoreCP/packetCoreDataPlanes/TestPacketCoreDP",
 *                 "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobileNetwork/packetCoreControlPlanes/TestPacketCoreCP/packetCoreDataPlanes/TestPacketCoreDP/attachedDataNetworks/TestADN")
 *             .packetCaptureName("pc1")
 *             .packetCoreControlPlaneName("TestPacketCoreCP")
 *             .resourceGroupName("rg1")
 *             .timeLimitInSeconds(100)
 *             .totalBytesPerSession(100000)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:mobilenetwork:PacketCapture pc1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileNetwork/packetCoreControlPlanes/{packetCoreControlPlaneName}/packetCaptures/{packetCaptureName}
 * ```
 * @property bytesToCapturePerPacket Number of bytes captured per packet, the remaining bytes are truncated. The default "0" means the entire packet is captured.
 * @property networkInterfaces List of network interfaces to capture on.
 * @property packetCaptureName The name of the packet capture session.
 * @property packetCoreControlPlaneName The name of the packet core control plane.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property timeLimitInSeconds Maximum duration of the capture session in seconds.
 * @property totalBytesPerSession Maximum size of the capture output.
 */
public data class PacketCaptureArgs(
    public val bytesToCapturePerPacket: Output<Double>? = null,
    public val networkInterfaces: Output<List<String>>? = null,
    public val packetCaptureName: Output<String>? = null,
    public val packetCoreControlPlaneName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val timeLimitInSeconds: Output<Int>? = null,
    public val totalBytesPerSession: Output<Double>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.mobilenetwork.PacketCaptureArgs> {
    override fun toJava(): com.pulumi.azurenative.mobilenetwork.PacketCaptureArgs =
        com.pulumi.azurenative.mobilenetwork.PacketCaptureArgs.builder()
            .bytesToCapturePerPacket(bytesToCapturePerPacket?.applyValue({ args0 -> args0 }))
            .networkInterfaces(networkInterfaces?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .packetCaptureName(packetCaptureName?.applyValue({ args0 -> args0 }))
            .packetCoreControlPlaneName(packetCoreControlPlaneName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .timeLimitInSeconds(timeLimitInSeconds?.applyValue({ args0 -> args0 }))
            .totalBytesPerSession(totalBytesPerSession?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PacketCaptureArgs].
 */
@PulumiTagMarker
public class PacketCaptureArgsBuilder internal constructor() {
    private var bytesToCapturePerPacket: Output<Double>? = null

    private var networkInterfaces: Output<List<String>>? = null

    private var packetCaptureName: Output<String>? = null

    private var packetCoreControlPlaneName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var timeLimitInSeconds: Output<Int>? = null

    private var totalBytesPerSession: Output<Double>? = null

    /**
     * @param value Number of bytes captured per packet, the remaining bytes are truncated. The default "0" means the entire packet is captured.
     */
    @JvmName("ychfundyjwdgoilo")
    public suspend fun bytesToCapturePerPacket(`value`: Output<Double>) {
        this.bytesToCapturePerPacket = value
    }

    /**
     * @param value List of network interfaces to capture on.
     */
    @JvmName("eunyjmhblnqdpvtk")
    public suspend fun networkInterfaces(`value`: Output<List<String>>) {
        this.networkInterfaces = value
    }

    @JvmName("wxrgjclckyddxrqn")
    public suspend fun networkInterfaces(vararg values: Output<String>) {
        this.networkInterfaces = Output.all(values.asList())
    }

    /**
     * @param values List of network interfaces to capture on.
     */
    @JvmName("mnpfnxwmqljjcxmx")
    public suspend fun networkInterfaces(values: List<Output<String>>) {
        this.networkInterfaces = Output.all(values)
    }

    /**
     * @param value The name of the packet capture session.
     */
    @JvmName("yraigybykjnbdabv")
    public suspend fun packetCaptureName(`value`: Output<String>) {
        this.packetCaptureName = value
    }

    /**
     * @param value The name of the packet core control plane.
     */
    @JvmName("bilnbxotyvjfyyrl")
    public suspend fun packetCoreControlPlaneName(`value`: Output<String>) {
        this.packetCoreControlPlaneName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("kisbwceexjpbtlsa")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Maximum duration of the capture session in seconds.
     */
    @JvmName("rxuiwamymqdkuhpe")
    public suspend fun timeLimitInSeconds(`value`: Output<Int>) {
        this.timeLimitInSeconds = value
    }

    /**
     * @param value Maximum size of the capture output.
     */
    @JvmName("ajrvltptwcgmqijh")
    public suspend fun totalBytesPerSession(`value`: Output<Double>) {
        this.totalBytesPerSession = value
    }

    /**
     * @param value Number of bytes captured per packet, the remaining bytes are truncated. The default "0" means the entire packet is captured.
     */
    @JvmName("yakqjbelfahwguqa")
    public suspend fun bytesToCapturePerPacket(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bytesToCapturePerPacket = mapped
    }

    /**
     * @param value List of network interfaces to capture on.
     */
    @JvmName("lppysrvxrbnfowgq")
    public suspend fun networkInterfaces(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkInterfaces = mapped
    }

    /**
     * @param values List of network interfaces to capture on.
     */
    @JvmName("pldrwuxygmeawdpt")
    public suspend fun networkInterfaces(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.networkInterfaces = mapped
    }

    /**
     * @param value The name of the packet capture session.
     */
    @JvmName("xxcjqqfwuyxfldiy")
    public suspend fun packetCaptureName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.packetCaptureName = mapped
    }

    /**
     * @param value The name of the packet core control plane.
     */
    @JvmName("pvkpomwokfggxick")
    public suspend fun packetCoreControlPlaneName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.packetCoreControlPlaneName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("beeiiqbmcnevdpib")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Maximum duration of the capture session in seconds.
     */
    @JvmName("sxicwpnujypvugpi")
    public suspend fun timeLimitInSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeLimitInSeconds = mapped
    }

    /**
     * @param value Maximum size of the capture output.
     */
    @JvmName("aymovhtattvolwmb")
    public suspend fun totalBytesPerSession(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.totalBytesPerSession = mapped
    }

    internal fun build(): PacketCaptureArgs = PacketCaptureArgs(
        bytesToCapturePerPacket = bytesToCapturePerPacket,
        networkInterfaces = networkInterfaces,
        packetCaptureName = packetCaptureName,
        packetCoreControlPlaneName = packetCoreControlPlaneName,
        resourceGroupName = resourceGroupName,
        timeLimitInSeconds = timeLimitInSeconds,
        totalBytesPerSession = totalBytesPerSession,
    )
}
