@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin

import com.pulumi.azurenative.mobilenetwork.PacketCoreControlPlaneArgs.builder
import com.pulumi.azurenative.mobilenetwork.kotlin.enums.BillingSku
import com.pulumi.azurenative.mobilenetwork.kotlin.enums.CoreNetworkType
import com.pulumi.azurenative.mobilenetwork.kotlin.inputs.DiagnosticsUploadConfigurationArgs
import com.pulumi.azurenative.mobilenetwork.kotlin.inputs.DiagnosticsUploadConfigurationArgsBuilder
import com.pulumi.azurenative.mobilenetwork.kotlin.inputs.InstallationArgs
import com.pulumi.azurenative.mobilenetwork.kotlin.inputs.InstallationArgsBuilder
import com.pulumi.azurenative.mobilenetwork.kotlin.inputs.InterfacePropertiesArgs
import com.pulumi.azurenative.mobilenetwork.kotlin.inputs.InterfacePropertiesArgsBuilder
import com.pulumi.azurenative.mobilenetwork.kotlin.inputs.LocalDiagnosticsAccessConfigurationArgs
import com.pulumi.azurenative.mobilenetwork.kotlin.inputs.LocalDiagnosticsAccessConfigurationArgsBuilder
import com.pulumi.azurenative.mobilenetwork.kotlin.inputs.ManagedServiceIdentityArgs
import com.pulumi.azurenative.mobilenetwork.kotlin.inputs.ManagedServiceIdentityArgsBuilder
import com.pulumi.azurenative.mobilenetwork.kotlin.inputs.PlatformConfigurationArgs
import com.pulumi.azurenative.mobilenetwork.kotlin.inputs.PlatformConfigurationArgsBuilder
import com.pulumi.azurenative.mobilenetwork.kotlin.inputs.SiteResourceIdArgs
import com.pulumi.azurenative.mobilenetwork.kotlin.inputs.SiteResourceIdArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Packet core control plane resource.
 * Azure REST API version: 2023-06-01. Prior API version in Azure Native 1.x: 2022-04-01-preview.
 * Other available API versions: 2022-03-01-preview, 2022-04-01-preview, 2022-11-01, 2023-09-01.
 * ## Example Usage
 * ### Create packet core control plane
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var packetCoreControlPlane = new AzureNative.MobileNetwork.PacketCoreControlPlane("packetCoreControlPlane", new()
 *     {
 *         ControlPlaneAccessInterface = new AzureNative.MobileNetwork.Inputs.InterfacePropertiesArgs
 *         {
 *             Name = "N2",
 *         },
 *         CoreNetworkTechnology = "5GC",
 *         Installation = new AzureNative.MobileNetwork.Inputs.InstallationArgs
 *         {
 *             DesiredState = "Installed",
 *         },
 *         LocalDiagnosticsAccess = new AzureNative.MobileNetwork.Inputs.LocalDiagnosticsAccessConfigurationArgs
 *         {
 *             AuthenticationType = "AAD",
 *             HttpsServerCertificate = new AzureNative.MobileNetwork.Inputs.HttpsServerCertificateArgs
 *             {
 *                 CertificateUrl = "https://contosovault.vault.azure.net/certificates/ingress",
 *             },
 *         },
 *         Location = "eastus",
 *         PacketCoreControlPlaneName = "TestPacketCoreCP",
 *         Platform = new AzureNative.MobileNetwork.Inputs.PlatformConfigurationArgs
 *         {
 *             AzureStackEdgeDevice = new AzureNative.MobileNetwork.Inputs.AzureStackEdgeDeviceResourceIdArgs
 *             {
 *                 Id = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/TestAzureStackEdgeDevice",
 *             },
 *             ConnectedCluster = new AzureNative.MobileNetwork.Inputs.ConnectedClusterResourceIdArgs
 *             {
 *                 Id = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Kubernetes/connectedClusters/TestConnectedCluster",
 *             },
 *             CustomLocation = new AzureNative.MobileNetwork.Inputs.CustomLocationResourceIdArgs
 *             {
 *                 Id = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.ExtendedLocation/customLocations/TestCustomLocation",
 *             },
 *             Type = "AKS-HCI",
 *         },
 *         ResourceGroupName = "rg1",
 *         Sites = new[]
 *         {
 *             new AzureNative.MobileNetwork.Inputs.SiteResourceIdArgs
 *             {
 *                 Id = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobileNetwork/mobileNetworks/testMobileNetwork/sites/testSite",
 *             },
 *         },
 *         Sku = "G0",
 *         UeMtu = 1600,
 *         Version = "0.2.0",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/mobilenetwork/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := mobilenetwork.NewPacketCoreControlPlane(ctx, "packetCoreControlPlane", &mobilenetwork.PacketCoreControlPlaneArgs{
 * 			ControlPlaneAccessInterface: &mobilenetwork.InterfacePropertiesArgs{
 * 				Name: pulumi.String("N2"),
 * 			},
 * 			CoreNetworkTechnology: pulumi.String("5GC"),
 * 			Installation: &mobilenetwork.InstallationArgs{
 * 				DesiredState: pulumi.String("Installed"),
 * 			},
 * 			LocalDiagnosticsAccess: mobilenetwork.LocalDiagnosticsAccessConfigurationResponse{
 * 				AuthenticationType: pulumi.String("AAD"),
 * 				HttpsServerCertificate: &mobilenetwork.HttpsServerCertificateArgs{
 * 					CertificateUrl: pulumi.String("https://contosovault.vault.azure.net/certificates/ingress"),
 * 				},
 * 			},
 * 			Location:                   pulumi.String("eastus"),
 * 			PacketCoreControlPlaneName: pulumi.String("TestPacketCoreCP"),
 * 			Platform: mobilenetwork.PlatformConfigurationResponse{
 * 				AzureStackEdgeDevice: &mobilenetwork.AzureStackEdgeDeviceResourceIdArgs{
 * 					Id: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/TestAzureStackEdgeDevice"),
 * 				},
 * 				ConnectedCluster: &mobilenetwork.ConnectedClusterResourceIdArgs{
 * 					Id: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Kubernetes/connectedClusters/TestConnectedCluster"),
 * 				},
 * 				CustomLocation: &mobilenetwork.CustomLocationResourceIdArgs{
 * 					Id: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.ExtendedLocation/customLocations/TestCustomLocation"),
 * 				},
 * 				Type: pulumi.String("AKS-HCI"),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Sites: []mobilenetwork.SiteResourceIdArgs{
 * 				{
 * 					Id: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobileNetwork/mobileNetworks/testMobileNetwork/sites/testSite"),
 * 				},
 * 			},
 * 			Sku:     pulumi.String("G0"),
 * 			UeMtu:   pulumi.Int(1600),
 * 			Version: pulumi.String("0.2.0"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.mobilenetwork.PacketCoreControlPlane;
 * import com.pulumi.azurenative.mobilenetwork.PacketCoreControlPlaneArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var packetCoreControlPlane = new PacketCoreControlPlane("packetCoreControlPlane", PacketCoreControlPlaneArgs.builder()
 *             .controlPlaneAccessInterface(Map.of("name", "N2"))
 *             .coreNetworkTechnology("5GC")
 *             .installation(Map.of("desiredState", "Installed"))
 *             .localDiagnosticsAccess(Map.ofEntries(
 *                 Map.entry("authenticationType", "AAD"),
 *                 Map.entry("httpsServerCertificate", Map.of("certificateUrl", "https://contosovault.vault.azure.net/certificates/ingress"))
 *             ))
 *             .location("eastus")
 *             .packetCoreControlPlaneName("TestPacketCoreCP")
 *             .platform(Map.ofEntries(
 *                 Map.entry("azureStackEdgeDevice", Map.of("id", "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/TestAzureStackEdgeDevice")),
 *                 Map.entry("connectedCluster", Map.of("id", "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Kubernetes/connectedClusters/TestConnectedCluster")),
 *                 Map.entry("customLocation", Map.of("id", "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.ExtendedLocation/customLocations/TestCustomLocation")),
 *                 Map.entry("type", "AKS-HCI")
 *             ))
 *             .resourceGroupName("rg1")
 *             .sites(Map.of("id", "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobileNetwork/mobileNetworks/testMobileNetwork/sites/testSite"))
 *             .sku("G0")
 *             .ueMtu(1600)
 *             .version("0.2.0")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:mobilenetwork:PacketCoreControlPlane TestPacketCoreCP /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileNetwork/packetCoreControlPlanes/{packetCoreControlPlaneName}
 * ```
 * @property controlPlaneAccessInterface The control plane interface on the access network. For 5G networks, this is the N2 interface. For 4G networks, this is the S1-MME interface.
 * @property coreNetworkTechnology The core network technology generation (5G core or EPC / 4G core).
 * @property diagnosticsUpload Configuration for uploading packet core diagnostics
 * @property identity The identity used to retrieve the ingress certificate from Azure key vault.
 * @property installation The installation state of the packet core control plane resource.
 * @property interopSettings Settings to allow interoperability with third party components e.g. RANs and UEs.
 * @property localDiagnosticsAccess The kubernetes ingress configuration to control access to packet core diagnostics over local APIs.
 * @property location The geo-location where the resource lives
 * @property packetCoreControlPlaneName The name of the packet core control plane.
 * @property platform The platform where the packet core is deployed.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property sites Site(s) under which this packet core control plane should be deployed. The sites must be in the same location as the packet core control plane.
 * @property sku The SKU defining the throughput and SIM allowances for this packet core control plane deployment.
 * @property tags Resource tags.
 * @property ueMtu The MTU (in bytes) signaled to the UE. The same MTU is set on the user plane data links for all data networks. The MTU set on the user plane access link is calculated to be 60 bytes greater than this value to allow for GTP encapsulation.
 * @property version The desired version of the packet core software.
 */
public data class PacketCoreControlPlaneArgs(
    public val controlPlaneAccessInterface: Output<InterfacePropertiesArgs>? = null,
    public val coreNetworkTechnology: Output<Either<String, CoreNetworkType>>? = null,
    public val diagnosticsUpload: Output<DiagnosticsUploadConfigurationArgs>? = null,
    public val identity: Output<ManagedServiceIdentityArgs>? = null,
    public val installation: Output<InstallationArgs>? = null,
    public val interopSettings: Output<Any>? = null,
    public val localDiagnosticsAccess: Output<LocalDiagnosticsAccessConfigurationArgs>? = null,
    public val location: Output<String>? = null,
    public val packetCoreControlPlaneName: Output<String>? = null,
    public val platform: Output<PlatformConfigurationArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sites: Output<List<SiteResourceIdArgs>>? = null,
    public val sku: Output<Either<String, BillingSku>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val ueMtu: Output<Int>? = null,
    public val version: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.mobilenetwork.PacketCoreControlPlaneArgs> {
    override fun toJava(): com.pulumi.azurenative.mobilenetwork.PacketCoreControlPlaneArgs =
        com.pulumi.azurenative.mobilenetwork.PacketCoreControlPlaneArgs.builder()
            .controlPlaneAccessInterface(
                controlPlaneAccessInterface?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .coreNetworkTechnology(
                coreNetworkTechnology?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .diagnosticsUpload(diagnosticsUpload?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .installation(installation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .interopSettings(interopSettings?.applyValue({ args0 -> args0 }))
            .localDiagnosticsAccess(
                localDiagnosticsAccess?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .packetCoreControlPlaneName(packetCoreControlPlaneName?.applyValue({ args0 -> args0 }))
            .platform(platform?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sites(sites?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .sku(
                sku?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .ueMtu(ueMtu?.applyValue({ args0 -> args0 }))
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PacketCoreControlPlaneArgs].
 */
@PulumiTagMarker
public class PacketCoreControlPlaneArgsBuilder internal constructor() {
    private var controlPlaneAccessInterface: Output<InterfacePropertiesArgs>? = null

    private var coreNetworkTechnology: Output<Either<String, CoreNetworkType>>? = null

    private var diagnosticsUpload: Output<DiagnosticsUploadConfigurationArgs>? = null

    private var identity: Output<ManagedServiceIdentityArgs>? = null

    private var installation: Output<InstallationArgs>? = null

    private var interopSettings: Output<Any>? = null

    private var localDiagnosticsAccess: Output<LocalDiagnosticsAccessConfigurationArgs>? = null

    private var location: Output<String>? = null

    private var packetCoreControlPlaneName: Output<String>? = null

    private var platform: Output<PlatformConfigurationArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var sites: Output<List<SiteResourceIdArgs>>? = null

    private var sku: Output<Either<String, BillingSku>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var ueMtu: Output<Int>? = null

    private var version: Output<String>? = null

    /**
     * @param value The control plane interface on the access network. For 5G networks, this is the N2 interface. For 4G networks, this is the S1-MME interface.
     */
    @JvmName("wvekiauacdfgtrxq")
    public suspend fun controlPlaneAccessInterface(`value`: Output<InterfacePropertiesArgs>) {
        this.controlPlaneAccessInterface = value
    }

    /**
     * @param value The core network technology generation (5G core or EPC / 4G core).
     */
    @JvmName("eqdweeopbjcwxbgq")
    public suspend fun coreNetworkTechnology(`value`: Output<Either<String, CoreNetworkType>>) {
        this.coreNetworkTechnology = value
    }

    /**
     * @param value Configuration for uploading packet core diagnostics
     */
    @JvmName("fukchtpnblkqmudm")
    public suspend fun diagnosticsUpload(`value`: Output<DiagnosticsUploadConfigurationArgs>) {
        this.diagnosticsUpload = value
    }

    /**
     * @param value The identity used to retrieve the ingress certificate from Azure key vault.
     */
    @JvmName("flhtvwfhxifoisfc")
    public suspend fun identity(`value`: Output<ManagedServiceIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value The installation state of the packet core control plane resource.
     */
    @JvmName("apgbwdtnbwctksgp")
    public suspend fun installation(`value`: Output<InstallationArgs>) {
        this.installation = value
    }

    /**
     * @param value Settings to allow interoperability with third party components e.g. RANs and UEs.
     */
    @JvmName("gxpojwmtnlyhijmh")
    public suspend fun interopSettings(`value`: Output<Any>) {
        this.interopSettings = value
    }

    /**
     * @param value The kubernetes ingress configuration to control access to packet core diagnostics over local APIs.
     */
    @JvmName("xqrmffaegnodanqv")
    public suspend
    fun localDiagnosticsAccess(`value`: Output<LocalDiagnosticsAccessConfigurationArgs>) {
        this.localDiagnosticsAccess = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("ksjptcfeifspngcn")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the packet core control plane.
     */
    @JvmName("vvkddmhivuavdrss")
    public suspend fun packetCoreControlPlaneName(`value`: Output<String>) {
        this.packetCoreControlPlaneName = value
    }

    /**
     * @param value The platform where the packet core is deployed.
     */
    @JvmName("ldvoaroirfxyxwlt")
    public suspend fun platform(`value`: Output<PlatformConfigurationArgs>) {
        this.platform = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ncvwiqersujthgky")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Site(s) under which this packet core control plane should be deployed. The sites must be in the same location as the packet core control plane.
     */
    @JvmName("rybbpfnsctrylnxb")
    public suspend fun sites(`value`: Output<List<SiteResourceIdArgs>>) {
        this.sites = value
    }

    @JvmName("lunvqpppobwmstni")
    public suspend fun sites(vararg values: Output<SiteResourceIdArgs>) {
        this.sites = Output.all(values.asList())
    }

    /**
     * @param values Site(s) under which this packet core control plane should be deployed. The sites must be in the same location as the packet core control plane.
     */
    @JvmName("hybmnifglajldlyx")
    public suspend fun sites(values: List<Output<SiteResourceIdArgs>>) {
        this.sites = Output.all(values)
    }

    /**
     * @param value The SKU defining the throughput and SIM allowances for this packet core control plane deployment.
     */
    @JvmName("qfbmyymrlaxeqrba")
    public suspend fun sku(`value`: Output<Either<String, BillingSku>>) {
        this.sku = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("mxjficeeolovwvce")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The MTU (in bytes) signaled to the UE. The same MTU is set on the user plane data links for all data networks. The MTU set on the user plane access link is calculated to be 60 bytes greater than this value to allow for GTP encapsulation.
     */
    @JvmName("dogfblewwajmhgoj")
    public suspend fun ueMtu(`value`: Output<Int>) {
        this.ueMtu = value
    }

    /**
     * @param value The desired version of the packet core software.
     */
    @JvmName("cluhskqqhunpqimf")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value The control plane interface on the access network. For 5G networks, this is the N2 interface. For 4G networks, this is the S1-MME interface.
     */
    @JvmName("svqmqfjjrghsretk")
    public suspend fun controlPlaneAccessInterface(`value`: InterfacePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.controlPlaneAccessInterface = mapped
    }

    /**
     * @param argument The control plane interface on the access network. For 5G networks, this is the N2 interface. For 4G networks, this is the S1-MME interface.
     */
    @JvmName("nhjdnmrwdngtcahh")
    public suspend
    fun controlPlaneAccessInterface(argument: suspend InterfacePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = InterfacePropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.controlPlaneAccessInterface = mapped
    }

    /**
     * @param value The core network technology generation (5G core or EPC / 4G core).
     */
    @JvmName("snotyyervswwddim")
    public suspend fun coreNetworkTechnology(`value`: Either<String, CoreNetworkType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.coreNetworkTechnology = mapped
    }

    /**
     * @param value The core network technology generation (5G core or EPC / 4G core).
     */
    @JvmName("wgpckvhdvfnjihsu")
    public fun coreNetworkTechnology(`value`: String) {
        val toBeMapped = Either.ofLeft<String, CoreNetworkType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.coreNetworkTechnology = mapped
    }

    /**
     * @param value The core network technology generation (5G core or EPC / 4G core).
     */
    @JvmName("eyrfuegkrorpemql")
    public fun coreNetworkTechnology(`value`: CoreNetworkType) {
        val toBeMapped = Either.ofRight<String, CoreNetworkType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.coreNetworkTechnology = mapped
    }

    /**
     * @param value Configuration for uploading packet core diagnostics
     */
    @JvmName("qxwufjrisbvjshki")
    public suspend fun diagnosticsUpload(`value`: DiagnosticsUploadConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diagnosticsUpload = mapped
    }

    /**
     * @param argument Configuration for uploading packet core diagnostics
     */
    @JvmName("ogjdmssuqysvnfvk")
    public suspend
    fun diagnosticsUpload(argument: suspend DiagnosticsUploadConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = DiagnosticsUploadConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.diagnosticsUpload = mapped
    }

    /**
     * @param value The identity used to retrieve the ingress certificate from Azure key vault.
     */
    @JvmName("cymyonpbofbcrulm")
    public suspend fun identity(`value`: ManagedServiceIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument The identity used to retrieve the ingress certificate from Azure key vault.
     */
    @JvmName("bljyjdyuyugqseyt")
    public suspend fun identity(argument: suspend ManagedServiceIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedServiceIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value The installation state of the packet core control plane resource.
     */
    @JvmName("ecijkpetmhpvkkip")
    public suspend fun installation(`value`: InstallationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.installation = mapped
    }

    /**
     * @param argument The installation state of the packet core control plane resource.
     */
    @JvmName("htwmcykwnfgbdshq")
    public suspend fun installation(argument: suspend InstallationArgsBuilder.() -> Unit) {
        val toBeMapped = InstallationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.installation = mapped
    }

    /**
     * @param value Settings to allow interoperability with third party components e.g. RANs and UEs.
     */
    @JvmName("ufxmuqlketidsppy")
    public suspend fun interopSettings(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.interopSettings = mapped
    }

    /**
     * @param value The kubernetes ingress configuration to control access to packet core diagnostics over local APIs.
     */
    @JvmName("jcvovgqjmdumspqj")
    public suspend fun localDiagnosticsAccess(`value`: LocalDiagnosticsAccessConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.localDiagnosticsAccess = mapped
    }

    /**
     * @param argument The kubernetes ingress configuration to control access to packet core diagnostics over local APIs.
     */
    @JvmName("gtmqdpghedcfbqhp")
    public suspend
    fun localDiagnosticsAccess(argument: suspend LocalDiagnosticsAccessConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = LocalDiagnosticsAccessConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.localDiagnosticsAccess = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("efmmirfkojxqojlx")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the packet core control plane.
     */
    @JvmName("dttnnjpnwpbpjwrr")
    public suspend fun packetCoreControlPlaneName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.packetCoreControlPlaneName = mapped
    }

    /**
     * @param value The platform where the packet core is deployed.
     */
    @JvmName("igejdiclqsrbpbms")
    public suspend fun platform(`value`: PlatformConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.platform = mapped
    }

    /**
     * @param argument The platform where the packet core is deployed.
     */
    @JvmName("sfqecycyhdyqkcwp")
    public suspend fun platform(argument: suspend PlatformConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = PlatformConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.platform = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("gsegbbihbsyxclct")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Site(s) under which this packet core control plane should be deployed. The sites must be in the same location as the packet core control plane.
     */
    @JvmName("ylsbveduorinvwkk")
    public suspend fun sites(`value`: List<SiteResourceIdArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sites = mapped
    }

    /**
     * @param argument Site(s) under which this packet core control plane should be deployed. The sites must be in the same location as the packet core control plane.
     */
    @JvmName("cfdqhlbvfksnaual")
    public suspend fun sites(argument: List<suspend SiteResourceIdArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SiteResourceIdArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.sites = mapped
    }

    /**
     * @param argument Site(s) under which this packet core control plane should be deployed. The sites must be in the same location as the packet core control plane.
     */
    @JvmName("ranmrapnvvxfwtiw")
    public suspend fun sites(vararg argument: suspend SiteResourceIdArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            SiteResourceIdArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.sites = mapped
    }

    /**
     * @param argument Site(s) under which this packet core control plane should be deployed. The sites must be in the same location as the packet core control plane.
     */
    @JvmName("erugwnwlcivxsfrw")
    public suspend fun sites(argument: suspend SiteResourceIdArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SiteResourceIdArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.sites = mapped
    }

    /**
     * @param values Site(s) under which this packet core control plane should be deployed. The sites must be in the same location as the packet core control plane.
     */
    @JvmName("psxmtcbrqswgjbia")
    public suspend fun sites(vararg values: SiteResourceIdArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sites = mapped
    }

    /**
     * @param value The SKU defining the throughput and SIM allowances for this packet core control plane deployment.
     */
    @JvmName("akerihtkgdxupqpr")
    public suspend fun sku(`value`: Either<String, BillingSku>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param value The SKU defining the throughput and SIM allowances for this packet core control plane deployment.
     */
    @JvmName("slwtjmxdkfakfemq")
    public fun sku(`value`: String) {
        val toBeMapped = Either.ofLeft<String, BillingSku>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param value The SKU defining the throughput and SIM allowances for this packet core control plane deployment.
     */
    @JvmName("twwcymyigvtvdvpb")
    public fun sku(`value`: BillingSku) {
        val toBeMapped = Either.ofRight<String, BillingSku>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("qtyafvqvoeptsjmx")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("orsditbclhpajliy")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The MTU (in bytes) signaled to the UE. The same MTU is set on the user plane data links for all data networks. The MTU set on the user plane access link is calculated to be 60 bytes greater than this value to allow for GTP encapsulation.
     */
    @JvmName("wwdeofnmovnrkwbt")
    public suspend fun ueMtu(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ueMtu = mapped
    }

    /**
     * @param value The desired version of the packet core software.
     */
    @JvmName("vbjfqfnlohrjxmhk")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): PacketCoreControlPlaneArgs = PacketCoreControlPlaneArgs(
        controlPlaneAccessInterface = controlPlaneAccessInterface,
        coreNetworkTechnology = coreNetworkTechnology,
        diagnosticsUpload = diagnosticsUpload,
        identity = identity,
        installation = installation,
        interopSettings = interopSettings,
        localDiagnosticsAccess = localDiagnosticsAccess,
        location = location,
        packetCoreControlPlaneName = packetCoreControlPlaneName,
        platform = platform,
        resourceGroupName = resourceGroupName,
        sites = sites,
        sku = sku,
        tags = tags,
        ueMtu = ueMtu,
        version = version,
    )
}
