@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin

import com.pulumi.azurenative.mobilenetwork.SimArgs.builder
import com.pulumi.azurenative.mobilenetwork.kotlin.inputs.SimPolicyResourceIdArgs
import com.pulumi.azurenative.mobilenetwork.kotlin.inputs.SimPolicyResourceIdArgsBuilder
import com.pulumi.azurenative.mobilenetwork.kotlin.inputs.SimStaticIpPropertiesArgs
import com.pulumi.azurenative.mobilenetwork.kotlin.inputs.SimStaticIpPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * SIM resource.
 * Azure REST API version: 2023-06-01. Prior API version in Azure Native 1.x: 2022-04-01-preview.
 * Other available API versions: 2022-03-01-preview, 2022-04-01-preview, 2022-11-01, 2023-09-01.
 * ## Example Usage
 * ### Create SIM
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sim = new AzureNative.MobileNetwork.Sim("sim", new()
 *     {
 *         AuthenticationKey = "00000000000000000000000000000000",
 *         DeviceType = "Video camera",
 *         IntegratedCircuitCardIdentifier = "8900000000000000000",
 *         InternationalMobileSubscriberIdentity = "00000",
 *         OperatorKeyCode = "00000000000000000000000000000000",
 *         ResourceGroupName = "rg1",
 *         SimGroupName = "testSimGroup",
 *         SimName = "testSim",
 *         SimPolicy = new AzureNative.MobileNetwork.Inputs.SimPolicyResourceIdArgs
 *         {
 *             Id = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobileNetwork/mobileNetworks/testMobileNetwork/simPolicies/MySimPolicy",
 *         },
 *         StaticIpConfiguration = new[]
 *         {
 *             new AzureNative.MobileNetwork.Inputs.SimStaticIpPropertiesArgs
 *             {
 *                 AttachedDataNetwork = new AzureNative.MobileNetwork.Inputs.AttachedDataNetworkResourceIdArgs
 *                 {
 *                     Id = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobileNetwork/packetCoreControlPlanes/TestPacketCoreCP/packetCoreDataPlanes/TestPacketCoreDP/attachedDataNetworks/TestAttachedDataNetwork",
 *                 },
 *                 Slice = new AzureNative.MobileNetwork.Inputs.SliceResourceIdArgs
 *                 {
 *                     Id = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobileNetwork/mobileNetworks/testMobileNetwork/slices/testSlice",
 *                 },
 *                 StaticIp = new AzureNative.MobileNetwork.Inputs.SimStaticIpPropertiesStaticIpArgs
 *                 {
 *                     Ipv4Address = "2.4.0.1",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/mobilenetwork/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := mobilenetwork.NewSim(ctx, "sim", &mobilenetwork.SimArgs{
 * 			AuthenticationKey:                     pulumi.String("00000000000000000000000000000000"),
 * 			DeviceType:                            pulumi.String("Video camera"),
 * 			IntegratedCircuitCardIdentifier:       pulumi.String("8900000000000000000"),
 * 			InternationalMobileSubscriberIdentity: pulumi.String("00000"),
 * 			OperatorKeyCode:                       pulumi.String("00000000000000000000000000000000"),
 * 			ResourceGroupName:                     pulumi.String("rg1"),
 * 			SimGroupName:                          pulumi.String("testSimGroup"),
 * 			SimName:                               pulumi.String("testSim"),
 * 			SimPolicy: &mobilenetwork.SimPolicyResourceIdArgs{
 * 				Id: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobileNetwork/mobileNetworks/testMobileNetwork/simPolicies/MySimPolicy"),
 * 			},
 * 			StaticIpConfiguration: []mobilenetwork.SimStaticIpPropertiesArgs{
 * 				{
 * 					AttachedDataNetwork: {
 * 						Id: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobileNetwork/packetCoreControlPlanes/TestPacketCoreCP/packetCoreDataPlanes/TestPacketCoreDP/attachedDataNetworks/TestAttachedDataNetwork"),
 * 					},
 * 					Slice: {
 * 						Id: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobileNetwork/mobileNetworks/testMobileNetwork/slices/testSlice"),
 * 					},
 * 					StaticIp: {
 * 						Ipv4Address: pulumi.String("2.4.0.1"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.mobilenetwork.Sim;
 * import com.pulumi.azurenative.mobilenetwork.SimArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sim = new Sim("sim", SimArgs.builder()
 *             .authenticationKey("00000000000000000000000000000000")
 *             .deviceType("Video camera")
 *             .integratedCircuitCardIdentifier("8900000000000000000")
 *             .internationalMobileSubscriberIdentity("00000")
 *             .operatorKeyCode("00000000000000000000000000000000")
 *             .resourceGroupName("rg1")
 *             .simGroupName("testSimGroup")
 *             .simName("testSim")
 *             .simPolicy(Map.of("id", "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobileNetwork/mobileNetworks/testMobileNetwork/simPolicies/MySimPolicy"))
 *             .staticIpConfiguration(Map.ofEntries(
 *                 Map.entry("attachedDataNetwork", Map.of("id", "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobileNetwork/packetCoreControlPlanes/TestPacketCoreCP/packetCoreDataPlanes/TestPacketCoreDP/attachedDataNetworks/TestAttachedDataNetwork")),
 *                 Map.entry("slice", Map.of("id", "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobileNetwork/mobileNetworks/testMobileNetwork/slices/testSlice")),
 *                 Map.entry("staticIp", Map.of("ipv4Address", "2.4.0.1"))
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:mobilenetwork:Sim testSim /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileNetwork/simGroups/{simGroupName}/sims/{simName}
 * ```
 * @property authenticationKey The Ki value for the SIM.
 * @property deviceType An optional free-form text field that can be used to record the device type this SIM is associated with, for example 'Video camera'. The Azure portal allows SIMs to be grouped and filtered based on this value.
 * @property integratedCircuitCardIdentifier The integrated circuit card ID (ICCID) for the SIM.
 * @property internationalMobileSubscriberIdentity The international mobile subscriber identity (IMSI) for the SIM.
 * @property operatorKeyCode The Opc value for the SIM.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property simGroupName The name of the SIM Group.
 * @property simName The name of the SIM.
 * @property simPolicy The SIM policy used by this SIM. The SIM policy must be in the same location as the SIM.
 * @property staticIpConfiguration A list of static IP addresses assigned to this SIM. Each address is assigned at a defined network scope, made up of {attached data network, slice}.
 */
public data class SimArgs(
    public val authenticationKey: Output<String>? = null,
    public val deviceType: Output<String>? = null,
    public val integratedCircuitCardIdentifier: Output<String>? = null,
    public val internationalMobileSubscriberIdentity: Output<String>? = null,
    public val operatorKeyCode: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val simGroupName: Output<String>? = null,
    public val simName: Output<String>? = null,
    public val simPolicy: Output<SimPolicyResourceIdArgs>? = null,
    public val staticIpConfiguration: Output<List<SimStaticIpPropertiesArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.mobilenetwork.SimArgs> {
    override fun toJava(): com.pulumi.azurenative.mobilenetwork.SimArgs =
        com.pulumi.azurenative.mobilenetwork.SimArgs.builder()
            .authenticationKey(authenticationKey?.applyValue({ args0 -> args0 }))
            .deviceType(deviceType?.applyValue({ args0 -> args0 }))
            .integratedCircuitCardIdentifier(integratedCircuitCardIdentifier?.applyValue({ args0 -> args0 }))
            .internationalMobileSubscriberIdentity(
                internationalMobileSubscriberIdentity?.applyValue({ args0 ->
                    args0
                }),
            )
            .operatorKeyCode(operatorKeyCode?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .simGroupName(simGroupName?.applyValue({ args0 -> args0 }))
            .simName(simName?.applyValue({ args0 -> args0 }))
            .simPolicy(simPolicy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .staticIpConfiguration(
                staticIpConfiguration?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [SimArgs].
 */
@PulumiTagMarker
public class SimArgsBuilder internal constructor() {
    private var authenticationKey: Output<String>? = null

    private var deviceType: Output<String>? = null

    private var integratedCircuitCardIdentifier: Output<String>? = null

    private var internationalMobileSubscriberIdentity: Output<String>? = null

    private var operatorKeyCode: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var simGroupName: Output<String>? = null

    private var simName: Output<String>? = null

    private var simPolicy: Output<SimPolicyResourceIdArgs>? = null

    private var staticIpConfiguration: Output<List<SimStaticIpPropertiesArgs>>? = null

    /**
     * @param value The Ki value for the SIM.
     */
    @JvmName("qimkpdjuhljhvohp")
    public suspend fun authenticationKey(`value`: Output<String>) {
        this.authenticationKey = value
    }

    /**
     * @param value An optional free-form text field that can be used to record the device type this SIM is associated with, for example 'Video camera'. The Azure portal allows SIMs to be grouped and filtered based on this value.
     */
    @JvmName("bgoibpvvsmyeptax")
    public suspend fun deviceType(`value`: Output<String>) {
        this.deviceType = value
    }

    /**
     * @param value The integrated circuit card ID (ICCID) for the SIM.
     */
    @JvmName("bcilavogpiornbpd")
    public suspend fun integratedCircuitCardIdentifier(`value`: Output<String>) {
        this.integratedCircuitCardIdentifier = value
    }

    /**
     * @param value The international mobile subscriber identity (IMSI) for the SIM.
     */
    @JvmName("ccapuqrkmwcaukxn")
    public suspend fun internationalMobileSubscriberIdentity(`value`: Output<String>) {
        this.internationalMobileSubscriberIdentity = value
    }

    /**
     * @param value The Opc value for the SIM.
     */
    @JvmName("bbwfektmekaokpei")
    public suspend fun operatorKeyCode(`value`: Output<String>) {
        this.operatorKeyCode = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("htglvywatginsucg")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the SIM Group.
     */
    @JvmName("waqurjbahabuabqu")
    public suspend fun simGroupName(`value`: Output<String>) {
        this.simGroupName = value
    }

    /**
     * @param value The name of the SIM.
     */
    @JvmName("jypkbhgomxwrnaga")
    public suspend fun simName(`value`: Output<String>) {
        this.simName = value
    }

    /**
     * @param value The SIM policy used by this SIM. The SIM policy must be in the same location as the SIM.
     */
    @JvmName("bafkhrtdvexbalrc")
    public suspend fun simPolicy(`value`: Output<SimPolicyResourceIdArgs>) {
        this.simPolicy = value
    }

    /**
     * @param value A list of static IP addresses assigned to this SIM. Each address is assigned at a defined network scope, made up of {attached data network, slice}.
     */
    @JvmName("hbvkrgtqiisujhwp")
    public suspend fun staticIpConfiguration(`value`: Output<List<SimStaticIpPropertiesArgs>>) {
        this.staticIpConfiguration = value
    }

    @JvmName("gheuhaxdjwxrciuk")
    public suspend fun staticIpConfiguration(vararg values: Output<SimStaticIpPropertiesArgs>) {
        this.staticIpConfiguration = Output.all(values.asList())
    }

    /**
     * @param values A list of static IP addresses assigned to this SIM. Each address is assigned at a defined network scope, made up of {attached data network, slice}.
     */
    @JvmName("expwckhvmjdaubax")
    public suspend fun staticIpConfiguration(values: List<Output<SimStaticIpPropertiesArgs>>) {
        this.staticIpConfiguration = Output.all(values)
    }

    /**
     * @param value The Ki value for the SIM.
     */
    @JvmName("sfdvmmosdebyoqwl")
    public suspend fun authenticationKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authenticationKey = mapped
    }

    /**
     * @param value An optional free-form text field that can be used to record the device type this SIM is associated with, for example 'Video camera'. The Azure portal allows SIMs to be grouped and filtered based on this value.
     */
    @JvmName("xuhqjxrvefpqpetu")
    public suspend fun deviceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deviceType = mapped
    }

    /**
     * @param value The integrated circuit card ID (ICCID) for the SIM.
     */
    @JvmName("yoqbxsnlovysbxug")
    public suspend fun integratedCircuitCardIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.integratedCircuitCardIdentifier = mapped
    }

    /**
     * @param value The international mobile subscriber identity (IMSI) for the SIM.
     */
    @JvmName("nkumowjvmkvqdtfn")
    public suspend fun internationalMobileSubscriberIdentity(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.internationalMobileSubscriberIdentity = mapped
    }

    /**
     * @param value The Opc value for the SIM.
     */
    @JvmName("dtefianfxvhgrxsb")
    public suspend fun operatorKeyCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.operatorKeyCode = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("wbyotjhbofopsfby")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the SIM Group.
     */
    @JvmName("qltonnbfpbtkvjhv")
    public suspend fun simGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.simGroupName = mapped
    }

    /**
     * @param value The name of the SIM.
     */
    @JvmName("jgimajrewxfinhja")
    public suspend fun simName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.simName = mapped
    }

    /**
     * @param value The SIM policy used by this SIM. The SIM policy must be in the same location as the SIM.
     */
    @JvmName("vqhcnxrdekwnjvau")
    public suspend fun simPolicy(`value`: SimPolicyResourceIdArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.simPolicy = mapped
    }

    /**
     * @param argument The SIM policy used by this SIM. The SIM policy must be in the same location as the SIM.
     */
    @JvmName("xsllmrtgjsptafvl")
    public suspend fun simPolicy(argument: suspend SimPolicyResourceIdArgsBuilder.() -> Unit) {
        val toBeMapped = SimPolicyResourceIdArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.simPolicy = mapped
    }

    /**
     * @param value A list of static IP addresses assigned to this SIM. Each address is assigned at a defined network scope, made up of {attached data network, slice}.
     */
    @JvmName("lvgxqrcleolxwhhm")
    public suspend fun staticIpConfiguration(`value`: List<SimStaticIpPropertiesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.staticIpConfiguration = mapped
    }

    /**
     * @param argument A list of static IP addresses assigned to this SIM. Each address is assigned at a defined network scope, made up of {attached data network, slice}.
     */
    @JvmName("dfthnrxjwlnnhllp")
    public suspend
    fun staticIpConfiguration(argument: List<suspend SimStaticIpPropertiesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SimStaticIpPropertiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.staticIpConfiguration = mapped
    }

    /**
     * @param argument A list of static IP addresses assigned to this SIM. Each address is assigned at a defined network scope, made up of {attached data network, slice}.
     */
    @JvmName("vhujitueafvvkivt")
    public suspend fun staticIpConfiguration(
        vararg
        argument: suspend SimStaticIpPropertiesArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            SimStaticIpPropertiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.staticIpConfiguration = mapped
    }

    /**
     * @param argument A list of static IP addresses assigned to this SIM. Each address is assigned at a defined network scope, made up of {attached data network, slice}.
     */
    @JvmName("ipdlumcwgekqdxht")
    public suspend
    fun staticIpConfiguration(argument: suspend SimStaticIpPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SimStaticIpPropertiesArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.staticIpConfiguration = mapped
    }

    /**
     * @param values A list of static IP addresses assigned to this SIM. Each address is assigned at a defined network scope, made up of {attached data network, slice}.
     */
    @JvmName("xkgmswetwphnmuwb")
    public suspend fun staticIpConfiguration(vararg values: SimStaticIpPropertiesArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.staticIpConfiguration = mapped
    }

    internal fun build(): SimArgs = SimArgs(
        authenticationKey = authenticationKey,
        deviceType = deviceType,
        integratedCircuitCardIdentifier = integratedCircuitCardIdentifier,
        internationalMobileSubscriberIdentity = internationalMobileSubscriberIdentity,
        operatorKeyCode = operatorKeyCode,
        resourceGroupName = resourceGroupName,
        simGroupName = simGroupName,
        simName = simName,
        simPolicy = simPolicy,
        staticIpConfiguration = staticIpConfiguration,
    )
}
