@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin

import com.pulumi.azurenative.mobilenetwork.SimPolicyArgs.builder
import com.pulumi.azurenative.mobilenetwork.kotlin.inputs.AmbrArgs
import com.pulumi.azurenative.mobilenetwork.kotlin.inputs.AmbrArgsBuilder
import com.pulumi.azurenative.mobilenetwork.kotlin.inputs.SliceConfigurationArgs
import com.pulumi.azurenative.mobilenetwork.kotlin.inputs.SliceConfigurationArgsBuilder
import com.pulumi.azurenative.mobilenetwork.kotlin.inputs.SliceResourceIdArgs
import com.pulumi.azurenative.mobilenetwork.kotlin.inputs.SliceResourceIdArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * SIM policy resource.
 * Azure REST API version: 2023-06-01. Prior API version in Azure Native 1.x: 2022-04-01-preview.
 * Other available API versions: 2022-04-01-preview, 2022-11-01, 2023-09-01.
 * ## Example Usage
 * ### Create SIM policy
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var simPolicy = new AzureNative.MobileNetwork.SimPolicy("simPolicy", new()
 *     {
 *         DefaultSlice = new AzureNative.MobileNetwork.Inputs.SliceResourceIdArgs
 *         {
 *             Id = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobileNetwork/mobileNetworks/testMobileNetwork/slices/testSlice",
 *         },
 *         Location = "eastus",
 *         MobileNetworkName = "testMobileNetwork",
 *         RegistrationTimer = 3240,
 *         ResourceGroupName = "rg1",
 *         SimPolicyName = "testPolicy",
 *         SliceConfigurations = new[]
 *         {
 *             new AzureNative.MobileNetwork.Inputs.SliceConfigurationArgs
 *             {
 *                 DataNetworkConfigurations = new[]
 *                 {
 *                     new AzureNative.MobileNetwork.Inputs.DataNetworkConfigurationArgs
 *                     {
 *                         AdditionalAllowedSessionTypes = new() { },
 *                         AllocationAndRetentionPriorityLevel = 9,
 *                         AllowedServices = new[]
 *                         {
 *                             new AzureNative.MobileNetwork.Inputs.ServiceResourceIdArgs
 *                             {
 *                                 Id = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobileNetwork/mobileNetworks/testMobileNetwork/services/testService",
 *                             },
 *                         },
 *                         DataNetwork = new AzureNative.MobileNetwork.Inputs.DataNetworkResourceIdArgs
 *                         {
 *                             Id = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobileNetwork/mobileNetworks/testMobileNetwork/dataNetworks/testdataNetwork",
 *                         },
 *                         DefaultSessionType = "IPv4",
 *                         FiveQi = 9,
 *                         MaximumNumberOfBufferedPackets = 200,
 *                         PreemptionCapability = "NotPreempt",
 *                         PreemptionVulnerability = "Preemptable",
 *                         SessionAmbr = new AzureNative.MobileNetwork.Inputs.AmbrArgs
 *                         {
 *                             Downlink = "1 Gbps",
 *                             Uplink = "500 Mbps",
 *                         },
 *                     },
 *                 },
 *                 DefaultDataNetwork = new AzureNative.MobileNetwork.Inputs.DataNetworkResourceIdArgs
 *                 {
 *                     Id = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobileNetwork/mobileNetworks/testMobileNetwork/dataNetworks/testdataNetwork",
 *                 },
 *                 Slice = new AzureNative.MobileNetwork.Inputs.SliceResourceIdArgs
 *                 {
 *                     Id = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobileNetwork/mobileNetworks/testMobileNetwork/slices/testSlice",
 *                 },
 *             },
 *         },
 *         UeAmbr = new AzureNative.MobileNetwork.Inputs.AmbrArgs
 *         {
 *             Downlink = "1 Gbps",
 *             Uplink = "500 Mbps",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/mobilenetwork/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := mobilenetwork.NewSimPolicy(ctx, "simPolicy", &mobilenetwork.SimPolicyArgs{
 * 			DefaultSlice: &mobilenetwork.SliceResourceIdArgs{
 * 				Id: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobileNetwork/mobileNetworks/testMobileNetwork/slices/testSlice"),
 * 			},
 * 			Location:          pulumi.String("eastus"),
 * 			MobileNetworkName: pulumi.String("testMobileNetwork"),
 * 			RegistrationTimer: pulumi.Int(3240),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			SimPolicyName:     pulumi.String("testPolicy"),
 * 			SliceConfigurations: []mobilenetwork.SliceConfigurationArgs{
 * 				{
 * 					DataNetworkConfigurations: mobilenetwork.DataNetworkConfigurationArray{
 * 						{
 * 							AdditionalAllowedSessionTypes:       pulumi.StringArray{},
 * 							AllocationAndRetentionPriorityLevel: pulumi.Int(9),
 * 							AllowedServices: mobilenetwork.ServiceResourceIdArray{
 * 								{
 * 									Id: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobileNetwork/mobileNetworks/testMobileNetwork/services/testService"),
 * 								},
 * 							},
 * 							DataNetwork: {
 * 								Id: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobileNetwork/mobileNetworks/testMobileNetwork/dataNetworks/testdataNetwork"),
 * 							},
 * 							DefaultSessionType:             pulumi.String("IPv4"),
 * 							FiveQi:                         pulumi.Int(9),
 * 							MaximumNumberOfBufferedPackets: pulumi.Int(200),
 * 							PreemptionCapability:           pulumi.String("NotPreempt"),
 * 							PreemptionVulnerability:        pulumi.String("Preemptable"),
 * 							SessionAmbr: {
 * 								Downlink: pulumi.String("1 Gbps"),
 * 								Uplink:   pulumi.String("500 Mbps"),
 * 							},
 * 						},
 * 					},
 * 					DefaultDataNetwork: {
 * 						Id: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobileNetwork/mobileNetworks/testMobileNetwork/dataNetworks/testdataNetwork"),
 * 					},
 * 					Slice: {
 * 						Id: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobileNetwork/mobileNetworks/testMobileNetwork/slices/testSlice"),
 * 					},
 * 				},
 * 			},
 * 			UeAmbr: &mobilenetwork.AmbrArgs{
 * 				Downlink: pulumi.String("1 Gbps"),
 * 				Uplink:   pulumi.String("500 Mbps"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.mobilenetwork.SimPolicy;
 * import com.pulumi.azurenative.mobilenetwork.SimPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var simPolicy = new SimPolicy("simPolicy", SimPolicyArgs.builder()
 *             .defaultSlice(Map.of("id", "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobileNetwork/mobileNetworks/testMobileNetwork/slices/testSlice"))
 *             .location("eastus")
 *             .mobileNetworkName("testMobileNetwork")
 *             .registrationTimer(3240)
 *             .resourceGroupName("rg1")
 *             .simPolicyName("testPolicy")
 *             .sliceConfigurations(Map.ofEntries(
 *                 Map.entry("dataNetworkConfigurations", Map.ofEntries(
 *                     Map.entry("additionalAllowedSessionTypes", ),
 *                     Map.entry("allocationAndRetentionPriorityLevel", 9),
 *                     Map.entry("allowedServices", Map.of("id", "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobileNetwork/mobileNetworks/testMobileNetwork/services/testService")),
 *                     Map.entry("dataNetwork", Map.of("id", "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobileNetwork/mobileNetworks/testMobileNetwork/dataNetworks/testdataNetwork")),
 *                     Map.entry("defaultSessionType", "IPv4"),
 *                     Map.entry("fiveQi", 9),
 *                     Map.entry("maximumNumberOfBufferedPackets", 200),
 *                     Map.entry("preemptionCapability", "NotPreempt"),
 *                     Map.entry("preemptionVulnerability", "Preemptable"),
 *                     Map.entry("sessionAmbr", Map.ofEntries(
 *                         Map.entry("downlink", "1 Gbps"),
 *                         Map.entry("uplink", "500 Mbps")
 *                     ))
 *                 )),
 *                 Map.entry("defaultDataNetwork", Map.of("id", "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobileNetwork/mobileNetworks/testMobileNetwork/dataNetworks/testdataNetwork")),
 *                 Map.entry("slice", Map.of("id", "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobileNetwork/mobileNetworks/testMobileNetwork/slices/testSlice"))
 *             ))
 *             .ueAmbr(Map.ofEntries(
 *                 Map.entry("downlink", "1 Gbps"),
 *                 Map.entry("uplink", "500 Mbps")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:mobilenetwork:SimPolicy testPolicy /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileNetwork/mobileNetworks/{mobileNetworkName}/simPolicies/{simPolicyName}
 * ```
 * @property defaultSlice The default slice to use if the UE does not explicitly specify it. This slice must exist in the `sliceConfigurations` map. The slice must be in the same location as the SIM policy.
 * @property location The geo-location where the resource lives
 * @property mobileNetworkName The name of the mobile network.
 * @property registrationTimer UE periodic registration update timer (5G) or UE periodic tracking area update timer (4G), in seconds.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property rfspIndex RAT/Frequency Selection Priority Index, defined in 3GPP TS 36.413. This is an optional setting and by default is unspecified.
 * @property simPolicyName The name of the SIM policy.
 * @property sliceConfigurations The allowed slices and the settings to use for them. The list must not contain duplicate items and must contain at least one item.
 * @property tags Resource tags.
 * @property ueAmbr Aggregate maximum bit rate across all non-GBR QoS flows of all PDU sessions of a given UE. See 3GPP TS23.501 section 5.7.2.6 for a full description of the UE-AMBR.
 */
public data class SimPolicyArgs(
    public val defaultSlice: Output<SliceResourceIdArgs>? = null,
    public val location: Output<String>? = null,
    public val mobileNetworkName: Output<String>? = null,
    public val registrationTimer: Output<Int>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val rfspIndex: Output<Int>? = null,
    public val simPolicyName: Output<String>? = null,
    public val sliceConfigurations: Output<List<SliceConfigurationArgs>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val ueAmbr: Output<AmbrArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.mobilenetwork.SimPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.mobilenetwork.SimPolicyArgs =
        com.pulumi.azurenative.mobilenetwork.SimPolicyArgs.builder()
            .defaultSlice(defaultSlice?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .mobileNetworkName(mobileNetworkName?.applyValue({ args0 -> args0 }))
            .registrationTimer(registrationTimer?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .rfspIndex(rfspIndex?.applyValue({ args0 -> args0 }))
            .simPolicyName(simPolicyName?.applyValue({ args0 -> args0 }))
            .sliceConfigurations(
                sliceConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .ueAmbr(ueAmbr?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [SimPolicyArgs].
 */
@PulumiTagMarker
public class SimPolicyArgsBuilder internal constructor() {
    private var defaultSlice: Output<SliceResourceIdArgs>? = null

    private var location: Output<String>? = null

    private var mobileNetworkName: Output<String>? = null

    private var registrationTimer: Output<Int>? = null

    private var resourceGroupName: Output<String>? = null

    private var rfspIndex: Output<Int>? = null

    private var simPolicyName: Output<String>? = null

    private var sliceConfigurations: Output<List<SliceConfigurationArgs>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var ueAmbr: Output<AmbrArgs>? = null

    /**
     * @param value The default slice to use if the UE does not explicitly specify it. This slice must exist in the `sliceConfigurations` map. The slice must be in the same location as the SIM policy.
     */
    @JvmName("wpgfesunaqvwuduw")
    public suspend fun defaultSlice(`value`: Output<SliceResourceIdArgs>) {
        this.defaultSlice = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("tuuyeftwxkuruhgy")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the mobile network.
     */
    @JvmName("msadihcqsdwrtffq")
    public suspend fun mobileNetworkName(`value`: Output<String>) {
        this.mobileNetworkName = value
    }

    /**
     * @param value UE periodic registration update timer (5G) or UE periodic tracking area update timer (4G), in seconds.
     */
    @JvmName("pweokwfuveecrfpu")
    public suspend fun registrationTimer(`value`: Output<Int>) {
        this.registrationTimer = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("knogeoakulpedpka")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value RAT/Frequency Selection Priority Index, defined in 3GPP TS 36.413. This is an optional setting and by default is unspecified.
     */
    @JvmName("uldvpomxtfwghqkf")
    public suspend fun rfspIndex(`value`: Output<Int>) {
        this.rfspIndex = value
    }

    /**
     * @param value The name of the SIM policy.
     */
    @JvmName("vownwhhoqsjrugvq")
    public suspend fun simPolicyName(`value`: Output<String>) {
        this.simPolicyName = value
    }

    /**
     * @param value The allowed slices and the settings to use for them. The list must not contain duplicate items and must contain at least one item.
     */
    @JvmName("ewmscmdmfekrlhwk")
    public suspend fun sliceConfigurations(`value`: Output<List<SliceConfigurationArgs>>) {
        this.sliceConfigurations = value
    }

    @JvmName("sximwmcxdypppgvx")
    public suspend fun sliceConfigurations(vararg values: Output<SliceConfigurationArgs>) {
        this.sliceConfigurations = Output.all(values.asList())
    }

    /**
     * @param values The allowed slices and the settings to use for them. The list must not contain duplicate items and must contain at least one item.
     */
    @JvmName("duohbvbofaemcyet")
    public suspend fun sliceConfigurations(values: List<Output<SliceConfigurationArgs>>) {
        this.sliceConfigurations = Output.all(values)
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("vnqvahgmhbttiduy")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Aggregate maximum bit rate across all non-GBR QoS flows of all PDU sessions of a given UE. See 3GPP TS23.501 section 5.7.2.6 for a full description of the UE-AMBR.
     */
    @JvmName("qykncekacjwhqsqg")
    public suspend fun ueAmbr(`value`: Output<AmbrArgs>) {
        this.ueAmbr = value
    }

    /**
     * @param value The default slice to use if the UE does not explicitly specify it. This slice must exist in the `sliceConfigurations` map. The slice must be in the same location as the SIM policy.
     */
    @JvmName("jnqikfakjirlklrw")
    public suspend fun defaultSlice(`value`: SliceResourceIdArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultSlice = mapped
    }

    /**
     * @param argument The default slice to use if the UE does not explicitly specify it. This slice must exist in the `sliceConfigurations` map. The slice must be in the same location as the SIM policy.
     */
    @JvmName("nlhchsnxftvqnrpv")
    public suspend fun defaultSlice(argument: suspend SliceResourceIdArgsBuilder.() -> Unit) {
        val toBeMapped = SliceResourceIdArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.defaultSlice = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("yuikayhamtqqesuq")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the mobile network.
     */
    @JvmName("wtqtshyfgyhxbsuj")
    public suspend fun mobileNetworkName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mobileNetworkName = mapped
    }

    /**
     * @param value UE periodic registration update timer (5G) or UE periodic tracking area update timer (4G), in seconds.
     */
    @JvmName("yeyvrcckymxahltm")
    public suspend fun registrationTimer(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.registrationTimer = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("fjgxxyaerklsqvmc")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value RAT/Frequency Selection Priority Index, defined in 3GPP TS 36.413. This is an optional setting and by default is unspecified.
     */
    @JvmName("pqvvxbqivdxkqrxo")
    public suspend fun rfspIndex(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rfspIndex = mapped
    }

    /**
     * @param value The name of the SIM policy.
     */
    @JvmName("ynbdmgpprivanacq")
    public suspend fun simPolicyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.simPolicyName = mapped
    }

    /**
     * @param value The allowed slices and the settings to use for them. The list must not contain duplicate items and must contain at least one item.
     */
    @JvmName("nxammrmvrtmvclxj")
    public suspend fun sliceConfigurations(`value`: List<SliceConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sliceConfigurations = mapped
    }

    /**
     * @param argument The allowed slices and the settings to use for them. The list must not contain duplicate items and must contain at least one item.
     */
    @JvmName("qhykqkwwpuilphrj")
    public suspend
    fun sliceConfigurations(argument: List<suspend SliceConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SliceConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.sliceConfigurations = mapped
    }

    /**
     * @param argument The allowed slices and the settings to use for them. The list must not contain duplicate items and must contain at least one item.
     */
    @JvmName("sxsantwkhcisjcmp")
    public suspend fun sliceConfigurations(
        vararg
        argument: suspend SliceConfigurationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            SliceConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.sliceConfigurations = mapped
    }

    /**
     * @param argument The allowed slices and the settings to use for them. The list must not contain duplicate items and must contain at least one item.
     */
    @JvmName("heltmxsggbngoejd")
    public suspend
    fun sliceConfigurations(argument: suspend SliceConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SliceConfigurationArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.sliceConfigurations = mapped
    }

    /**
     * @param values The allowed slices and the settings to use for them. The list must not contain duplicate items and must contain at least one item.
     */
    @JvmName("hkurcafcomojymay")
    public suspend fun sliceConfigurations(vararg values: SliceConfigurationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sliceConfigurations = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("pfdhwykifyjqyrsv")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("iyndnstdbhgjgemc")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Aggregate maximum bit rate across all non-GBR QoS flows of all PDU sessions of a given UE. See 3GPP TS23.501 section 5.7.2.6 for a full description of the UE-AMBR.
     */
    @JvmName("kknpgcrbgaynrfyp")
    public suspend fun ueAmbr(`value`: AmbrArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ueAmbr = mapped
    }

    /**
     * @param argument Aggregate maximum bit rate across all non-GBR QoS flows of all PDU sessions of a given UE. See 3GPP TS23.501 section 5.7.2.6 for a full description of the UE-AMBR.
     */
    @JvmName("twxontfqxotoldvm")
    public suspend fun ueAmbr(argument: suspend AmbrArgsBuilder.() -> Unit) {
        val toBeMapped = AmbrArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.ueAmbr = mapped
    }

    internal fun build(): SimPolicyArgs = SimPolicyArgs(
        defaultSlice = defaultSlice,
        location = location,
        mobileNetworkName = mobileNetworkName,
        registrationTimer = registrationTimer,
        resourceGroupName = resourceGroupName,
        rfspIndex = rfspIndex,
        simPolicyName = simPolicyName,
        sliceConfigurations = sliceConfigurations,
        tags = tags,
        ueAmbr = ueAmbr,
    )
}
