@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin

import com.pulumi.azurenative.mobilenetwork.SiteArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Site resource. Must be created in the same location as its parent mobile network.
 * Azure REST API version: 2023-06-01. Prior API version in Azure Native 1.x: 2022-04-01-preview.
 * Other available API versions: 2022-04-01-preview, 2022-11-01, 2023-09-01.
 * ## Example Usage
 * ### Create mobile network site
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var site = new AzureNative.MobileNetwork.Site("site", new()
 *     {
 *         Location = "testLocation",
 *         MobileNetworkName = "testMobileNetwork",
 *         ResourceGroupName = "rg1",
 *         SiteName = "testSite",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/mobilenetwork/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := mobilenetwork.NewSite(ctx, "site", &mobilenetwork.SiteArgs{
 * 			Location:          pulumi.String("testLocation"),
 * 			MobileNetworkName: pulumi.String("testMobileNetwork"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			SiteName:          pulumi.String("testSite"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.mobilenetwork.Site;
 * import com.pulumi.azurenative.mobilenetwork.SiteArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var site = new Site("site", SiteArgs.builder()
 *             .location("testLocation")
 *             .mobileNetworkName("testMobileNetwork")
 *             .resourceGroupName("rg1")
 *             .siteName("testSite")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:mobilenetwork:Site testSite /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileNetwork/mobileNetworks/{mobileNetworkName}/sites/{siteName}
 * ```
 * @property location The geo-location where the resource lives
 * @property mobileNetworkName The name of the mobile network.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property siteName The name of the mobile network site.
 * @property tags Resource tags.
 */
public data class SiteArgs(
    public val location: Output<String>? = null,
    public val mobileNetworkName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val siteName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.mobilenetwork.SiteArgs> {
    override fun toJava(): com.pulumi.azurenative.mobilenetwork.SiteArgs =
        com.pulumi.azurenative.mobilenetwork.SiteArgs.builder()
            .location(location?.applyValue({ args0 -> args0 }))
            .mobileNetworkName(mobileNetworkName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .siteName(siteName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [SiteArgs].
 */
@PulumiTagMarker
public class SiteArgsBuilder internal constructor() {
    private var location: Output<String>? = null

    private var mobileNetworkName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var siteName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("jukbtyvfhhpbbbga")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the mobile network.
     */
    @JvmName("bkbisafmnbfmrpml")
    public suspend fun mobileNetworkName(`value`: Output<String>) {
        this.mobileNetworkName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ewxrttomdtrxchqk")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the mobile network site.
     */
    @JvmName("kyleyiyekjpknogc")
    public suspend fun siteName(`value`: Output<String>) {
        this.siteName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("wfrgrxevbakljbgh")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("kgkscapmxxoiqblq")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the mobile network.
     */
    @JvmName("odnwtgwkauxxvsjh")
    public suspend fun mobileNetworkName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mobileNetworkName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ubkdxjvmtlnsyfkm")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the mobile network site.
     */
    @JvmName("hbkbaqpmrsyqtoak")
    public suspend fun siteName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.siteName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("bpfcwtvfjungbeox")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("ghwwtxyxuurcowuj")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): SiteArgs = SiteArgs(
        location = location,
        mobileNetworkName = mobileNetworkName,
        resourceGroupName = resourceGroupName,
        siteName = siteName,
        tags = tags,
    )
}
