@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The core network technology generation (5G core or EPC / 4G core).
 */
public enum class CoreNetworkType(
    public val javaValue: com.pulumi.azurenative.mobilenetwork.enums.CoreNetworkType,
) : ConvertibleToJava<com.pulumi.azurenative.mobilenetwork.enums.CoreNetworkType> {
    /**
     * 5G core
     */
    _5GC(com.pulumi.azurenative.mobilenetwork.enums.CoreNetworkType._5GC),

    /**
     * EPC / 4G core
     */
    EPC(com.pulumi.azurenative.mobilenetwork.enums.CoreNetworkType.EPC),

    /**
     * Combined EPC / 4G and 5G core
     */
    EPC_5GC(com.pulumi.azurenative.mobilenetwork.enums.CoreNetworkType.EPC_5GC),
    ;

    override fun toJava(): com.pulumi.azurenative.mobilenetwork.enums.CoreNetworkType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.mobilenetwork.enums.CoreNetworkType):
            CoreNetworkType = CoreNetworkType.values().first { it.javaValue == javaType }
    }
}
