@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Type of managed service identity (currently only UserAssigned allowed).
 */
public enum class ManagedServiceIdentityType(
    public val javaValue: com.pulumi.azurenative.mobilenetwork.enums.ManagedServiceIdentityType,
) : ConvertibleToJava<com.pulumi.azurenative.mobilenetwork.enums.ManagedServiceIdentityType> {
    None(com.pulumi.azurenative.mobilenetwork.enums.ManagedServiceIdentityType.None),
    UserAssigned(com.pulumi.azurenative.mobilenetwork.enums.ManagedServiceIdentityType.UserAssigned),
    ;

    override fun toJava(): com.pulumi.azurenative.mobilenetwork.enums.ManagedServiceIdentityType =
        javaValue

    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.mobilenetwork.enums.ManagedServiceIdentityType):
            ManagedServiceIdentityType =
            ManagedServiceIdentityType.values().first { it.javaValue == javaType }
    }
}
