@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin.inputs

import com.pulumi.azurenative.mobilenetwork.inputs.DataNetworkResourceIdArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Reference to a data network resource.
 * @property id Data network resource ID.
 */
public data class DataNetworkResourceIdArgs(
    public val id: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.mobilenetwork.inputs.DataNetworkResourceIdArgs> {
    override fun toJava(): com.pulumi.azurenative.mobilenetwork.inputs.DataNetworkResourceIdArgs =
        com.pulumi.azurenative.mobilenetwork.inputs.DataNetworkResourceIdArgs.builder()
            .id(id.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataNetworkResourceIdArgs].
 */
@PulumiTagMarker
public class DataNetworkResourceIdArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    /**
     * @param value Data network resource ID.
     */
    @JvmName("casxxhvifsnpfhcm")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Data network resource ID.
     */
    @JvmName("jbgpkkrwuemtmsgq")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.id = mapped
    }

    internal fun build(): DataNetworkResourceIdArgs = DataNetworkResourceIdArgs(
        id = id ?: throw PulumiNullFieldException("id"),
    )
}
