@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin.inputs

import com.pulumi.azurenative.mobilenetwork.inputs.GetAttachedDataNetworkPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property attachedDataNetworkName The name of the attached data network.
 * @property packetCoreControlPlaneName The name of the packet core control plane.
 * @property packetCoreDataPlaneName The name of the packet core data plane.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetAttachedDataNetworkPlainArgs(
    public val attachedDataNetworkName: String,
    public val packetCoreControlPlaneName: String,
    public val packetCoreDataPlaneName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.mobilenetwork.inputs.GetAttachedDataNetworkPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.mobilenetwork.inputs.GetAttachedDataNetworkPlainArgs =
        com.pulumi.azurenative.mobilenetwork.inputs.GetAttachedDataNetworkPlainArgs.builder()
            .attachedDataNetworkName(attachedDataNetworkName.let({ args0 -> args0 }))
            .packetCoreControlPlaneName(packetCoreControlPlaneName.let({ args0 -> args0 }))
            .packetCoreDataPlaneName(packetCoreDataPlaneName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAttachedDataNetworkPlainArgs].
 */
@PulumiTagMarker
public class GetAttachedDataNetworkPlainArgsBuilder internal constructor() {
    private var attachedDataNetworkName: String? = null

    private var packetCoreControlPlaneName: String? = null

    private var packetCoreDataPlaneName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the attached data network.
     */
    @JvmName("edourdpawijjqfgr")
    public suspend fun attachedDataNetworkName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.attachedDataNetworkName = mapped
    }

    /**
     * @param value The name of the packet core control plane.
     */
    @JvmName("rwiwfnavwlflwund")
    public suspend fun packetCoreControlPlaneName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.packetCoreControlPlaneName = mapped
    }

    /**
     * @param value The name of the packet core data plane.
     */
    @JvmName("yvmyibdcwrbbtvqq")
    public suspend fun packetCoreDataPlaneName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.packetCoreDataPlaneName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("imnydwkecdbuyndk")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetAttachedDataNetworkPlainArgs = GetAttachedDataNetworkPlainArgs(
        attachedDataNetworkName = attachedDataNetworkName ?: throw
            PulumiNullFieldException("attachedDataNetworkName"),
        packetCoreControlPlaneName = packetCoreControlPlaneName ?: throw
            PulumiNullFieldException("packetCoreControlPlaneName"),
        packetCoreDataPlaneName = packetCoreDataPlaneName ?: throw
            PulumiNullFieldException("packetCoreDataPlaneName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
