@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin.inputs

import com.pulumi.azurenative.mobilenetwork.inputs.GetSimPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property simGroupName The name of the SIM Group.
 * @property simName The name of the SIM.
 */
public data class GetSimPlainArgs(
    public val resourceGroupName: String,
    public val simGroupName: String,
    public val simName: String,
) : ConvertibleToJava<com.pulumi.azurenative.mobilenetwork.inputs.GetSimPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.mobilenetwork.inputs.GetSimPlainArgs =
        com.pulumi.azurenative.mobilenetwork.inputs.GetSimPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .simGroupName(simGroupName.let({ args0 -> args0 }))
            .simName(simName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSimPlainArgs].
 */
@PulumiTagMarker
public class GetSimPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var simGroupName: String? = null

    private var simName: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("qvtjypfnndmcsbqu")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the SIM Group.
     */
    @JvmName("twqokitdhgxppqwc")
    public suspend fun simGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.simGroupName = mapped
    }

    /**
     * @param value The name of the SIM.
     */
    @JvmName("liidslqbupungyui")
    public suspend fun simName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.simName = mapped
    }

    internal fun build(): GetSimPlainArgs = GetSimPlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        simGroupName = simGroupName ?: throw PulumiNullFieldException("simGroupName"),
        simName = simName ?: throw PulumiNullFieldException("simName"),
    )
}
