@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin.inputs

import com.pulumi.azurenative.mobilenetwork.inputs.PlatformConfigurationArgs.builder
import com.pulumi.azurenative.mobilenetwork.kotlin.enums.PlatformType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The platform where the packet core is deployed.
 * @property azureStackEdgeDevice The Azure Stack Edge device where the packet core is deployed. If the device is part of a fault tolerant pair, either device in the pair can be specified.
 * @property azureStackHciCluster The Azure Stack HCI cluster where the packet core is deployed.
 * @property connectedCluster Azure Arc connected cluster where the packet core is deployed.
 * @property customLocation Azure Arc custom location where the packet core is deployed.
 * @property type The platform type where packet core is deployed.
 */
public data class PlatformConfigurationArgs(
    public val azureStackEdgeDevice: Output<AzureStackEdgeDeviceResourceIdArgs>? = null,
    public val azureStackHciCluster: Output<AzureStackHCIClusterResourceIdArgs>? = null,
    public val connectedCluster: Output<ConnectedClusterResourceIdArgs>? = null,
    public val customLocation: Output<CustomLocationResourceIdArgs>? = null,
    public val type: Output<Either<String, PlatformType>>,
) : ConvertibleToJava<com.pulumi.azurenative.mobilenetwork.inputs.PlatformConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.mobilenetwork.inputs.PlatformConfigurationArgs =
        com.pulumi.azurenative.mobilenetwork.inputs.PlatformConfigurationArgs.builder()
            .azureStackEdgeDevice(
                azureStackEdgeDevice?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .azureStackHciCluster(
                azureStackHciCluster?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .connectedCluster(connectedCluster?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .customLocation(customLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .type(
                type.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [PlatformConfigurationArgs].
 */
@PulumiTagMarker
public class PlatformConfigurationArgsBuilder internal constructor() {
    private var azureStackEdgeDevice: Output<AzureStackEdgeDeviceResourceIdArgs>? = null

    private var azureStackHciCluster: Output<AzureStackHCIClusterResourceIdArgs>? = null

    private var connectedCluster: Output<ConnectedClusterResourceIdArgs>? = null

    private var customLocation: Output<CustomLocationResourceIdArgs>? = null

    private var type: Output<Either<String, PlatformType>>? = null

    /**
     * @param value The Azure Stack Edge device where the packet core is deployed. If the device is part of a fault tolerant pair, either device in the pair can be specified.
     */
    @JvmName("cmbndhqhoxgjcrci")
    public suspend fun azureStackEdgeDevice(`value`: Output<AzureStackEdgeDeviceResourceIdArgs>) {
        this.azureStackEdgeDevice = value
    }

    /**
     * @param value The Azure Stack HCI cluster where the packet core is deployed.
     */
    @JvmName("emuwdsmrgsnvfmie")
    public suspend fun azureStackHciCluster(`value`: Output<AzureStackHCIClusterResourceIdArgs>) {
        this.azureStackHciCluster = value
    }

    /**
     * @param value Azure Arc connected cluster where the packet core is deployed.
     */
    @JvmName("ggoaynrrosdqllwj")
    public suspend fun connectedCluster(`value`: Output<ConnectedClusterResourceIdArgs>) {
        this.connectedCluster = value
    }

    /**
     * @param value Azure Arc custom location where the packet core is deployed.
     */
    @JvmName("glaxgubmuxjexqsk")
    public suspend fun customLocation(`value`: Output<CustomLocationResourceIdArgs>) {
        this.customLocation = value
    }

    /**
     * @param value The platform type where packet core is deployed.
     */
    @JvmName("riqvkxnlxbpyjqwp")
    public suspend fun type(`value`: Output<Either<String, PlatformType>>) {
        this.type = value
    }

    /**
     * @param value The Azure Stack Edge device where the packet core is deployed. If the device is part of a fault tolerant pair, either device in the pair can be specified.
     */
    @JvmName("kgrpgnxekqydvnmh")
    public suspend fun azureStackEdgeDevice(`value`: AzureStackEdgeDeviceResourceIdArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureStackEdgeDevice = mapped
    }

    /**
     * @param argument The Azure Stack Edge device where the packet core is deployed. If the device is part of a fault tolerant pair, either device in the pair can be specified.
     */
    @JvmName("eppltxhuswitaeie")
    public suspend
    fun azureStackEdgeDevice(argument: suspend AzureStackEdgeDeviceResourceIdArgsBuilder.() -> Unit) {
        val toBeMapped = AzureStackEdgeDeviceResourceIdArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.azureStackEdgeDevice = mapped
    }

    /**
     * @param value The Azure Stack HCI cluster where the packet core is deployed.
     */
    @JvmName("ndixndprlndglssp")
    public suspend fun azureStackHciCluster(`value`: AzureStackHCIClusterResourceIdArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureStackHciCluster = mapped
    }

    /**
     * @param argument The Azure Stack HCI cluster where the packet core is deployed.
     */
    @JvmName("fctnakgareruknpf")
    public suspend
    fun azureStackHciCluster(argument: suspend AzureStackHCIClusterResourceIdArgsBuilder.() -> Unit) {
        val toBeMapped = AzureStackHCIClusterResourceIdArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.azureStackHciCluster = mapped
    }

    /**
     * @param value Azure Arc connected cluster where the packet core is deployed.
     */
    @JvmName("lxikpxcokrxwnuug")
    public suspend fun connectedCluster(`value`: ConnectedClusterResourceIdArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectedCluster = mapped
    }

    /**
     * @param argument Azure Arc connected cluster where the packet core is deployed.
     */
    @JvmName("pyyoagrwunlycaop")
    public suspend
    fun connectedCluster(argument: suspend ConnectedClusterResourceIdArgsBuilder.() -> Unit) {
        val toBeMapped = ConnectedClusterResourceIdArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.connectedCluster = mapped
    }

    /**
     * @param value Azure Arc custom location where the packet core is deployed.
     */
    @JvmName("pukgqwhnrmguplgi")
    public suspend fun customLocation(`value`: CustomLocationResourceIdArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customLocation = mapped
    }

    /**
     * @param argument Azure Arc custom location where the packet core is deployed.
     */
    @JvmName("ubincvodrnvobtym")
    public suspend
    fun customLocation(argument: suspend CustomLocationResourceIdArgsBuilder.() -> Unit) {
        val toBeMapped = CustomLocationResourceIdArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.customLocation = mapped
    }

    /**
     * @param value The platform type where packet core is deployed.
     */
    @JvmName("drtcjvqsmrijaaqo")
    public suspend fun type(`value`: Either<String, PlatformType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The platform type where packet core is deployed.
     */
    @JvmName("fbmrglxwjoynnsuh")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PlatformType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The platform type where packet core is deployed.
     */
    @JvmName("scjxdyfmkfakjcvr")
    public fun type(`value`: PlatformType) {
        val toBeMapped = Either.ofRight<String, PlatformType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): PlatformConfigurationArgs = PlatformConfigurationArgs(
        azureStackEdgeDevice = azureStackEdgeDevice,
        azureStackHciCluster = azureStackHciCluster,
        connectedCluster = connectedCluster,
        customLocation = customLocation,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
