@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin.inputs

import com.pulumi.azurenative.mobilenetwork.inputs.PlmnIdArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Public land mobile network (PLMN) ID.
 * @property mcc Mobile country code (MCC).
 * @property mnc Mobile network code (MNC).
 */
public data class PlmnIdArgs(
    public val mcc: Output<String>,
    public val mnc: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.mobilenetwork.inputs.PlmnIdArgs> {
    override fun toJava(): com.pulumi.azurenative.mobilenetwork.inputs.PlmnIdArgs =
        com.pulumi.azurenative.mobilenetwork.inputs.PlmnIdArgs.builder()
            .mcc(mcc.applyValue({ args0 -> args0 }))
            .mnc(mnc.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PlmnIdArgs].
 */
@PulumiTagMarker
public class PlmnIdArgsBuilder internal constructor() {
    private var mcc: Output<String>? = null

    private var mnc: Output<String>? = null

    /**
     * @param value Mobile country code (MCC).
     */
    @JvmName("mmrerdgxuiluctxf")
    public suspend fun mcc(`value`: Output<String>) {
        this.mcc = value
    }

    /**
     * @param value Mobile network code (MNC).
     */
    @JvmName("hvprrsxqwsjiwecl")
    public suspend fun mnc(`value`: Output<String>) {
        this.mnc = value
    }

    /**
     * @param value Mobile country code (MCC).
     */
    @JvmName("upimkkynjejdqlee")
    public suspend fun mcc(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mcc = mapped
    }

    /**
     * @param value Mobile network code (MNC).
     */
    @JvmName("aofdseifvblmtrgo")
    public suspend fun mnc(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mnc = mapped
    }

    internal fun build(): PlmnIdArgs = PlmnIdArgs(
        mcc = mcc ?: throw PulumiNullFieldException("mcc"),
        mnc = mnc ?: throw PulumiNullFieldException("mnc"),
    )
}
