@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin.inputs

import com.pulumi.azurenative.mobilenetwork.inputs.QosPolicyArgs.builder
import com.pulumi.azurenative.mobilenetwork.kotlin.enums.PreemptionCapability
import com.pulumi.azurenative.mobilenetwork.kotlin.enums.PreemptionVulnerability
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * QoS policy
 * @property allocationAndRetentionPriorityLevel QoS Flow allocation and retention priority (ARP) level. Flows with higher priority preempt flows with lower priority, if the settings of `preemptionCapability` and `preemptionVulnerability` allow it. 1 is the highest level of priority. If this field is not specified then `5qi` is used to derive the ARP value. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
 * @property fiveQi 5G QoS Flow Indicator value. The 5QI identifies a specific QoS forwarding treatment to be provided to a flow. See 3GPP TS23.501 section 5.7.2.1 for a full description of the 5QI parameter, and table 5.7.4-1 for the definition the 5QI values.
 * @property maximumBitRate The maximum bit rate (MBR) for all service data flows that use this data flow policy rule or service.
 * @property preemptionCapability QoS Flow preemption capability. The preemption capability of a QoS Flow controls whether it can preempt another QoS Flow with a lower priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
 * @property preemptionVulnerability QoS Flow preemption vulnerability. The preemption vulnerability of a QoS Flow controls whether it can be preempted by a QoS Flow with a higher priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
 */
public data class QosPolicyArgs(
    public val allocationAndRetentionPriorityLevel: Output<Int>? = null,
    public val fiveQi: Output<Int>? = null,
    public val maximumBitRate: Output<AmbrArgs>,
    public val preemptionCapability: Output<Either<String, PreemptionCapability>>? = null,
    public val preemptionVulnerability: Output<Either<String, PreemptionVulnerability>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.mobilenetwork.inputs.QosPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.mobilenetwork.inputs.QosPolicyArgs =
        com.pulumi.azurenative.mobilenetwork.inputs.QosPolicyArgs.builder()
            .allocationAndRetentionPriorityLevel(
                allocationAndRetentionPriorityLevel?.applyValue({ args0 ->
                    args0
                }),
            )
            .fiveQi(fiveQi?.applyValue({ args0 -> args0 }))
            .maximumBitRate(maximumBitRate.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .preemptionCapability(
                preemptionCapability?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .preemptionVulnerability(
                preemptionVulnerability?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            ).build()
}

/**
 * Builder for [QosPolicyArgs].
 */
@PulumiTagMarker
public class QosPolicyArgsBuilder internal constructor() {
    private var allocationAndRetentionPriorityLevel: Output<Int>? = null

    private var fiveQi: Output<Int>? = null

    private var maximumBitRate: Output<AmbrArgs>? = null

    private var preemptionCapability: Output<Either<String, PreemptionCapability>>? = null

    private var preemptionVulnerability: Output<Either<String, PreemptionVulnerability>>? = null

    /**
     * @param value QoS Flow allocation and retention priority (ARP) level. Flows with higher priority preempt flows with lower priority, if the settings of `preemptionCapability` and `preemptionVulnerability` allow it. 1 is the highest level of priority. If this field is not specified then `5qi` is used to derive the ARP value. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
     */
    @JvmName("wfypdumhwtcxmnco")
    public suspend fun allocationAndRetentionPriorityLevel(`value`: Output<Int>) {
        this.allocationAndRetentionPriorityLevel = value
    }

    /**
     * @param value 5G QoS Flow Indicator value. The 5QI identifies a specific QoS forwarding treatment to be provided to a flow. See 3GPP TS23.501 section 5.7.2.1 for a full description of the 5QI parameter, and table 5.7.4-1 for the definition the 5QI values.
     */
    @JvmName("boabmedoirscfylh")
    public suspend fun fiveQi(`value`: Output<Int>) {
        this.fiveQi = value
    }

    /**
     * @param value The maximum bit rate (MBR) for all service data flows that use this data flow policy rule or service.
     */
    @JvmName("rahvbvmvfcxvluuy")
    public suspend fun maximumBitRate(`value`: Output<AmbrArgs>) {
        this.maximumBitRate = value
    }

    /**
     * @param value QoS Flow preemption capability. The preemption capability of a QoS Flow controls whether it can preempt another QoS Flow with a lower priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
     */
    @JvmName("ximammfrgxuwweuf")
    public suspend fun preemptionCapability(`value`: Output<Either<String, PreemptionCapability>>) {
        this.preemptionCapability = value
    }

    /**
     * @param value QoS Flow preemption vulnerability. The preemption vulnerability of a QoS Flow controls whether it can be preempted by a QoS Flow with a higher priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
     */
    @JvmName("twpkajhwabjcdcng")
    public suspend
    fun preemptionVulnerability(`value`: Output<Either<String, PreemptionVulnerability>>) {
        this.preemptionVulnerability = value
    }

    /**
     * @param value QoS Flow allocation and retention priority (ARP) level. Flows with higher priority preempt flows with lower priority, if the settings of `preemptionCapability` and `preemptionVulnerability` allow it. 1 is the highest level of priority. If this field is not specified then `5qi` is used to derive the ARP value. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
     */
    @JvmName("wxphcskbwqfywbdu")
    public suspend fun allocationAndRetentionPriorityLevel(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allocationAndRetentionPriorityLevel = mapped
    }

    /**
     * @param value 5G QoS Flow Indicator value. The 5QI identifies a specific QoS forwarding treatment to be provided to a flow. See 3GPP TS23.501 section 5.7.2.1 for a full description of the 5QI parameter, and table 5.7.4-1 for the definition the 5QI values.
     */
    @JvmName("sewakwovbmvtjmqv")
    public suspend fun fiveQi(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fiveQi = mapped
    }

    /**
     * @param value The maximum bit rate (MBR) for all service data flows that use this data flow policy rule or service.
     */
    @JvmName("avybroqqyjnlaelr")
    public suspend fun maximumBitRate(`value`: AmbrArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.maximumBitRate = mapped
    }

    /**
     * @param argument The maximum bit rate (MBR) for all service data flows that use this data flow policy rule or service.
     */
    @JvmName("ppjmagojmremwuns")
    public suspend fun maximumBitRate(argument: suspend AmbrArgsBuilder.() -> Unit) {
        val toBeMapped = AmbrArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.maximumBitRate = mapped
    }

    /**
     * @param value QoS Flow preemption capability. The preemption capability of a QoS Flow controls whether it can preempt another QoS Flow with a lower priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
     */
    @JvmName("moqjvikugdiunqwx")
    public suspend fun preemptionCapability(`value`: Either<String, PreemptionCapability>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preemptionCapability = mapped
    }

    /**
     * @param value QoS Flow preemption capability. The preemption capability of a QoS Flow controls whether it can preempt another QoS Flow with a lower priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
     */
    @JvmName("lbshhvbgtltwkece")
    public fun preemptionCapability(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PreemptionCapability>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.preemptionCapability = mapped
    }

    /**
     * @param value QoS Flow preemption capability. The preemption capability of a QoS Flow controls whether it can preempt another QoS Flow with a lower priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
     */
    @JvmName("mtvgssewstctqxmj")
    public fun preemptionCapability(`value`: PreemptionCapability) {
        val toBeMapped = Either.ofRight<String, PreemptionCapability>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.preemptionCapability = mapped
    }

    /**
     * @param value QoS Flow preemption vulnerability. The preemption vulnerability of a QoS Flow controls whether it can be preempted by a QoS Flow with a higher priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
     */
    @JvmName("yyhalankfjvwduio")
    public suspend fun preemptionVulnerability(`value`: Either<String, PreemptionVulnerability>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preemptionVulnerability = mapped
    }

    /**
     * @param value QoS Flow preemption vulnerability. The preemption vulnerability of a QoS Flow controls whether it can be preempted by a QoS Flow with a higher priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
     */
    @JvmName("maksvhutwyjcopkl")
    public fun preemptionVulnerability(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PreemptionVulnerability>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.preemptionVulnerability = mapped
    }

    /**
     * @param value QoS Flow preemption vulnerability. The preemption vulnerability of a QoS Flow controls whether it can be preempted by a QoS Flow with a higher priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
     */
    @JvmName("kyigjhiwrcvvbkqr")
    public fun preemptionVulnerability(`value`: PreemptionVulnerability) {
        val toBeMapped = Either.ofRight<String, PreemptionVulnerability>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.preemptionVulnerability = mapped
    }

    internal fun build(): QosPolicyArgs = QosPolicyArgs(
        allocationAndRetentionPriorityLevel = allocationAndRetentionPriorityLevel,
        fiveQi = fiveQi,
        maximumBitRate = maximumBitRate ?: throw PulumiNullFieldException("maximumBitRate"),
        preemptionCapability = preemptionCapability,
        preemptionVulnerability = preemptionVulnerability,
    )
}
