@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin.inputs

import com.pulumi.azurenative.mobilenetwork.inputs.SimStaticIpPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Static IP configuration for a SIM, scoped to a particular attached data network and slice.
 * @property attachedDataNetwork The attached data network on which the static IP address will be used. The combination of attached data network and slice defines the network scope of the IP address. The attached data network must be in the same location as the SIM.
 * @property slice The network slice on which the static IP address will be used. The combination of attached data network and slice defines the network scope of the IP address. The slice must be in the same location as the SIM.
 * @property staticIp The static IP configuration for the SIM to use at the defined network scope.
 */
public data class SimStaticIpPropertiesArgs(
    public val attachedDataNetwork: Output<AttachedDataNetworkResourceIdArgs>? = null,
    public val slice: Output<SliceResourceIdArgs>? = null,
    public val staticIp: Output<SimStaticIpPropertiesStaticIpArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.mobilenetwork.inputs.SimStaticIpPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.mobilenetwork.inputs.SimStaticIpPropertiesArgs =
        com.pulumi.azurenative.mobilenetwork.inputs.SimStaticIpPropertiesArgs.builder()
            .attachedDataNetwork(
                attachedDataNetwork?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .slice(slice?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .staticIp(staticIp?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [SimStaticIpPropertiesArgs].
 */
@PulumiTagMarker
public class SimStaticIpPropertiesArgsBuilder internal constructor() {
    private var attachedDataNetwork: Output<AttachedDataNetworkResourceIdArgs>? = null

    private var slice: Output<SliceResourceIdArgs>? = null

    private var staticIp: Output<SimStaticIpPropertiesStaticIpArgs>? = null

    /**
     * @param value The attached data network on which the static IP address will be used. The combination of attached data network and slice defines the network scope of the IP address. The attached data network must be in the same location as the SIM.
     */
    @JvmName("yknmeptyybgcosjx")
    public suspend fun attachedDataNetwork(`value`: Output<AttachedDataNetworkResourceIdArgs>) {
        this.attachedDataNetwork = value
    }

    /**
     * @param value The network slice on which the static IP address will be used. The combination of attached data network and slice defines the network scope of the IP address. The slice must be in the same location as the SIM.
     */
    @JvmName("gviuthgyawgkxlcf")
    public suspend fun slice(`value`: Output<SliceResourceIdArgs>) {
        this.slice = value
    }

    /**
     * @param value The static IP configuration for the SIM to use at the defined network scope.
     */
    @JvmName("kjcckbbkkouttecf")
    public suspend fun staticIp(`value`: Output<SimStaticIpPropertiesStaticIpArgs>) {
        this.staticIp = value
    }

    /**
     * @param value The attached data network on which the static IP address will be used. The combination of attached data network and slice defines the network scope of the IP address. The attached data network must be in the same location as the SIM.
     */
    @JvmName("ohcruogwhgncuxhh")
    public suspend fun attachedDataNetwork(`value`: AttachedDataNetworkResourceIdArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.attachedDataNetwork = mapped
    }

    /**
     * @param argument The attached data network on which the static IP address will be used. The combination of attached data network and slice defines the network scope of the IP address. The attached data network must be in the same location as the SIM.
     */
    @JvmName("iibahpdurawyopnb")
    public suspend
    fun attachedDataNetwork(argument: suspend AttachedDataNetworkResourceIdArgsBuilder.() -> Unit) {
        val toBeMapped = AttachedDataNetworkResourceIdArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.attachedDataNetwork = mapped
    }

    /**
     * @param value The network slice on which the static IP address will be used. The combination of attached data network and slice defines the network scope of the IP address. The slice must be in the same location as the SIM.
     */
    @JvmName("hfifkrrmgtdltyhy")
    public suspend fun slice(`value`: SliceResourceIdArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.slice = mapped
    }

    /**
     * @param argument The network slice on which the static IP address will be used. The combination of attached data network and slice defines the network scope of the IP address. The slice must be in the same location as the SIM.
     */
    @JvmName("ykbnmnkwlblkjutp")
    public suspend fun slice(argument: suspend SliceResourceIdArgsBuilder.() -> Unit) {
        val toBeMapped = SliceResourceIdArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.slice = mapped
    }

    /**
     * @param value The static IP configuration for the SIM to use at the defined network scope.
     */
    @JvmName("ftkxnvrsudapvsbf")
    public suspend fun staticIp(`value`: SimStaticIpPropertiesStaticIpArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.staticIp = mapped
    }

    /**
     * @param argument The static IP configuration for the SIM to use at the defined network scope.
     */
    @JvmName("fatlovrrsdscccte")
    public suspend
    fun staticIp(argument: suspend SimStaticIpPropertiesStaticIpArgsBuilder.() -> Unit) {
        val toBeMapped = SimStaticIpPropertiesStaticIpArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.staticIp = mapped
    }

    internal fun build(): SimStaticIpPropertiesArgs = SimStaticIpPropertiesArgs(
        attachedDataNetwork = attachedDataNetwork,
        slice = slice,
        staticIp = staticIp,
    )
}
