@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin.inputs

import com.pulumi.azurenative.mobilenetwork.inputs.SimStaticIpPropertiesStaticIpArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The static IP configuration for the SIM to use at the defined network scope.
 * @property ipv4Address The IPv4 address assigned to the SIM at this network scope. This address must be in the userEquipmentStaticAddressPoolPrefix defined in the attached data network.
 */
public data class SimStaticIpPropertiesStaticIpArgs(
    public val ipv4Address: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.mobilenetwork.inputs.SimStaticIpPropertiesStaticIpArgs> {
    override fun toJava():
        com.pulumi.azurenative.mobilenetwork.inputs.SimStaticIpPropertiesStaticIpArgs =
        com.pulumi.azurenative.mobilenetwork.inputs.SimStaticIpPropertiesStaticIpArgs.builder()
            .ipv4Address(ipv4Address?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SimStaticIpPropertiesStaticIpArgs].
 */
@PulumiTagMarker
public class SimStaticIpPropertiesStaticIpArgsBuilder internal constructor() {
    private var ipv4Address: Output<String>? = null

    /**
     * @param value The IPv4 address assigned to the SIM at this network scope. This address must be in the userEquipmentStaticAddressPoolPrefix defined in the attached data network.
     */
    @JvmName("gvjdtswldyuthpim")
    public suspend fun ipv4Address(`value`: Output<String>) {
        this.ipv4Address = value
    }

    /**
     * @param value The IPv4 address assigned to the SIM at this network scope. This address must be in the userEquipmentStaticAddressPoolPrefix defined in the attached data network.
     */
    @JvmName("oisdjkattouclklx")
    public suspend fun ipv4Address(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv4Address = mapped
    }

    internal fun build(): SimStaticIpPropertiesStaticIpArgs = SimStaticIpPropertiesStaticIpArgs(
        ipv4Address = ipv4Address,
    )
}
