@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin.inputs

import com.pulumi.azurenative.mobilenetwork.inputs.SliceConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Per-slice settings
 * @property dataNetworkConfigurations The allowed data networks and the settings to use for them. The list must not contain duplicate items and must contain at least one item.
 * @property defaultDataNetwork The default data network to use if the UE does not explicitly specify it. Configuration for this object must exist in the `dataNetworkConfigurations` map. The data network must be in the same location as the SIM policy.
 * @property slice A reference to the slice that these settings apply to. The slice must be in the same location as the SIM policy.
 */
public data class SliceConfigurationArgs(
    public val dataNetworkConfigurations: Output<List<DataNetworkConfigurationArgs>>,
    public val defaultDataNetwork: Output<DataNetworkResourceIdArgs>,
    public val slice: Output<SliceResourceIdArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.mobilenetwork.inputs.SliceConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.mobilenetwork.inputs.SliceConfigurationArgs =
        com.pulumi.azurenative.mobilenetwork.inputs.SliceConfigurationArgs.builder()
            .dataNetworkConfigurations(
                dataNetworkConfigurations.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .defaultDataNetwork(
                defaultDataNetwork.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .slice(slice.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [SliceConfigurationArgs].
 */
@PulumiTagMarker
public class SliceConfigurationArgsBuilder internal constructor() {
    private var dataNetworkConfigurations: Output<List<DataNetworkConfigurationArgs>>? = null

    private var defaultDataNetwork: Output<DataNetworkResourceIdArgs>? = null

    private var slice: Output<SliceResourceIdArgs>? = null

    /**
     * @param value The allowed data networks and the settings to use for them. The list must not contain duplicate items and must contain at least one item.
     */
    @JvmName("cnvafioafqfqfqew")
    public suspend
    fun dataNetworkConfigurations(`value`: Output<List<DataNetworkConfigurationArgs>>) {
        this.dataNetworkConfigurations = value
    }

    @JvmName("vmastaeuhhctbxpt")
    public suspend fun dataNetworkConfigurations(
        vararg
        values: Output<DataNetworkConfigurationArgs>,
    ) {
        this.dataNetworkConfigurations = Output.all(values.asList())
    }

    /**
     * @param values The allowed data networks and the settings to use for them. The list must not contain duplicate items and must contain at least one item.
     */
    @JvmName("viccjluemdjkvrtf")
    public suspend fun dataNetworkConfigurations(values: List<Output<DataNetworkConfigurationArgs>>) {
        this.dataNetworkConfigurations = Output.all(values)
    }

    /**
     * @param value The default data network to use if the UE does not explicitly specify it. Configuration for this object must exist in the `dataNetworkConfigurations` map. The data network must be in the same location as the SIM policy.
     */
    @JvmName("ptfqnkkuphaoxens")
    public suspend fun defaultDataNetwork(`value`: Output<DataNetworkResourceIdArgs>) {
        this.defaultDataNetwork = value
    }

    /**
     * @param value A reference to the slice that these settings apply to. The slice must be in the same location as the SIM policy.
     */
    @JvmName("vqktkhswvsxvevbc")
    public suspend fun slice(`value`: Output<SliceResourceIdArgs>) {
        this.slice = value
    }

    /**
     * @param value The allowed data networks and the settings to use for them. The list must not contain duplicate items and must contain at least one item.
     */
    @JvmName("nkwqewyycsucubtm")
    public suspend fun dataNetworkConfigurations(`value`: List<DataNetworkConfigurationArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataNetworkConfigurations = mapped
    }

    /**
     * @param argument The allowed data networks and the settings to use for them. The list must not contain duplicate items and must contain at least one item.
     */
    @JvmName("csunrfcagpwjcpxb")
    public suspend
    fun dataNetworkConfigurations(argument: List<suspend DataNetworkConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DataNetworkConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dataNetworkConfigurations = mapped
    }

    /**
     * @param argument The allowed data networks and the settings to use for them. The list must not contain duplicate items and must contain at least one item.
     */
    @JvmName("wdmysupqjrwtjwjp")
    public suspend fun dataNetworkConfigurations(
        vararg
        argument: suspend DataNetworkConfigurationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            DataNetworkConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dataNetworkConfigurations = mapped
    }

    /**
     * @param argument The allowed data networks and the settings to use for them. The list must not contain duplicate items and must contain at least one item.
     */
    @JvmName("txkysgapgkrphmjw")
    public suspend
    fun dataNetworkConfigurations(argument: suspend DataNetworkConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            DataNetworkConfigurationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.dataNetworkConfigurations = mapped
    }

    /**
     * @param values The allowed data networks and the settings to use for them. The list must not contain duplicate items and must contain at least one item.
     */
    @JvmName("ovgetpsquxipjciu")
    public suspend fun dataNetworkConfigurations(vararg values: DataNetworkConfigurationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataNetworkConfigurations = mapped
    }

    /**
     * @param value The default data network to use if the UE does not explicitly specify it. Configuration for this object must exist in the `dataNetworkConfigurations` map. The data network must be in the same location as the SIM policy.
     */
    @JvmName("gxpuqkwblbhnildk")
    public suspend fun defaultDataNetwork(`value`: DataNetworkResourceIdArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.defaultDataNetwork = mapped
    }

    /**
     * @param argument The default data network to use if the UE does not explicitly specify it. Configuration for this object must exist in the `dataNetworkConfigurations` map. The data network must be in the same location as the SIM policy.
     */
    @JvmName("roqivrhnumprllda")
    public suspend
    fun defaultDataNetwork(argument: suspend DataNetworkResourceIdArgsBuilder.() -> Unit) {
        val toBeMapped = DataNetworkResourceIdArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.defaultDataNetwork = mapped
    }

    /**
     * @param value A reference to the slice that these settings apply to. The slice must be in the same location as the SIM policy.
     */
    @JvmName("wmtxalyovwuyfvay")
    public suspend fun slice(`value`: SliceResourceIdArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.slice = mapped
    }

    /**
     * @param argument A reference to the slice that these settings apply to. The slice must be in the same location as the SIM policy.
     */
    @JvmName("bfswabybpffhytav")
    public suspend fun slice(argument: suspend SliceResourceIdArgsBuilder.() -> Unit) {
        val toBeMapped = SliceResourceIdArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.slice = mapped
    }

    internal fun build(): SliceConfigurationArgs = SliceConfigurationArgs(
        dataNetworkConfigurations = dataNetworkConfigurations ?: throw
            PulumiNullFieldException("dataNetworkConfigurations"),
        defaultDataNetwork = defaultDataNetwork ?: throw PulumiNullFieldException("defaultDataNetwork"),
        slice = slice ?: throw PulumiNullFieldException("slice"),
    )
}
