@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Certificate provisioning state
 * @property reason Reason for certificate provisioning failure.
 * @property state The certificate's provisioning state
 */
public data class CertificateProvisioningResponse(
    public val reason: String,
    public val state: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.mobilenetwork.outputs.CertificateProvisioningResponse):
            CertificateProvisioningResponse = CertificateProvisioningResponse(
            reason = javaType.reason(),
            state = javaType.state(),
        )
    }
}
