@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The installation state of the packet core.
 * @property desiredState The desired installation state
 * @property operation A reference to an in-progress installation operation
 * @property reasons Reason(s) for the current installation state of the packet core.
 * @property reinstallRequired Whether a reinstall of the packet core is required to pick up the latest configuration changes.
 * @property state Installation state
 */
public data class InstallationResponse(
    public val desiredState: String? = null,
    public val operation: AsyncOperationIdResponse,
    public val reasons: List<String>,
    public val reinstallRequired: String,
    public val state: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.mobilenetwork.outputs.InstallationResponse):
            InstallationResponse = InstallationResponse(
            desiredState = javaType.desiredState().map({ args0 -> args0 }).orElse(null),
            operation = javaType.operation().let({ args0 ->
                com.pulumi.azurenative.mobilenetwork.kotlin.outputs.AsyncOperationIdResponse.Companion.toKotlin(args0)
            }),
            reasons = javaType.reasons().map({ args0 -> args0 }),
            reinstallRequired = javaType.reinstallRequired(),
            state = javaType.state(),
        )
    }
}
