@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Data flow policy rule configuration
 * @property ruleName The name of the rule. This must be unique within the parent service. You must not use any of the following reserved strings - `default`, `requested` or `service`.
 * @property rulePrecedence A precedence value that is used to decide between data flow policy rules when identifying the QoS values to use for a particular SIM. A lower value means a higher priority. This value should be unique among all data flow policy rules configured in the mobile network.
 * @property ruleQosPolicy The QoS policy to use for packets matching this rule. If this field is null then the parent service will define the QoS settings.
 * @property serviceDataFlowTemplates The set of data flow templates to use for this data flow policy rule.
 * @property trafficControl Determines whether flows that match this data flow policy rule are permitted.
 */
public data class PccRuleConfigurationResponse(
    public val ruleName: String,
    public val rulePrecedence: Int,
    public val ruleQosPolicy: PccRuleQosPolicyResponse? = null,
    public val serviceDataFlowTemplates: List<ServiceDataFlowTemplateResponse>,
    public val trafficControl: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.mobilenetwork.outputs.PccRuleConfigurationResponse):
            PccRuleConfigurationResponse = PccRuleConfigurationResponse(
            ruleName = javaType.ruleName(),
            rulePrecedence = javaType.rulePrecedence(),
            ruleQosPolicy = javaType.ruleQosPolicy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.mobilenetwork.kotlin.outputs.PccRuleQosPolicyResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            serviceDataFlowTemplates = javaType.serviceDataFlowTemplates().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.mobilenetwork.kotlin.outputs.ServiceDataFlowTemplateResponse.Companion.toKotlin(args0)
                })
            }),
            trafficControl = javaType.trafficControl().map({ args0 -> args0 }).orElse(null),
        )
    }
}
