@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 * Expiry times of inactive NAPT pinholes, in seconds. All timers must be at least 1 second.
 * @property icmp Pinhole timeout for ICMP pinholes in seconds. Default for ICMP Echo is 30 seconds.
 * @property tcp Pinhole timeout for TCP pinholes in seconds. Default for TCP is 3 minutes.
 * @property udp Pinhole timeout for UDP pinholes in seconds. Default for UDP is 30 seconds.
 */
public data class PinholeTimeoutsResponse(
    public val icmp: Int? = null,
    public val tcp: Int? = null,
    public val udp: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.mobilenetwork.outputs.PinholeTimeoutsResponse):
            PinholeTimeoutsResponse = PinholeTimeoutsResponse(
            icmp = javaType.icmp().map({ args0 -> args0 }).orElse(null),
            tcp = javaType.tcp().map({ args0 -> args0 }).orElse(null),
            udp = javaType.udp().map({ args0 -> args0 }).orElse(null),
        )
    }
}
