@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The static IP configuration for the SIM to use at the defined network scope.
 * @property ipv4Address The IPv4 address assigned to the SIM at this network scope. This address must be in the userEquipmentStaticAddressPoolPrefix defined in the attached data network.
 */
public data class SimStaticIpPropertiesResponseStaticIp(
    public val ipv4Address: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.mobilenetwork.outputs.SimStaticIpPropertiesResponseStaticIp):
            SimStaticIpPropertiesResponseStaticIp = SimStaticIpPropertiesResponseStaticIp(
            ipv4Address = javaType.ipv4Address().map({ args0 -> args0 }).orElse(null),
        )
    }
}
