@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * Per-slice settings
 * @property dataNetworkConfigurations The allowed data networks and the settings to use for them. The list must not contain duplicate items and must contain at least one item.
 * @property defaultDataNetwork The default data network to use if the UE does not explicitly specify it. Configuration for this object must exist in the `dataNetworkConfigurations` map. The data network must be in the same location as the SIM policy.
 * @property slice A reference to the slice that these settings apply to. The slice must be in the same location as the SIM policy.
 */
public data class SliceConfigurationResponse(
    public val dataNetworkConfigurations: List<DataNetworkConfigurationResponse>,
    public val defaultDataNetwork: DataNetworkResourceIdResponse,
    public val slice: SliceResourceIdResponse,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.mobilenetwork.outputs.SliceConfigurationResponse):
            SliceConfigurationResponse = SliceConfigurationResponse(
            dataNetworkConfigurations = javaType.dataNetworkConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.mobilenetwork.kotlin.outputs.DataNetworkConfigurationResponse.Companion.toKotlin(args0)
                })
            }),
            defaultDataNetwork = javaType.defaultDataNetwork().let({ args0 ->
                com.pulumi.azurenative.mobilenetwork.kotlin.outputs.DataNetworkResourceIdResponse.Companion.toKotlin(args0)
            }),
            slice = javaType.slice().let({ args0 ->
                com.pulumi.azurenative.mobilenetwork.kotlin.outputs.SliceResourceIdResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
