@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilepacketcore.kotlin

import com.pulumi.azurenative.mobilepacketcore.MobilepacketcoreFunctions.getNetworkFunctionPlain
import com.pulumi.azurenative.mobilepacketcore.kotlin.inputs.GetNetworkFunctionPlainArgs
import com.pulumi.azurenative.mobilepacketcore.kotlin.inputs.GetNetworkFunctionPlainArgsBuilder
import com.pulumi.azurenative.mobilepacketcore.kotlin.outputs.GetNetworkFunctionResult
import com.pulumi.azurenative.mobilepacketcore.kotlin.outputs.GetNetworkFunctionResult.Companion.toKotlin
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

public object MobilepacketcoreFunctions {
    /**
     * Get a NetworkFunctionResource
     * Azure REST API version: 2023-05-15-preview.
     * @param argument null
     * @return AO5GC Network Function Resource
     */
    public suspend fun getNetworkFunction(argument: GetNetworkFunctionPlainArgs):
        GetNetworkFunctionResult = toKotlin(getNetworkFunctionPlain(argument.toJava()).await())

    /**
     * @see [getNetworkFunction].
     * @param networkFunctionName The name of the network function
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return AO5GC Network Function Resource
     */
    public suspend fun getNetworkFunction(networkFunctionName: String, resourceGroupName: String):
        GetNetworkFunctionResult {
        val argument = GetNetworkFunctionPlainArgs(
            networkFunctionName = networkFunctionName,
            resourceGroupName = resourceGroupName,
        )
        return toKotlin(getNetworkFunctionPlain(argument.toJava()).await())
    }

    /**
     * @see [getNetworkFunction].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;mobilepacketcore&#46;kotlin&#46;inputs&#46;GetNetworkFunctionPlainArgs].
     * @return AO5GC Network Function Resource
     */
    public suspend
    fun getNetworkFunction(argument: suspend GetNetworkFunctionPlainArgsBuilder.() -> Unit):
        GetNetworkFunctionResult {
        val builder = GetNetworkFunctionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return toKotlin(getNetworkFunctionPlain(builtArgument.toJava()).await())
    }
}
