@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.netapp.kotlin

import com.pulumi.azurenative.netapp.kotlin.outputs.AccountEncryptionResponse
import com.pulumi.azurenative.netapp.kotlin.outputs.ActiveDirectoryResponse
import com.pulumi.azurenative.netapp.kotlin.outputs.ManagedServiceIdentityResponse
import com.pulumi.azurenative.netapp.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.netapp.kotlin.outputs.AccountEncryptionResponse.Companion.toKotlin as accountEncryptionResponseToKotlin
import com.pulumi.azurenative.netapp.kotlin.outputs.ActiveDirectoryResponse.Companion.toKotlin as activeDirectoryResponseToKotlin
import com.pulumi.azurenative.netapp.kotlin.outputs.ManagedServiceIdentityResponse.Companion.toKotlin as managedServiceIdentityResponseToKotlin
import com.pulumi.azurenative.netapp.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Account].
 */
@PulumiTagMarker
public class AccountResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AccountArgs = AccountArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AccountArgsBuilder.() -> Unit) {
        val builder = AccountArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Account {
        val builtJavaResource = com.pulumi.azurenative.netapp.Account(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Account(builtJavaResource)
    }
}

/**
 * NetApp account resource
 * Azure REST API version: 2022-11-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2019-07-01, 2022-05-01, 2022-11-01-preview, 2023-05-01.
 * ## Example Usage
 * ### Accounts_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var account = new AzureNative.NetApp.Account("account", new()
 *     {
 *         AccountName = "account1",
 *         Location = "eastus",
 *         ResourceGroupName = "myRG",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/netapp/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := netapp.NewAccount(ctx, "account", &netapp.AccountArgs{
 * 			AccountName:       pulumi.String("account1"),
 * 			Location:          pulumi.String("eastus"),
 * 			ResourceGroupName: pulumi.String("myRG"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.netapp.Account;
 * import com.pulumi.azurenative.netapp.AccountArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var account = new Account("account", AccountArgs.builder()
 *             .accountName("account1")
 *             .location("eastus")
 *             .resourceGroupName("myRG")
 *             .build());
 *     }
 * }
 * ```
 * ### Accounts_CreateOrUpdateWithActiveDirectory
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var account = new AzureNative.NetApp.Account("account", new()
 *     {
 *         AccountName = "account1",
 *         ActiveDirectories = new[]
 *         {
 *             new AzureNative.NetApp.Inputs.ActiveDirectoryArgs
 *             {
 *                 AesEncryption = true,
 *                 Dns = "10.10.10.3, 10.10.10.4",
 *                 Domain = "10.10.10.3",
 *                 LdapOverTLS = false,
 *                 LdapSigning = false,
 *                 OrganizationalUnit = "OU=Engineering",
 *                 Password = "ad_password",
 *                 Site = "SiteName",
 *                 SmbServerName = "SMBServer",
 *                 Username = "ad_user_name",
 *             },
 *         },
 *         Location = "eastus",
 *         ResourceGroupName = "myRG",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/netapp/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := netapp.NewAccount(ctx, "account", &netapp.AccountArgs{
 * 			AccountName: pulumi.String("account1"),
 * 			ActiveDirectories: []netapp.ActiveDirectoryArgs{
 * 				{
 * 					AesEncryption:      pulumi.Bool(true),
 * 					Dns:                pulumi.String("10.10.10.3, 10.10.10.4"),
 * 					Domain:             pulumi.String("10.10.10.3"),
 * 					LdapOverTLS:        pulumi.Bool(false),
 * 					LdapSigning:        pulumi.Bool(false),
 * 					OrganizationalUnit: pulumi.String("OU=Engineering"),
 * 					Password:           pulumi.String("ad_password"),
 * 					Site:               pulumi.String("SiteName"),
 * 					SmbServerName:      pulumi.String("SMBServer"),
 * 					Username:           pulumi.String("ad_user_name"),
 * 				},
 * 			},
 * 			Location:          pulumi.String("eastus"),
 * 			ResourceGroupName: pulumi.String("myRG"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.netapp.Account;
 * import com.pulumi.azurenative.netapp.AccountArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var account = new Account("account", AccountArgs.builder()
 *             .accountName("account1")
 *             .activeDirectories(Map.ofEntries(
 *                 Map.entry("aesEncryption", true),
 *                 Map.entry("dns", "10.10.10.3, 10.10.10.4"),
 *                 Map.entry("domain", "10.10.10.3"),
 *                 Map.entry("ldapOverTLS", false),
 *                 Map.entry("ldapSigning", false),
 *                 Map.entry("organizationalUnit", "OU=Engineering"),
 *                 Map.entry("password", "ad_password"),
 *                 Map.entry("site", "SiteName"),
 *                 Map.entry("smbServerName", "SMBServer"),
 *                 Map.entry("username", "ad_user_name")
 *             ))
 *             .location("eastus")
 *             .resourceGroupName("myRG")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:netapp:Account account1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetApp/netAppAccounts/{accountName}
 * ```
 */
public class Account internal constructor(
    override val javaResource: com.pulumi.azurenative.netapp.Account,
) : KotlinCustomResource(javaResource, AccountMapper) {
    /**
     * Active Directories
     */
    public val activeDirectories: Output<List<ActiveDirectoryResponse>>?
        get() = javaResource.activeDirectories().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        activeDirectoryResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Shows the status of disableShowmount for all volumes under the subscription, null equals false
     */
    public val disableShowmount: Output<Boolean>
        get() = javaResource.disableShowmount().applyValue({ args0 -> args0 })

    /**
     * Encryption settings
     */
    public val encryption: Output<AccountEncryptionResponse>?
        get() = javaResource.encryption().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    accountEncryptionResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * A unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * The identity used for the resource.
     */
    public val identity: Output<ManagedServiceIdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    managedServiceIdentityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Azure lifecycle management
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object AccountMapper : ResourceMapper<Account> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.netapp.Account::class == javaResource::class

    override fun map(javaResource: Resource): Account = Account(
        javaResource as
            com.pulumi.azurenative.netapp.Account,
    )
}

/**
 * @see [Account].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Account].
 */
public suspend fun account(name: String, block: suspend AccountResourceBuilder.() -> Unit):
    Account {
    val builder = AccountResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Account].
 * @param name The _unique_ name of the resulting resource.
 */
public fun account(name: String): Account {
    val builder = AccountResourceBuilder()
    builder.name(name)
    return builder.build()
}
