@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.netapp.kotlin

import com.pulumi.azurenative.netapp.BackupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Backup of a Volume
 * Azure REST API version: 2022-11-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2022-11-01-preview.
 * ## Example Usage
 * ### Backups_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var backup = new AzureNative.NetApp.Backup("backup", new()
 *     {
 *         AccountName = "account1",
 *         BackupName = "backup1",
 *         Label = "myLabel",
 *         Location = "eastus",
 *         PoolName = "pool1",
 *         ResourceGroupName = "myRG",
 *         VolumeName = "volume1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/netapp/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := netapp.NewBackup(ctx, "backup", &netapp.BackupArgs{
 * 			AccountName:       pulumi.String("account1"),
 * 			BackupName:        pulumi.String("backup1"),
 * 			Label:             pulumi.String("myLabel"),
 * 			Location:          pulumi.String("eastus"),
 * 			PoolName:          pulumi.String("pool1"),
 * 			ResourceGroupName: pulumi.String("myRG"),
 * 			VolumeName:        pulumi.String("volume1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.netapp.Backup;
 * import com.pulumi.azurenative.netapp.BackupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var backup = new Backup("backup", BackupArgs.builder()
 *             .accountName("account1")
 *             .backupName("backup1")
 *             .label("myLabel")
 *             .location("eastus")
 *             .poolName("pool1")
 *             .resourceGroupName("myRG")
 *             .volumeName("volume1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:netapp:Backup account1/pool1/volume1/backup1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetApp/netAppAccounts/{accountName}/capacityPools/{poolName}/volumes/{volumeName}/backups/{backupName}
 * ```
 * @property accountName The name of the NetApp account
 * @property backupName The name of the backup
 * @property label Label for backup
 * @property location Resource location
 * @property poolName The name of the capacity pool
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property useExistingSnapshot Manual backup an already existing snapshot. This will always be false for scheduled backups and true/false for manual backups
 * @property volumeName The name of the volume
 */
public data class BackupArgs(
    public val accountName: Output<String>? = null,
    public val backupName: Output<String>? = null,
    public val label: Output<String>? = null,
    public val location: Output<String>? = null,
    public val poolName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val useExistingSnapshot: Output<Boolean>? = null,
    public val volumeName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.netapp.BackupArgs> {
    override fun toJava(): com.pulumi.azurenative.netapp.BackupArgs =
        com.pulumi.azurenative.netapp.BackupArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .backupName(backupName?.applyValue({ args0 -> args0 }))
            .label(label?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .poolName(poolName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .useExistingSnapshot(useExistingSnapshot?.applyValue({ args0 -> args0 }))
            .volumeName(volumeName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BackupArgs].
 */
@PulumiTagMarker
public class BackupArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var backupName: Output<String>? = null

    private var label: Output<String>? = null

    private var location: Output<String>? = null

    private var poolName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var useExistingSnapshot: Output<Boolean>? = null

    private var volumeName: Output<String>? = null

    /**
     * @param value The name of the NetApp account
     */
    @JvmName("lnfvtkrfteagtwca")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value The name of the backup
     */
    @JvmName("evuypuyfygrxlkke")
    public suspend fun backupName(`value`: Output<String>) {
        this.backupName = value
    }

    /**
     * @param value Label for backup
     */
    @JvmName("adsbexdocsxkartl")
    public suspend fun label(`value`: Output<String>) {
        this.label = value
    }

    /**
     * @param value Resource location
     */
    @JvmName("bicecagmcjrbpbtk")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the capacity pool
     */
    @JvmName("hakhxvlylksmfpmu")
    public suspend fun poolName(`value`: Output<String>) {
        this.poolName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("bfnqoaxxicnkhrov")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Manual backup an already existing snapshot. This will always be false for scheduled backups and true/false for manual backups
     */
    @JvmName("uvsqiaexdwdvrruw")
    public suspend fun useExistingSnapshot(`value`: Output<Boolean>) {
        this.useExistingSnapshot = value
    }

    /**
     * @param value The name of the volume
     */
    @JvmName("okbnrmdmjowbetpd")
    public suspend fun volumeName(`value`: Output<String>) {
        this.volumeName = value
    }

    /**
     * @param value The name of the NetApp account
     */
    @JvmName("lqqmskrrstewartj")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value The name of the backup
     */
    @JvmName("rdxdarfhwixdoxhp")
    public suspend fun backupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupName = mapped
    }

    /**
     * @param value Label for backup
     */
    @JvmName("diovpbivvmiccpmo")
    public suspend fun label(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.label = mapped
    }

    /**
     * @param value Resource location
     */
    @JvmName("tdfhemqxvlinejsn")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the capacity pool
     */
    @JvmName("cialdpfyckcitrkw")
    public suspend fun poolName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.poolName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("taxpsblehlhwglpr")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Manual backup an already existing snapshot. This will always be false for scheduled backups and true/false for manual backups
     */
    @JvmName("kvgcvomusvffftjd")
    public suspend fun useExistingSnapshot(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.useExistingSnapshot = mapped
    }

    /**
     * @param value The name of the volume
     */
    @JvmName("pynqnmrtyimlxsiu")
    public suspend fun volumeName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumeName = mapped
    }

    internal fun build(): BackupArgs = BackupArgs(
        accountName = accountName,
        backupName = backupName,
        label = label,
        location = location,
        poolName = poolName,
        resourceGroupName = resourceGroupName,
        useExistingSnapshot = useExistingSnapshot,
        volumeName = volumeName,
    )
}
