@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.netapp.kotlin

import com.pulumi.azurenative.netapp.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.netapp.kotlin.outputs.VolumeBackupsResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.netapp.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin
import com.pulumi.azurenative.netapp.kotlin.outputs.VolumeBackupsResponse.Companion.toKotlin as volumeBackupsResponseToKotlin

/**
 * Builder for [BackupPolicy].
 */
@PulumiTagMarker
public class BackupPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BackupPolicyArgs = BackupPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BackupPolicyArgsBuilder.() -> Unit) {
        val builder = BackupPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): BackupPolicy {
        val builtJavaResource = com.pulumi.azurenative.netapp.BackupPolicy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return BackupPolicy(builtJavaResource)
    }
}

/**
 * Backup policy information
 * Azure REST API version: 2022-11-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2021-04-01, 2021-04-01-preview, 2022-11-01-preview, 2023-05-01.
 * ## Example Usage
 * ### BackupPolicies_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var backupPolicy = new AzureNative.NetApp.BackupPolicy("backupPolicy", new()
 *     {
 *         AccountName = "account1",
 *         BackupPolicyName = "backupPolicyName",
 *         DailyBackupsToKeep = 10,
 *         Enabled = true,
 *         Location = "westus",
 *         MonthlyBackupsToKeep = 10,
 *         ResourceGroupName = "myRG",
 *         WeeklyBackupsToKeep = 10,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/netapp/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := netapp.NewBackupPolicy(ctx, "backupPolicy", &netapp.BackupPolicyArgs{
 * 			AccountName:          pulumi.String("account1"),
 * 			BackupPolicyName:     pulumi.String("backupPolicyName"),
 * 			DailyBackupsToKeep:   pulumi.Int(10),
 * 			Enabled:              pulumi.Bool(true),
 * 			Location:             pulumi.String("westus"),
 * 			MonthlyBackupsToKeep: pulumi.Int(10),
 * 			ResourceGroupName:    pulumi.String("myRG"),
 * 			WeeklyBackupsToKeep:  pulumi.Int(10),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.netapp.BackupPolicy;
 * import com.pulumi.azurenative.netapp.BackupPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var backupPolicy = new BackupPolicy("backupPolicy", BackupPolicyArgs.builder()
 *             .accountName("account1")
 *             .backupPolicyName("backupPolicyName")
 *             .dailyBackupsToKeep(10)
 *             .enabled(true)
 *             .location("westus")
 *             .monthlyBackupsToKeep(10)
 *             .resourceGroupName("myRG")
 *             .weeklyBackupsToKeep(10)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:netapp:BackupPolicy account1/backupPolicyName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetApp/netAppAccounts/{accountName}/backupPolicies/{backupPolicyName}
 * ```
 */
public class BackupPolicy internal constructor(
    override val javaResource: com.pulumi.azurenative.netapp.BackupPolicy,
) : KotlinCustomResource(javaResource, BackupPolicyMapper) {
    /**
     * Backup Policy Resource ID
     */
    public val backupPolicyId: Output<String>
        get() = javaResource.backupPolicyId().applyValue({ args0 -> args0 })

    /**
     * Daily backups count to keep
     */
    public val dailyBackupsToKeep: Output<Int>?
        get() = javaResource.dailyBackupsToKeep().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The property to decide policy is enabled or not
     */
    public val enabled: Output<Boolean>?
        get() = javaResource.enabled().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * A unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Monthly backups count to keep
     */
    public val monthlyBackupsToKeep: Output<Int>?
        get() = javaResource.monthlyBackupsToKeep().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Azure lifecycle management
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * A list of volumes assigned to this policy
     */
    public val volumeBackups: Output<List<VolumeBackupsResponse>>
        get() = javaResource.volumeBackups().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> volumeBackupsResponseToKotlin(args0) })
            })
        })

    /**
     * Volumes using current backup policy
     */
    public val volumesAssigned: Output<Int>
        get() = javaResource.volumesAssigned().applyValue({ args0 -> args0 })

    /**
     * Weekly backups count to keep
     */
    public val weeklyBackupsToKeep: Output<Int>?
        get() = javaResource.weeklyBackupsToKeep().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object BackupPolicyMapper : ResourceMapper<BackupPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.netapp.BackupPolicy::class == javaResource::class

    override fun map(javaResource: Resource): BackupPolicy = BackupPolicy(
        javaResource as
            com.pulumi.azurenative.netapp.BackupPolicy,
    )
}

/**
 * @see [BackupPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [BackupPolicy].
 */
public suspend fun backupPolicy(
    name: String,
    block: suspend BackupPolicyResourceBuilder.() -> Unit,
): BackupPolicy {
    val builder = BackupPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [BackupPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun backupPolicy(name: String): BackupPolicy {
    val builder = BackupPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
