@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.netapp.kotlin

import com.pulumi.azurenative.netapp.BackupPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Backup policy information
 * Azure REST API version: 2022-11-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2021-04-01, 2021-04-01-preview, 2022-11-01-preview, 2023-05-01.
 * ## Example Usage
 * ### BackupPolicies_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var backupPolicy = new AzureNative.NetApp.BackupPolicy("backupPolicy", new()
 *     {
 *         AccountName = "account1",
 *         BackupPolicyName = "backupPolicyName",
 *         DailyBackupsToKeep = 10,
 *         Enabled = true,
 *         Location = "westus",
 *         MonthlyBackupsToKeep = 10,
 *         ResourceGroupName = "myRG",
 *         WeeklyBackupsToKeep = 10,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/netapp/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := netapp.NewBackupPolicy(ctx, "backupPolicy", &netapp.BackupPolicyArgs{
 * 			AccountName:          pulumi.String("account1"),
 * 			BackupPolicyName:     pulumi.String("backupPolicyName"),
 * 			DailyBackupsToKeep:   pulumi.Int(10),
 * 			Enabled:              pulumi.Bool(true),
 * 			Location:             pulumi.String("westus"),
 * 			MonthlyBackupsToKeep: pulumi.Int(10),
 * 			ResourceGroupName:    pulumi.String("myRG"),
 * 			WeeklyBackupsToKeep:  pulumi.Int(10),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.netapp.BackupPolicy;
 * import com.pulumi.azurenative.netapp.BackupPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var backupPolicy = new BackupPolicy("backupPolicy", BackupPolicyArgs.builder()
 *             .accountName("account1")
 *             .backupPolicyName("backupPolicyName")
 *             .dailyBackupsToKeep(10)
 *             .enabled(true)
 *             .location("westus")
 *             .monthlyBackupsToKeep(10)
 *             .resourceGroupName("myRG")
 *             .weeklyBackupsToKeep(10)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:netapp:BackupPolicy account1/backupPolicyName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetApp/netAppAccounts/{accountName}/backupPolicies/{backupPolicyName}
 * ```
 * @property accountName The name of the NetApp account
 * @property backupPolicyName Backup policy Name which uniquely identify backup policy.
 * @property dailyBackupsToKeep Daily backups count to keep
 * @property enabled The property to decide policy is enabled or not
 * @property location The geo-location where the resource lives
 * @property monthlyBackupsToKeep Monthly backups count to keep
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 * @property weeklyBackupsToKeep Weekly backups count to keep
 */
public data class BackupPolicyArgs(
    public val accountName: Output<String>? = null,
    public val backupPolicyName: Output<String>? = null,
    public val dailyBackupsToKeep: Output<Int>? = null,
    public val enabled: Output<Boolean>? = null,
    public val location: Output<String>? = null,
    public val monthlyBackupsToKeep: Output<Int>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val weeklyBackupsToKeep: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.netapp.BackupPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.netapp.BackupPolicyArgs =
        com.pulumi.azurenative.netapp.BackupPolicyArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .backupPolicyName(backupPolicyName?.applyValue({ args0 -> args0 }))
            .dailyBackupsToKeep(dailyBackupsToKeep?.applyValue({ args0 -> args0 }))
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .monthlyBackupsToKeep(monthlyBackupsToKeep?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .weeklyBackupsToKeep(weeklyBackupsToKeep?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BackupPolicyArgs].
 */
@PulumiTagMarker
public class BackupPolicyArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var backupPolicyName: Output<String>? = null

    private var dailyBackupsToKeep: Output<Int>? = null

    private var enabled: Output<Boolean>? = null

    private var location: Output<String>? = null

    private var monthlyBackupsToKeep: Output<Int>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var weeklyBackupsToKeep: Output<Int>? = null

    /**
     * @param value The name of the NetApp account
     */
    @JvmName("glvspemkqlninkxw")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value Backup policy Name which uniquely identify backup policy.
     */
    @JvmName("iwcgjegkrwtqpjlx")
    public suspend fun backupPolicyName(`value`: Output<String>) {
        this.backupPolicyName = value
    }

    /**
     * @param value Daily backups count to keep
     */
    @JvmName("drqhgtsejdhidpdf")
    public suspend fun dailyBackupsToKeep(`value`: Output<Int>) {
        this.dailyBackupsToKeep = value
    }

    /**
     * @param value The property to decide policy is enabled or not
     */
    @JvmName("aecpqyfpndgsfjyt")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("tafccnoriepfiaqb")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Monthly backups count to keep
     */
    @JvmName("kuqavkyepfdhybcd")
    public suspend fun monthlyBackupsToKeep(`value`: Output<Int>) {
        this.monthlyBackupsToKeep = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("kplafhqkxpktjvqm")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("perswhfkealspwrl")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Weekly backups count to keep
     */
    @JvmName("awwowlgtmupngwgw")
    public suspend fun weeklyBackupsToKeep(`value`: Output<Int>) {
        this.weeklyBackupsToKeep = value
    }

    /**
     * @param value The name of the NetApp account
     */
    @JvmName("kvlugcypqhrunbfv")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value Backup policy Name which uniquely identify backup policy.
     */
    @JvmName("qrmxepdlkltufmni")
    public suspend fun backupPolicyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupPolicyName = mapped
    }

    /**
     * @param value Daily backups count to keep
     */
    @JvmName("sefqmhxfavaqbhhi")
    public suspend fun dailyBackupsToKeep(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dailyBackupsToKeep = mapped
    }

    /**
     * @param value The property to decide policy is enabled or not
     */
    @JvmName("xtwrjmyaskdvcddl")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("ygwuvvofhevvcums")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Monthly backups count to keep
     */
    @JvmName("gamswrbjwjymdmwk")
    public suspend fun monthlyBackupsToKeep(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.monthlyBackupsToKeep = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("hyqthpdpbbbashvn")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("haeduacdmurwkria")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("gmvibqqwyocajlwn")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Weekly backups count to keep
     */
    @JvmName("ahanpxbopgyxnmll")
    public suspend fun weeklyBackupsToKeep(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.weeklyBackupsToKeep = mapped
    }

    internal fun build(): BackupPolicyArgs = BackupPolicyArgs(
        accountName = accountName,
        backupPolicyName = backupPolicyName,
        dailyBackupsToKeep = dailyBackupsToKeep,
        enabled = enabled,
        location = location,
        monthlyBackupsToKeep = monthlyBackupsToKeep,
        resourceGroupName = resourceGroupName,
        tags = tags,
        weeklyBackupsToKeep = weeklyBackupsToKeep,
    )
}
