@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.netapp.kotlin

import com.pulumi.azurenative.netapp.PoolArgs.builder
import com.pulumi.azurenative.netapp.kotlin.enums.EncryptionType
import com.pulumi.azurenative.netapp.kotlin.enums.QosType
import com.pulumi.azurenative.netapp.kotlin.enums.ServiceLevel
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Double
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Capacity pool resource
 * Azure REST API version: 2022-11-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2017-08-15, 2019-07-01, 2022-11-01-preview, 2023-05-01.
 * ## Example Usage
 * ### Pools_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var pool = new AzureNative.NetApp.Pool("pool", new()
 *     {
 *         AccountName = "account1",
 *         Location = "eastus",
 *         PoolName = "pool1",
 *         QosType = "Auto",
 *         ResourceGroupName = "myRG",
 *         ServiceLevel = "Premium",
 *         Size = 4398046511104,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/netapp/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := netapp.NewPool(ctx, "pool", &netapp.PoolArgs{
 * 			AccountName:       pulumi.String("account1"),
 * 			Location:          pulumi.String("eastus"),
 * 			PoolName:          pulumi.String("pool1"),
 * 			QosType:           pulumi.String("Auto"),
 * 			ResourceGroupName: pulumi.String("myRG"),
 * 			ServiceLevel:      pulumi.String("Premium"),
 * 			Size:              pulumi.Float64(4398046511104),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.netapp.Pool;
 * import com.pulumi.azurenative.netapp.PoolArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var pool = new Pool("pool", PoolArgs.builder()
 *             .accountName("account1")
 *             .location("eastus")
 *             .poolName("pool1")
 *             .qosType("Auto")
 *             .resourceGroupName("myRG")
 *             .serviceLevel("Premium")
 *             .size(4398046511104)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:netapp:Pool account1/pool1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetApp/netAppAccounts/{accountName}/capacityPools/{poolName}
 * ```
 * @property accountName The name of the NetApp account
 * @property coolAccess If enabled (true) the pool can contain cool Access enabled volumes.
 * @property encryptionType Encryption type of the capacity pool, set encryption type for data at rest for this pool and all volumes in it. This value can only be set when creating new pool.
 * @property location The geo-location where the resource lives
 * @property poolName The name of the capacity pool
 * @property qosType The qos type of the pool
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceLevel The service level of the file system
 * @property size Provisioned size of the pool (in bytes). Allowed values are in 1TiB chunks (value must be multiply of 4398046511104).
 * @property tags Resource tags.
 */
public data class PoolArgs(
    public val accountName: Output<String>? = null,
    public val coolAccess: Output<Boolean>? = null,
    public val encryptionType: Output<Either<String, EncryptionType>>? = null,
    public val location: Output<String>? = null,
    public val poolName: Output<String>? = null,
    public val qosType: Output<Either<String, QosType>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serviceLevel: Output<Either<String, ServiceLevel>>? = null,
    public val size: Output<Double>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.netapp.PoolArgs> {
    override fun toJava(): com.pulumi.azurenative.netapp.PoolArgs =
        com.pulumi.azurenative.netapp.PoolArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .coolAccess(coolAccess?.applyValue({ args0 -> args0 }))
            .encryptionType(
                encryptionType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .poolName(poolName?.applyValue({ args0 -> args0 }))
            .qosType(
                qosType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serviceLevel(
                serviceLevel?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .size(size?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [PoolArgs].
 */
@PulumiTagMarker
public class PoolArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var coolAccess: Output<Boolean>? = null

    private var encryptionType: Output<Either<String, EncryptionType>>? = null

    private var location: Output<String>? = null

    private var poolName: Output<String>? = null

    private var qosType: Output<Either<String, QosType>>? = null

    private var resourceGroupName: Output<String>? = null

    private var serviceLevel: Output<Either<String, ServiceLevel>>? = null

    private var size: Output<Double>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of the NetApp account
     */
    @JvmName("jbwocldxmilrpttu")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value If enabled (true) the pool can contain cool Access enabled volumes.
     */
    @JvmName("colfwltibwbjpxqh")
    public suspend fun coolAccess(`value`: Output<Boolean>) {
        this.coolAccess = value
    }

    /**
     * @param value Encryption type of the capacity pool, set encryption type for data at rest for this pool and all volumes in it. This value can only be set when creating new pool.
     */
    @JvmName("fsahkhmfhhlefscl")
    public suspend fun encryptionType(`value`: Output<Either<String, EncryptionType>>) {
        this.encryptionType = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("nowfcwviowlcqunh")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the capacity pool
     */
    @JvmName("emqlyrmjbcojyqsa")
    public suspend fun poolName(`value`: Output<String>) {
        this.poolName = value
    }

    /**
     * @param value The qos type of the pool
     */
    @JvmName("frbntfhytjmbcthp")
    public suspend fun qosType(`value`: Output<Either<String, QosType>>) {
        this.qosType = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("liwetmcaqwqkqoyq")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The service level of the file system
     */
    @JvmName("qgtsdiamakdtpexr")
    public suspend fun serviceLevel(`value`: Output<Either<String, ServiceLevel>>) {
        this.serviceLevel = value
    }

    /**
     * @param value Provisioned size of the pool (in bytes). Allowed values are in 1TiB chunks (value must be multiply of 4398046511104).
     */
    @JvmName("imqhxjobfbmjhawu")
    public suspend fun size(`value`: Output<Double>) {
        this.size = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("hthdcixgdqefrfna")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the NetApp account
     */
    @JvmName("qahydnotphksqxsw")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value If enabled (true) the pool can contain cool Access enabled volumes.
     */
    @JvmName("cycsfivoqacscssi")
    public suspend fun coolAccess(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.coolAccess = mapped
    }

    /**
     * @param value Encryption type of the capacity pool, set encryption type for data at rest for this pool and all volumes in it. This value can only be set when creating new pool.
     */
    @JvmName("cyatpolpkqhsyvxw")
    public suspend fun encryptionType(`value`: Either<String, EncryptionType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionType = mapped
    }

    /**
     * @param value Encryption type of the capacity pool, set encryption type for data at rest for this pool and all volumes in it. This value can only be set when creating new pool.
     */
    @JvmName("srfpykiiogxpqsrh")
    public fun encryptionType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, EncryptionType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.encryptionType = mapped
    }

    /**
     * @param value Encryption type of the capacity pool, set encryption type for data at rest for this pool and all volumes in it. This value can only be set when creating new pool.
     */
    @JvmName("yqsufjibpuandmuc")
    public fun encryptionType(`value`: EncryptionType) {
        val toBeMapped = Either.ofRight<String, EncryptionType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.encryptionType = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("wmenooawrwvgdpnt")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the capacity pool
     */
    @JvmName("ordiomkgbivypftw")
    public suspend fun poolName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.poolName = mapped
    }

    /**
     * @param value The qos type of the pool
     */
    @JvmName("xqkarsokfconhvyh")
    public suspend fun qosType(`value`: Either<String, QosType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.qosType = mapped
    }

    /**
     * @param value The qos type of the pool
     */
    @JvmName("cfgrrpdyxloeckno")
    public fun qosType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, QosType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.qosType = mapped
    }

    /**
     * @param value The qos type of the pool
     */
    @JvmName("rlgjjovrcgilnjpw")
    public fun qosType(`value`: QosType) {
        val toBeMapped = Either.ofRight<String, QosType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.qosType = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("vsnribboapqmsrtl")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The service level of the file system
     */
    @JvmName("kuewfcxwotraybni")
    public suspend fun serviceLevel(`value`: Either<String, ServiceLevel>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceLevel = mapped
    }

    /**
     * @param value The service level of the file system
     */
    @JvmName("ehhupxdrmakkltwy")
    public fun serviceLevel(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ServiceLevel>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serviceLevel = mapped
    }

    /**
     * @param value The service level of the file system
     */
    @JvmName("rwocyphshipcvvqf")
    public fun serviceLevel(`value`: ServiceLevel) {
        val toBeMapped = Either.ofRight<String, ServiceLevel>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serviceLevel = mapped
    }

    /**
     * @param value Provisioned size of the pool (in bytes). Allowed values are in 1TiB chunks (value must be multiply of 4398046511104).
     */
    @JvmName("lweudibeobfseqbx")
    public suspend fun size(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.size = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("jxohfmdpkktqsxrs")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("mrturmecqsmpctrb")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): PoolArgs = PoolArgs(
        accountName = accountName,
        coolAccess = coolAccess,
        encryptionType = encryptionType,
        location = location,
        poolName = poolName,
        qosType = qosType,
        resourceGroupName = resourceGroupName,
        serviceLevel = serviceLevel,
        size = size,
        tags = tags,
    )
}
