@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.netapp.kotlin

import com.pulumi.azurenative.netapp.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.netapp.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Subvolume].
 */
@PulumiTagMarker
public class SubvolumeResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SubvolumeArgs = SubvolumeArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SubvolumeArgsBuilder.() -> Unit) {
        val builder = SubvolumeArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Subvolume {
        val builtJavaResource = com.pulumi.azurenative.netapp.Subvolume(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Subvolume(builtJavaResource)
    }
}

/**
 * Subvolume Information properties
 * Azure REST API version: 2022-11-01. Prior API version in Azure Native 1.x: 2021-10-01.
 * Other available API versions: 2022-11-01-preview, 2023-05-01.
 * ## Example Usage
 * ### Subvolumes_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var subvolume = new AzureNative.NetApp.Subvolume("subvolume", new()
 *     {
 *         AccountName = "account1",
 *         Path = "/subvolumePath",
 *         PoolName = "pool1",
 *         ResourceGroupName = "myRG",
 *         SubvolumeName = "subvolume1",
 *         VolumeName = "volume1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/netapp/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := netapp.NewSubvolume(ctx, "subvolume", &netapp.SubvolumeArgs{
 * 			AccountName:       pulumi.String("account1"),
 * 			Path:              pulumi.String("/subvolumePath"),
 * 			PoolName:          pulumi.String("pool1"),
 * 			ResourceGroupName: pulumi.String("myRG"),
 * 			SubvolumeName:     pulumi.String("subvolume1"),
 * 			VolumeName:        pulumi.String("volume1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.netapp.Subvolume;
 * import com.pulumi.azurenative.netapp.SubvolumeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var subvolume = new Subvolume("subvolume", SubvolumeArgs.builder()
 *             .accountName("account1")
 *             .path("/subvolumePath")
 *             .poolName("pool1")
 *             .resourceGroupName("myRG")
 *             .subvolumeName("subvolume1")
 *             .volumeName("volume1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:netapp:Subvolume account1/pool1/volume1/subvolume1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetApp/netAppAccounts/{accountName}/capacityPools/{poolName}/volumes/{volumeName}/subvolumes/{subvolumeName}
 * ```
 */
public class Subvolume internal constructor(
    override val javaResource: com.pulumi.azurenative.netapp.Subvolume,
) : KotlinCustomResource(javaResource, SubvolumeMapper) {
    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * parent path to the subvolume
     */
    public val parentPath: Output<String>?
        get() = javaResource.parentPath().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Path to the subvolume
     */
    public val path: Output<String>?
        get() = javaResource.path().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Azure lifecycle management
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object SubvolumeMapper : ResourceMapper<Subvolume> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.netapp.Subvolume::class == javaResource::class

    override fun map(javaResource: Resource): Subvolume = Subvolume(
        javaResource as
            com.pulumi.azurenative.netapp.Subvolume,
    )
}

/**
 * @see [Subvolume].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Subvolume].
 */
public suspend fun subvolume(name: String, block: suspend SubvolumeResourceBuilder.() -> Unit):
    Subvolume {
    val builder = SubvolumeResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Subvolume].
 * @param name The _unique_ name of the resulting resource.
 */
public fun subvolume(name: String): Subvolume {
    val builder = SubvolumeResourceBuilder()
    builder.name(name)
    return builder.build()
}
