@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.netapp.kotlin

import com.pulumi.azurenative.netapp.SubvolumeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Subvolume Information properties
 * Azure REST API version: 2022-11-01. Prior API version in Azure Native 1.x: 2021-10-01.
 * Other available API versions: 2022-11-01-preview, 2023-05-01.
 * ## Example Usage
 * ### Subvolumes_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var subvolume = new AzureNative.NetApp.Subvolume("subvolume", new()
 *     {
 *         AccountName = "account1",
 *         Path = "/subvolumePath",
 *         PoolName = "pool1",
 *         ResourceGroupName = "myRG",
 *         SubvolumeName = "subvolume1",
 *         VolumeName = "volume1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/netapp/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := netapp.NewSubvolume(ctx, "subvolume", &netapp.SubvolumeArgs{
 * 			AccountName:       pulumi.String("account1"),
 * 			Path:              pulumi.String("/subvolumePath"),
 * 			PoolName:          pulumi.String("pool1"),
 * 			ResourceGroupName: pulumi.String("myRG"),
 * 			SubvolumeName:     pulumi.String("subvolume1"),
 * 			VolumeName:        pulumi.String("volume1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.netapp.Subvolume;
 * import com.pulumi.azurenative.netapp.SubvolumeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var subvolume = new Subvolume("subvolume", SubvolumeArgs.builder()
 *             .accountName("account1")
 *             .path("/subvolumePath")
 *             .poolName("pool1")
 *             .resourceGroupName("myRG")
 *             .subvolumeName("subvolume1")
 *             .volumeName("volume1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:netapp:Subvolume account1/pool1/volume1/subvolume1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetApp/netAppAccounts/{accountName}/capacityPools/{poolName}/volumes/{volumeName}/subvolumes/{subvolumeName}
 * ```
 * @property accountName The name of the NetApp account
 * @property parentPath parent path to the subvolume
 * @property path Path to the subvolume
 * @property poolName The name of the capacity pool
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property size Truncate subvolume to the provided size in bytes
 * @property subvolumeName The name of the subvolume.
 * @property volumeName The name of the volume
 */
public data class SubvolumeArgs(
    public val accountName: Output<String>? = null,
    public val parentPath: Output<String>? = null,
    public val path: Output<String>? = null,
    public val poolName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val size: Output<Double>? = null,
    public val subvolumeName: Output<String>? = null,
    public val volumeName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.netapp.SubvolumeArgs> {
    override fun toJava(): com.pulumi.azurenative.netapp.SubvolumeArgs =
        com.pulumi.azurenative.netapp.SubvolumeArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .parentPath(parentPath?.applyValue({ args0 -> args0 }))
            .path(path?.applyValue({ args0 -> args0 }))
            .poolName(poolName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .size(size?.applyValue({ args0 -> args0 }))
            .subvolumeName(subvolumeName?.applyValue({ args0 -> args0 }))
            .volumeName(volumeName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SubvolumeArgs].
 */
@PulumiTagMarker
public class SubvolumeArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var parentPath: Output<String>? = null

    private var path: Output<String>? = null

    private var poolName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var size: Output<Double>? = null

    private var subvolumeName: Output<String>? = null

    private var volumeName: Output<String>? = null

    /**
     * @param value The name of the NetApp account
     */
    @JvmName("svweufklgbegqjin")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value parent path to the subvolume
     */
    @JvmName("lunsaeoklemxvowy")
    public suspend fun parentPath(`value`: Output<String>) {
        this.parentPath = value
    }

    /**
     * @param value Path to the subvolume
     */
    @JvmName("hadpnijspsqsftcb")
    public suspend fun path(`value`: Output<String>) {
        this.path = value
    }

    /**
     * @param value The name of the capacity pool
     */
    @JvmName("wiwmglqsydlqeicy")
    public suspend fun poolName(`value`: Output<String>) {
        this.poolName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("wnttrmikbyijtllp")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Truncate subvolume to the provided size in bytes
     */
    @JvmName("fktdmjxceqsqjrss")
    public suspend fun size(`value`: Output<Double>) {
        this.size = value
    }

    /**
     * @param value The name of the subvolume.
     */
    @JvmName("mknvfyiheotuhghu")
    public suspend fun subvolumeName(`value`: Output<String>) {
        this.subvolumeName = value
    }

    /**
     * @param value The name of the volume
     */
    @JvmName("imlokwncjydcoadl")
    public suspend fun volumeName(`value`: Output<String>) {
        this.volumeName = value
    }

    /**
     * @param value The name of the NetApp account
     */
    @JvmName("dgewauomgtooedyo")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value parent path to the subvolume
     */
    @JvmName("ebqlayotuuiguhed")
    public suspend fun parentPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parentPath = mapped
    }

    /**
     * @param value Path to the subvolume
     */
    @JvmName("vwidvcxqbijxsjcl")
    public suspend fun path(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.path = mapped
    }

    /**
     * @param value The name of the capacity pool
     */
    @JvmName("jwmmynungxyfesaw")
    public suspend fun poolName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.poolName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("kqvdmhkbmlqauefa")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Truncate subvolume to the provided size in bytes
     */
    @JvmName("vihfftqpqnptwrqv")
    public suspend fun size(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.size = mapped
    }

    /**
     * @param value The name of the subvolume.
     */
    @JvmName("venadhchhanyokga")
    public suspend fun subvolumeName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subvolumeName = mapped
    }

    /**
     * @param value The name of the volume
     */
    @JvmName("tlpyhlgeehsrkdyn")
    public suspend fun volumeName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumeName = mapped
    }

    internal fun build(): SubvolumeArgs = SubvolumeArgs(
        accountName = accountName,
        parentPath = parentPath,
        path = path,
        poolName = poolName,
        resourceGroupName = resourceGroupName,
        size = size,
        subvolumeName = subvolumeName,
        volumeName = volumeName,
    )
}
