@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.netapp.kotlin

import com.pulumi.azurenative.netapp.kotlin.outputs.MountTargetPropertiesResponse
import com.pulumi.azurenative.netapp.kotlin.outputs.PlacementKeyValuePairsResponse
import com.pulumi.azurenative.netapp.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.netapp.kotlin.outputs.VolumePropertiesResponseDataProtection
import com.pulumi.azurenative.netapp.kotlin.outputs.VolumePropertiesResponseExportPolicy
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.netapp.kotlin.outputs.MountTargetPropertiesResponse.Companion.toKotlin as mountTargetPropertiesResponseToKotlin
import com.pulumi.azurenative.netapp.kotlin.outputs.PlacementKeyValuePairsResponse.Companion.toKotlin as placementKeyValuePairsResponseToKotlin
import com.pulumi.azurenative.netapp.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin
import com.pulumi.azurenative.netapp.kotlin.outputs.VolumePropertiesResponseDataProtection.Companion.toKotlin as volumePropertiesResponseDataProtectionToKotlin
import com.pulumi.azurenative.netapp.kotlin.outputs.VolumePropertiesResponseExportPolicy.Companion.toKotlin as volumePropertiesResponseExportPolicyToKotlin

/**
 * Builder for [Volume].
 */
@PulumiTagMarker
public class VolumeResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VolumeArgs = VolumeArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VolumeArgsBuilder.() -> Unit) {
        val builder = VolumeArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Volume {
        val builtJavaResource = com.pulumi.azurenative.netapp.Volume(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Volume(builtJavaResource)
    }
}

/**
 * Volume resource
 * Azure REST API version: 2022-11-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2017-08-15, 2019-05-01, 2019-07-01, 2019-08-01, 2020-02-01, 2021-10-01, 2022-11-01-preview, 2023-05-01.
 * ## Example Usage
 * ### Volumes_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var volume = new AzureNative.NetApp.Volume("volume", new()
 *     {
 *         AccountName = "account1",
 *         CreationToken = "my-unique-file-path",
 *         Location = "eastus",
 *         PoolName = "pool1",
 *         ResourceGroupName = "myRG",
 *         ServiceLevel = "Premium",
 *         SubnetId = "/subscriptions/9760acf5-4638-11e7-9bdb-020073ca7778/resourceGroups/myRP/providers/Microsoft.Network/virtualNetworks/testvnet3/subnets/testsubnet3",
 *         UsageThreshold = 107374182400,
 *         VolumeName = "volume1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/netapp/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := netapp.NewVolume(ctx, "volume", &netapp.VolumeArgs{
 * 			AccountName:       pulumi.String("account1"),
 * 			CreationToken:     pulumi.String("my-unique-file-path"),
 * 			Location:          pulumi.String("eastus"),
 * 			PoolName:          pulumi.String("pool1"),
 * 			ResourceGroupName: pulumi.String("myRG"),
 * 			ServiceLevel:      pulumi.String("Premium"),
 * 			SubnetId:          pulumi.String("/subscriptions/9760acf5-4638-11e7-9bdb-020073ca7778/resourceGroups/myRP/providers/Microsoft.Network/virtualNetworks/testvnet3/subnets/testsubnet3"),
 * 			UsageThreshold:    pulumi.Float64(107374182400),
 * 			VolumeName:        pulumi.String("volume1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.netapp.Volume;
 * import com.pulumi.azurenative.netapp.VolumeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var volume = new Volume("volume", VolumeArgs.builder()
 *             .accountName("account1")
 *             .creationToken("my-unique-file-path")
 *             .location("eastus")
 *             .poolName("pool1")
 *             .resourceGroupName("myRG")
 *             .serviceLevel("Premium")
 *             .subnetId("/subscriptions/9760acf5-4638-11e7-9bdb-020073ca7778/resourceGroups/myRP/providers/Microsoft.Network/virtualNetworks/testvnet3/subnets/testsubnet3")
 *             .usageThreshold(107374182400)
 *             .volumeName("volume1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:netapp:Volume account1/pool1/volume1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetApp/netAppAccounts/{accountName}/capacityPools/{poolName}/volumes/{volumeName}
 * ```
 */
public class Volume internal constructor(
    override val javaResource: com.pulumi.azurenative.netapp.Volume,
) : KotlinCustomResource(javaResource, VolumeMapper) {
    /**
     * Actual throughput in MiB/s for auto qosType volumes calculated based on size and serviceLevel
     */
    public val actualThroughputMibps: Output<Double>
        get() = javaResource.actualThroughputMibps().applyValue({ args0 -> args0 })

    /**
     * Specifies whether the volume is enabled for Azure VMware Solution (AVS) datastore purpose
     */
    public val avsDataStore: Output<String>?
        get() = javaResource.avsDataStore().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * UUID v4 or resource identifier used to identify the Backup.
     */
    public val backupId: Output<String>?
        get() = javaResource.backupId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Unique Baremetal Tenant Identifier.
     */
    public val baremetalTenantId: Output<String>
        get() = javaResource.baremetalTenantId().applyValue({ args0 -> args0 })

    /**
     * Pool Resource Id used in case of creating a volume through volume group
     */
    public val capacityPoolResourceId: Output<String>?
        get() = javaResource.capacityPoolResourceId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * When a volume is being restored from another volume's snapshot, will show the percentage completion of this cloning process. When this value is empty/null there is no cloning process currently happening on this volume. This value will update every 5 minutes during cloning.
     */
    public val cloneProgress: Output<Int>
        get() = javaResource.cloneProgress().applyValue({ args0 -> args0 })

    /**
     * Specifies whether Cool Access(tiering) is enabled for the volume.
     */
    public val coolAccess: Output<Boolean>?
        get() = javaResource.coolAccess().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies the number of days after which data that is not accessed by clients will be tiered.
     */
    public val coolnessPeriod: Output<Int>?
        get() = javaResource.coolnessPeriod().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A unique file path for the volume. Used when creating mount targets
     */
    public val creationToken: Output<String>
        get() = javaResource.creationToken().applyValue({ args0 -> args0 })

    /**
     * DataProtection type volumes include an object containing details of the replication
     */
    public val dataProtection: Output<VolumePropertiesResponseDataProtection>?
        get() = javaResource.dataProtection().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> volumePropertiesResponseDataProtectionToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Data store resource unique identifier
     */
    public val dataStoreResourceId: Output<List<String>>
        get() = javaResource.dataStoreResourceId().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Default group quota for volume in KiBs. If isDefaultQuotaEnabled is set, the minimum value of 4 KiBs applies.
     */
    public val defaultGroupQuotaInKiBs: Output<Double>?
        get() = javaResource.defaultGroupQuotaInKiBs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Default user quota for volume in KiBs. If isDefaultQuotaEnabled is set, the minimum value of 4 KiBs applies .
     */
    public val defaultUserQuotaInKiBs: Output<Double>?
        get() = javaResource.defaultUserQuotaInKiBs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * If enabled (true) the snapshot the volume was created from will be automatically deleted after the volume create operation has finished.  Defaults to false
     */
    public val deleteBaseSnapshot: Output<Boolean>?
        get() = javaResource.deleteBaseSnapshot().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Flag indicating whether subvolume operations are enabled on the volume
     */
    public val enableSubvolumes: Output<String>?
        get() = javaResource.enableSubvolumes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies if the volume is encrypted or not. Only available on volumes created or updated after 2022-01-01.
     */
    public val encrypted: Output<Boolean>
        get() = javaResource.encrypted().applyValue({ args0 -> args0 })

    /**
     * Source of key used to encrypt data in volume. Applicable if NetApp account has encryption.keySource = 'Microsoft.KeyVault'. Possible values (case-insensitive) are: 'Microsoft.NetApp, Microsoft.KeyVault'
     */
    public val encryptionKeySource: Output<String>?
        get() = javaResource.encryptionKeySource().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * Set of export policy rules
     */
    public val exportPolicy: Output<VolumePropertiesResponseExportPolicy>?
        get() = javaResource.exportPolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    volumePropertiesResponseExportPolicyToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Flag indicating whether file access logs are enabled for the volume, based on active diagnostic settings present on the volume.
     */
    public val fileAccessLogs: Output<String>
        get() = javaResource.fileAccessLogs().applyValue({ args0 -> args0 })

    /**
     * Unique FileSystem Identifier.
     */
    public val fileSystemId: Output<String>
        get() = javaResource.fileSystemId().applyValue({ args0 -> args0 })

    /**
     * Specifies if default quota is enabled for the volume.
     */
    public val isDefaultQuotaEnabled: Output<Boolean>?
        get() = javaResource.isDefaultQuotaEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies whether volume is a Large Volume or Regular Volume.
     */
    public val isLargeVolume: Output<Boolean>?
        get() = javaResource.isLargeVolume().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Restoring
     */
    public val isRestoring: Output<Boolean>?
        get() = javaResource.isRestoring().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Describe if a volume is KerberosEnabled. To be use with swagger version 2020-05-01 or later
     */
    public val kerberosEnabled: Output<Boolean>?
        get() = javaResource.kerberosEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The resource ID of private endpoint for KeyVault. It must reside in the same VNET as the volume. Only applicable if encryptionKeySource = 'Microsoft.KeyVault'.
     */
    public val keyVaultPrivateEndpointResourceId: Output<String>?
        get() = javaResource.keyVaultPrivateEndpointResourceId().applyValue({ args0 ->
            args0.map({ args0 -> args0 }).orElse(null)
        })

    /**
     * Specifies whether LDAP is enabled or not for a given NFS volume.
     */
    public val ldapEnabled: Output<Boolean>?
        get() = javaResource.ldapEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Maximum number of files allowed. Needs a service request in order to be changed. Only allowed to be changed if volume quota is more than 4TiB.
     */
    public val maximumNumberOfFiles: Output<Double>
        get() = javaResource.maximumNumberOfFiles().applyValue({ args0 -> args0 })

    /**
     * List of mount targets
     */
    public val mountTargets: Output<List<MountTargetPropertiesResponse>>
        get() = javaResource.mountTargets().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    mountTargetPropertiesResponseToKotlin(args0)
                })
            })
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Basic network, or Standard features available to the volume.
     */
    public val networkFeatures: Output<String>?
        get() = javaResource.networkFeatures().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Network Sibling Set ID for the the group of volumes sharing networking resources.
     */
    public val networkSiblingSetId: Output<String>
        get() = javaResource.networkSiblingSetId().applyValue({ args0 -> args0 })

    /**
     * Id of the snapshot or backup that the volume is restored from.
     */
    public val originatingResourceId: Output<String>
        get() = javaResource.originatingResourceId().applyValue({ args0 -> args0 })

    /**
     * Application specific placement rules for the particular volume
     */
    public val placementRules: Output<List<PlacementKeyValuePairsResponse>>?
        get() = javaResource.placementRules().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        placementKeyValuePairsResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Set of protocol types, default NFSv3, CIFS for SMB protocol
     */
    public val protocolTypes: Output<List<String>>?
        get() = javaResource.protocolTypes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The availability zone where the volume is provisioned. This refers to the logical availability zone where the volume resides.
     */
    public val provisionedAvailabilityZone: Output<String>
        get() = javaResource.provisionedAvailabilityZone().applyValue({ args0 -> args0 })

    /**
     * Azure lifecycle management
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Proximity placement group associated with the volume
     */
    public val proximityPlacementGroup: Output<String>?
        get() = javaResource.proximityPlacementGroup().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The security style of volume, default unix, defaults to ntfs for dual protocol or CIFS protocol
     */
    public val securityStyle: Output<String>?
        get() = javaResource.securityStyle().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The service level of the file system
     */
    public val serviceLevel: Output<String>?
        get() = javaResource.serviceLevel().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Enables access based enumeration share property for SMB Shares. Only applicable for SMB/DualProtocol volume
     */
    public val smbAccessBasedEnumeration: Output<String>?
        get() = javaResource.smbAccessBasedEnumeration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Enables continuously available share property for smb volume. Only applicable for SMB volume
     */
    public val smbContinuouslyAvailable: Output<Boolean>?
        get() = javaResource.smbContinuouslyAvailable().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Enables encryption for in-flight smb3 data. Only applicable for SMB/DualProtocol volume. To be used with swagger version 2020-08-01 or later
     */
    public val smbEncryption: Output<Boolean>?
        get() = javaResource.smbEncryption().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Enables non browsable property for SMB Shares. Only applicable for SMB/DualProtocol volume
     */
    public val smbNonBrowsable: Output<String>?
        get() = javaResource.smbNonBrowsable().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * If enabled (true) the volume will contain a read-only snapshot directory which provides access to each of the volume's snapshots (defaults to true).
     */
    public val snapshotDirectoryVisible: Output<Boolean>?
        get() = javaResource.snapshotDirectoryVisible().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * UUID v4 or resource identifier used to identify the Snapshot.
     */
    public val snapshotId: Output<String>?
        get() = javaResource.snapshotId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Provides storage to network proximity information for the volume.
     */
    public val storageToNetworkProximity: Output<String>
        get() = javaResource.storageToNetworkProximity().applyValue({ args0 -> args0 })

    /**
     * The Azure Resource URI for a delegated subnet. Must have the delegation Microsoft.NetApp/volumes
     */
    public val subnetId: Output<String>
        get() = javaResource.subnetId().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * T2 network information
     */
    public val t2Network: Output<String>
        get() = javaResource.t2Network().applyValue({ args0 -> args0 })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    public val throughputMibps: Output<Double>?
        get() = javaResource.throughputMibps().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * UNIX permissions for NFS volume accepted in octal 4 digit format. First digit selects the set user ID(4), set group ID (2) and sticky (1) attributes. Second digit selects permission for the owner of the file: read (4), write (2) and execute (1). Third selects permissions for other users in the same group. the fourth for other users not in the group. 0755 - gives read/write/execute permissions to owner and read/execute to group and other users.
     */
    public val unixPermissions: Output<String>?
        get() = javaResource.unixPermissions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Maximum storage quota allowed for a file system in bytes. This is a soft quota used for alerting only. Minimum size is 100 GiB. Upper limit is 100TiB, 500Tib for LargeVolume. Specified in bytes.
     */
    public val usageThreshold: Output<Double>
        get() = javaResource.usageThreshold().applyValue({ args0 -> args0 })

    /**
     * Volume Group Name
     */
    public val volumeGroupName: Output<String>
        get() = javaResource.volumeGroupName().applyValue({ args0 -> args0 })

    /**
     * Volume spec name is the application specific designation or identifier for the particular volume in a volume group for e.g. data, log
     */
    public val volumeSpecName: Output<String>?
        get() = javaResource.volumeSpecName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * What type of volume is this. For destination volumes in Cross Region Replication, set type to DataProtection
     */
    public val volumeType: Output<String>?
        get() = javaResource.volumeType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Availability Zone
     */
    public val zones: Output<List<String>>?
        get() = javaResource.zones().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })
}

public object VolumeMapper : ResourceMapper<Volume> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.netapp.Volume::class == javaResource::class

    override fun map(javaResource: Resource): Volume = Volume(
        javaResource as
            com.pulumi.azurenative.netapp.Volume,
    )
}

/**
 * @see [Volume].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Volume].
 */
public suspend fun volume(name: String, block: suspend VolumeResourceBuilder.() -> Unit): Volume {
    val builder = VolumeResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Volume].
 * @param name The _unique_ name of the resulting resource.
 */
public fun volume(name: String): Volume {
    val builder = VolumeResourceBuilder()
    builder.name(name)
    return builder.build()
}
