@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.netapp.kotlin

import com.pulumi.azurenative.netapp.VolumeQuotaRuleArgs.builder
import com.pulumi.azurenative.netapp.kotlin.enums.Type
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Quota Rule of a Volume
 * Azure REST API version: 2022-11-01. Prior API version in Azure Native 1.x: 2022-01-01.
 * Other available API versions: 2022-11-01-preview, 2023-05-01.
 * ## Example Usage
 * ### VolumeQuotaRules_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var volumeQuotaRule = new AzureNative.NetApp.VolumeQuotaRule("volumeQuotaRule", new()
 *     {
 *         AccountName = "account-9957",
 *         Location = "westus",
 *         PoolName = "pool-5210",
 *         QuotaSizeInKiBs = 100005,
 *         QuotaTarget = "1821",
 *         QuotaType = "IndividualUserQuota",
 *         ResourceGroupName = "myRG",
 *         VolumeName = "volume-6387",
 *         VolumeQuotaRuleName = "rule-0004",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/netapp/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := netapp.NewVolumeQuotaRule(ctx, "volumeQuotaRule", &netapp.VolumeQuotaRuleArgs{
 * 			AccountName:         pulumi.String("account-9957"),
 * 			Location:            pulumi.String("westus"),
 * 			PoolName:            pulumi.String("pool-5210"),
 * 			QuotaSizeInKiBs:     pulumi.Float64(100005),
 * 			QuotaTarget:         pulumi.String("1821"),
 * 			QuotaType:           pulumi.String("IndividualUserQuota"),
 * 			ResourceGroupName:   pulumi.String("myRG"),
 * 			VolumeName:          pulumi.String("volume-6387"),
 * 			VolumeQuotaRuleName: pulumi.String("rule-0004"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.netapp.VolumeQuotaRule;
 * import com.pulumi.azurenative.netapp.VolumeQuotaRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var volumeQuotaRule = new VolumeQuotaRule("volumeQuotaRule", VolumeQuotaRuleArgs.builder()
 *             .accountName("account-9957")
 *             .location("westus")
 *             .poolName("pool-5210")
 *             .quotaSizeInKiBs(100005)
 *             .quotaTarget("1821")
 *             .quotaType("IndividualUserQuota")
 *             .resourceGroupName("myRG")
 *             .volumeName("volume-6387")
 *             .volumeQuotaRuleName("rule-0004")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:netapp:VolumeQuotaRule account-9957/pool-5210/volume-6387/rule-0004 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetApp/netAppAccounts/{accountName}/capacityPools/{poolName}/volumes/{volumeName}/volumeQuotaRules/{volumeQuotaRuleName}
 * ```
 * @property accountName The name of the NetApp account
 * @property location The geo-location where the resource lives
 * @property poolName The name of the capacity pool
 * @property quotaSizeInKiBs Size of quota
 * @property quotaTarget UserID/GroupID/SID based on the quota target type. UserID and groupID can be found by running ‘id’ or ‘getent’ command for the user or group and SID can be found by running <wmic useraccount where name='user-name' get sid>
 * @property quotaType Type of quota
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 * @property volumeName The name of the volume
 * @property volumeQuotaRuleName The name of volume quota rule
 */
public data class VolumeQuotaRuleArgs(
    public val accountName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val poolName: Output<String>? = null,
    public val quotaSizeInKiBs: Output<Double>? = null,
    public val quotaTarget: Output<String>? = null,
    public val quotaType: Output<Either<String, Type>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val volumeName: Output<String>? = null,
    public val volumeQuotaRuleName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.netapp.VolumeQuotaRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.netapp.VolumeQuotaRuleArgs =
        com.pulumi.azurenative.netapp.VolumeQuotaRuleArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .poolName(poolName?.applyValue({ args0 -> args0 }))
            .quotaSizeInKiBs(quotaSizeInKiBs?.applyValue({ args0 -> args0 }))
            .quotaTarget(quotaTarget?.applyValue({ args0 -> args0 }))
            .quotaType(
                quotaType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .volumeName(volumeName?.applyValue({ args0 -> args0 }))
            .volumeQuotaRuleName(volumeQuotaRuleName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VolumeQuotaRuleArgs].
 */
@PulumiTagMarker
public class VolumeQuotaRuleArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var location: Output<String>? = null

    private var poolName: Output<String>? = null

    private var quotaSizeInKiBs: Output<Double>? = null

    private var quotaTarget: Output<String>? = null

    private var quotaType: Output<Either<String, Type>>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var volumeName: Output<String>? = null

    private var volumeQuotaRuleName: Output<String>? = null

    /**
     * @param value The name of the NetApp account
     */
    @JvmName("ttdklkuunlhxbcgs")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("rylsrmnvtmjokhxa")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the capacity pool
     */
    @JvmName("qpcpjugchflhajok")
    public suspend fun poolName(`value`: Output<String>) {
        this.poolName = value
    }

    /**
     * @param value Size of quota
     */
    @JvmName("waxnvcsutfbluafi")
    public suspend fun quotaSizeInKiBs(`value`: Output<Double>) {
        this.quotaSizeInKiBs = value
    }

    /**
     * @param value UserID/GroupID/SID based on the quota target type. UserID and groupID can be found by running ‘id’ or ‘getent’ command for the user or group and SID can be found by running <wmic useraccount where name='user-name' get sid>
     */
    @JvmName("pyoecnddbmjbsrwv")
    public suspend fun quotaTarget(`value`: Output<String>) {
        this.quotaTarget = value
    }

    /**
     * @param value Type of quota
     */
    @JvmName("gspemwllpfficeqa")
    public suspend fun quotaType(`value`: Output<Either<String, Type>>) {
        this.quotaType = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("jdiykvqjqxuofslv")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("urlrgnskufwiclut")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the volume
     */
    @JvmName("pqlakvgcchvjhdok")
    public suspend fun volumeName(`value`: Output<String>) {
        this.volumeName = value
    }

    /**
     * @param value The name of volume quota rule
     */
    @JvmName("jwktkuyaesdjjjtf")
    public suspend fun volumeQuotaRuleName(`value`: Output<String>) {
        this.volumeQuotaRuleName = value
    }

    /**
     * @param value The name of the NetApp account
     */
    @JvmName("xvuqelabvdfqdkjb")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("nvsammhhwcytdqnq")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the capacity pool
     */
    @JvmName("ykjyweenxiqvxlgl")
    public suspend fun poolName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.poolName = mapped
    }

    /**
     * @param value Size of quota
     */
    @JvmName("ranafrpuhrihfwmm")
    public suspend fun quotaSizeInKiBs(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.quotaSizeInKiBs = mapped
    }

    /**
     * @param value UserID/GroupID/SID based on the quota target type. UserID and groupID can be found by running ‘id’ or ‘getent’ command for the user or group and SID can be found by running <wmic useraccount where name='user-name' get sid>
     */
    @JvmName("ygakuucbfpwnctml")
    public suspend fun quotaTarget(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.quotaTarget = mapped
    }

    /**
     * @param value Type of quota
     */
    @JvmName("adnjspfevdbqhbug")
    public suspend fun quotaType(`value`: Either<String, Type>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.quotaType = mapped
    }

    /**
     * @param value Type of quota
     */
    @JvmName("sbasjidguapyvwmb")
    public fun quotaType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Type>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.quotaType = mapped
    }

    /**
     * @param value Type of quota
     */
    @JvmName("elgaxraqtfdkrbgx")
    public fun quotaType(`value`: Type) {
        val toBeMapped = Either.ofRight<String, Type>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.quotaType = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("gonjldamqjqlhwol")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("qcmitrgupphnnudx")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("ixxovbonbojjxqvn")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The name of the volume
     */
    @JvmName("gxbjffhugtkdtovx")
    public suspend fun volumeName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumeName = mapped
    }

    /**
     * @param value The name of volume quota rule
     */
    @JvmName("rxippncokisnusts")
    public suspend fun volumeQuotaRuleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumeQuotaRuleName = mapped
    }

    internal fun build(): VolumeQuotaRuleArgs = VolumeQuotaRuleArgs(
        accountName = accountName,
        location = location,
        poolName = poolName,
        quotaSizeInKiBs = quotaSizeInKiBs,
        quotaTarget = quotaTarget,
        quotaType = quotaType,
        resourceGroupName = resourceGroupName,
        tags = tags,
        volumeName = volumeName,
        volumeQuotaRuleName = volumeQuotaRuleName,
    )
}
