@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.netapp.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Indicates whether the local volume is the source or destination for the Volume Replication
 */
public enum class EndpointType(
    public val javaValue: com.pulumi.azurenative.netapp.enums.EndpointType,
) : ConvertibleToJava<com.pulumi.azurenative.netapp.enums.EndpointType> {
    Src(com.pulumi.azurenative.netapp.enums.EndpointType.Src),
    Dst(com.pulumi.azurenative.netapp.enums.EndpointType.Dst),
    ;

    override fun toJava(): com.pulumi.azurenative.netapp.enums.EndpointType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.netapp.enums.EndpointType): EndpointType =
            EndpointType.values().first { it.javaValue == javaType }
    }
}
