@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.netapp.kotlin.inputs

import com.pulumi.azurenative.netapp.inputs.DailyScheduleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Daily Schedule properties
 * @property hour Indicates which hour in UTC timezone a snapshot should be taken
 * @property minute Indicates which minute snapshot should be taken
 * @property snapshotsToKeep Daily snapshot count to keep
 * @property usedBytes Resource size in bytes, current storage usage for the volume in bytes
 */
public data class DailyScheduleArgs(
    public val hour: Output<Int>? = null,
    public val minute: Output<Int>? = null,
    public val snapshotsToKeep: Output<Int>? = null,
    public val usedBytes: Output<Double>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.netapp.inputs.DailyScheduleArgs> {
    override fun toJava(): com.pulumi.azurenative.netapp.inputs.DailyScheduleArgs =
        com.pulumi.azurenative.netapp.inputs.DailyScheduleArgs.builder()
            .hour(hour?.applyValue({ args0 -> args0 }))
            .minute(minute?.applyValue({ args0 -> args0 }))
            .snapshotsToKeep(snapshotsToKeep?.applyValue({ args0 -> args0 }))
            .usedBytes(usedBytes?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DailyScheduleArgs].
 */
@PulumiTagMarker
public class DailyScheduleArgsBuilder internal constructor() {
    private var hour: Output<Int>? = null

    private var minute: Output<Int>? = null

    private var snapshotsToKeep: Output<Int>? = null

    private var usedBytes: Output<Double>? = null

    /**
     * @param value Indicates which hour in UTC timezone a snapshot should be taken
     */
    @JvmName("ohynnwdhfhkaqybo")
    public suspend fun hour(`value`: Output<Int>) {
        this.hour = value
    }

    /**
     * @param value Indicates which minute snapshot should be taken
     */
    @JvmName("dkxakqehseamakki")
    public suspend fun minute(`value`: Output<Int>) {
        this.minute = value
    }

    /**
     * @param value Daily snapshot count to keep
     */
    @JvmName("amidmacpdgwlmsuk")
    public suspend fun snapshotsToKeep(`value`: Output<Int>) {
        this.snapshotsToKeep = value
    }

    /**
     * @param value Resource size in bytes, current storage usage for the volume in bytes
     */
    @JvmName("erwvlrkxwtkpgnsg")
    public suspend fun usedBytes(`value`: Output<Double>) {
        this.usedBytes = value
    }

    /**
     * @param value Indicates which hour in UTC timezone a snapshot should be taken
     */
    @JvmName("ogmcbpwovyxiwqis")
    public suspend fun hour(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hour = mapped
    }

    /**
     * @param value Indicates which minute snapshot should be taken
     */
    @JvmName("fmcbxntoknpbxnds")
    public suspend fun minute(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minute = mapped
    }

    /**
     * @param value Daily snapshot count to keep
     */
    @JvmName("qkhcnvsipcprpxpe")
    public suspend fun snapshotsToKeep(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snapshotsToKeep = mapped
    }

    /**
     * @param value Resource size in bytes, current storage usage for the volume in bytes
     */
    @JvmName("bvddnfbjslwhdeos")
    public suspend fun usedBytes(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.usedBytes = mapped
    }

    internal fun build(): DailyScheduleArgs = DailyScheduleArgs(
        hour = hour,
        minute = minute,
        snapshotsToKeep = snapshotsToKeep,
        usedBytes = usedBytes,
    )
}
