@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.netapp.kotlin.inputs

import com.pulumi.azurenative.netapp.inputs.EncryptionIdentityArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Identity used to authenticate with key vault.
 * @property userAssignedIdentity The ARM resource identifier of the user assigned identity used to authenticate with key vault. Applicable if identity.type has 'UserAssigned'. It should match key of identity.userAssignedIdentities.
 */
public data class EncryptionIdentityArgs(
    public val userAssignedIdentity: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.netapp.inputs.EncryptionIdentityArgs> {
    override fun toJava(): com.pulumi.azurenative.netapp.inputs.EncryptionIdentityArgs =
        com.pulumi.azurenative.netapp.inputs.EncryptionIdentityArgs.builder()
            .userAssignedIdentity(userAssignedIdentity?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EncryptionIdentityArgs].
 */
@PulumiTagMarker
public class EncryptionIdentityArgsBuilder internal constructor() {
    private var userAssignedIdentity: Output<String>? = null

    /**
     * @param value The ARM resource identifier of the user assigned identity used to authenticate with key vault. Applicable if identity.type has 'UserAssigned'. It should match key of identity.userAssignedIdentities.
     */
    @JvmName("adebnqkgnbhnober")
    public suspend fun userAssignedIdentity(`value`: Output<String>) {
        this.userAssignedIdentity = value
    }

    /**
     * @param value The ARM resource identifier of the user assigned identity used to authenticate with key vault. Applicable if identity.type has 'UserAssigned'. It should match key of identity.userAssignedIdentities.
     */
    @JvmName("kdudyrkctvflualc")
    public suspend fun userAssignedIdentity(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userAssignedIdentity = mapped
    }

    internal fun build(): EncryptionIdentityArgs = EncryptionIdentityArgs(
        userAssignedIdentity = userAssignedIdentity,
    )
}
