@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.netapp.kotlin.inputs

import com.pulumi.azurenative.netapp.inputs.GetAccountPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName The name of the NetApp account
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetAccountPlainArgs(
    public val accountName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.netapp.inputs.GetAccountPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.netapp.inputs.GetAccountPlainArgs =
        com.pulumi.azurenative.netapp.inputs.GetAccountPlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAccountPlainArgs].
 */
@PulumiTagMarker
public class GetAccountPlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the NetApp account
     */
    @JvmName("yeeirocynxyyecci")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("wkomgavmfyhlhibt")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetAccountPlainArgs = GetAccountPlainArgs(
        accountName = accountName ?: throw PulumiNullFieldException("accountName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
