@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.netapp.kotlin.inputs

import com.pulumi.azurenative.netapp.inputs.VolumeBackupPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Volume Backup Properties
 * @property backupEnabled Backup Enabled
 * @property backupPolicyId Backup Policy Resource ID
 * @property policyEnforced Policy Enforced
 */
public data class VolumeBackupPropertiesArgs(
    public val backupEnabled: Output<Boolean>? = null,
    public val backupPolicyId: Output<String>? = null,
    public val policyEnforced: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.netapp.inputs.VolumeBackupPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.netapp.inputs.VolumeBackupPropertiesArgs =
        com.pulumi.azurenative.netapp.inputs.VolumeBackupPropertiesArgs.builder()
            .backupEnabled(backupEnabled?.applyValue({ args0 -> args0 }))
            .backupPolicyId(backupPolicyId?.applyValue({ args0 -> args0 }))
            .policyEnforced(policyEnforced?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VolumeBackupPropertiesArgs].
 */
@PulumiTagMarker
public class VolumeBackupPropertiesArgsBuilder internal constructor() {
    private var backupEnabled: Output<Boolean>? = null

    private var backupPolicyId: Output<String>? = null

    private var policyEnforced: Output<Boolean>? = null

    /**
     * @param value Backup Enabled
     */
    @JvmName("tmllhcgkjucelpvx")
    public suspend fun backupEnabled(`value`: Output<Boolean>) {
        this.backupEnabled = value
    }

    /**
     * @param value Backup Policy Resource ID
     */
    @JvmName("wefwpgmtmxepbqpc")
    public suspend fun backupPolicyId(`value`: Output<String>) {
        this.backupPolicyId = value
    }

    /**
     * @param value Policy Enforced
     */
    @JvmName("uhpuofyktoyuxyoh")
    public suspend fun policyEnforced(`value`: Output<Boolean>) {
        this.policyEnforced = value
    }

    /**
     * @param value Backup Enabled
     */
    @JvmName("fhovycrsrbfaodci")
    public suspend fun backupEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupEnabled = mapped
    }

    /**
     * @param value Backup Policy Resource ID
     */
    @JvmName("uvydkfostxgwcwfg")
    public suspend fun backupPolicyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupPolicyId = mapped
    }

    /**
     * @param value Policy Enforced
     */
    @JvmName("kknwgsgtcixbnplw")
    public suspend fun policyEnforced(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyEnforced = mapped
    }

    internal fun build(): VolumeBackupPropertiesArgs = VolumeBackupPropertiesArgs(
        backupEnabled = backupEnabled,
        backupPolicyId = backupPolicyId,
        policyEnforced = policyEnforced,
    )
}
