@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.netapp.kotlin.inputs

import com.pulumi.azurenative.netapp.inputs.VolumeGroupMetaDataArgs.builder
import com.pulumi.azurenative.netapp.kotlin.enums.ApplicationType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Volume group properties
 * @property applicationIdentifier Application specific identifier
 * @property applicationType Application Type
 * @property deploymentSpecId Application specific identifier of deployment rules for the volume group
 * @property globalPlacementRules Application specific placement rules for the volume group
 * @property groupDescription Group Description
 */
public data class VolumeGroupMetaDataArgs(
    public val applicationIdentifier: Output<String>? = null,
    public val applicationType: Output<Either<String, ApplicationType>>? = null,
    public val deploymentSpecId: Output<String>? = null,
    public val globalPlacementRules: Output<List<PlacementKeyValuePairsArgs>>? = null,
    public val groupDescription: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.netapp.inputs.VolumeGroupMetaDataArgs> {
    override fun toJava(): com.pulumi.azurenative.netapp.inputs.VolumeGroupMetaDataArgs =
        com.pulumi.azurenative.netapp.inputs.VolumeGroupMetaDataArgs.builder()
            .applicationIdentifier(applicationIdentifier?.applyValue({ args0 -> args0 }))
            .applicationType(
                applicationType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .deploymentSpecId(deploymentSpecId?.applyValue({ args0 -> args0 }))
            .globalPlacementRules(
                globalPlacementRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .groupDescription(groupDescription?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VolumeGroupMetaDataArgs].
 */
@PulumiTagMarker
public class VolumeGroupMetaDataArgsBuilder internal constructor() {
    private var applicationIdentifier: Output<String>? = null

    private var applicationType: Output<Either<String, ApplicationType>>? = null

    private var deploymentSpecId: Output<String>? = null

    private var globalPlacementRules: Output<List<PlacementKeyValuePairsArgs>>? = null

    private var groupDescription: Output<String>? = null

    /**
     * @param value Application specific identifier
     */
    @JvmName("xiaakyotmnprvaqe")
    public suspend fun applicationIdentifier(`value`: Output<String>) {
        this.applicationIdentifier = value
    }

    /**
     * @param value Application Type
     */
    @JvmName("ylotyexhcrjhiuiw")
    public suspend fun applicationType(`value`: Output<Either<String, ApplicationType>>) {
        this.applicationType = value
    }

    /**
     * @param value Application specific identifier of deployment rules for the volume group
     */
    @JvmName("gglheospfvysubbp")
    public suspend fun deploymentSpecId(`value`: Output<String>) {
        this.deploymentSpecId = value
    }

    /**
     * @param value Application specific placement rules for the volume group
     */
    @JvmName("jwcifgxovvcanuyy")
    public suspend fun globalPlacementRules(`value`: Output<List<PlacementKeyValuePairsArgs>>) {
        this.globalPlacementRules = value
    }

    @JvmName("aqwriolshmtcscnv")
    public suspend fun globalPlacementRules(vararg values: Output<PlacementKeyValuePairsArgs>) {
        this.globalPlacementRules = Output.all(values.asList())
    }

    /**
     * @param values Application specific placement rules for the volume group
     */
    @JvmName("advaiaglocdbgmhb")
    public suspend fun globalPlacementRules(values: List<Output<PlacementKeyValuePairsArgs>>) {
        this.globalPlacementRules = Output.all(values)
    }

    /**
     * @param value Group Description
     */
    @JvmName("hyewapyouievnrob")
    public suspend fun groupDescription(`value`: Output<String>) {
        this.groupDescription = value
    }

    /**
     * @param value Application specific identifier
     */
    @JvmName("lqeubvmaudmvotda")
    public suspend fun applicationIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationIdentifier = mapped
    }

    /**
     * @param value Application Type
     */
    @JvmName("hflajrhinjnglvwt")
    public suspend fun applicationType(`value`: Either<String, ApplicationType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationType = mapped
    }

    /**
     * @param value Application Type
     */
    @JvmName("asjjsruijgpgfuum")
    public fun applicationType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ApplicationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.applicationType = mapped
    }

    /**
     * @param value Application Type
     */
    @JvmName("uvfrxkwmprsfhiec")
    public fun applicationType(`value`: ApplicationType) {
        val toBeMapped = Either.ofRight<String, ApplicationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.applicationType = mapped
    }

    /**
     * @param value Application specific identifier of deployment rules for the volume group
     */
    @JvmName("inpdgajkgexrykoa")
    public suspend fun deploymentSpecId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deploymentSpecId = mapped
    }

    /**
     * @param value Application specific placement rules for the volume group
     */
    @JvmName("kjarolpslxlmfkvt")
    public suspend fun globalPlacementRules(`value`: List<PlacementKeyValuePairsArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.globalPlacementRules = mapped
    }

    /**
     * @param argument Application specific placement rules for the volume group
     */
    @JvmName("dwobmuilllpcrwyy")
    public suspend
    fun globalPlacementRules(argument: List<suspend PlacementKeyValuePairsArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PlacementKeyValuePairsArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.globalPlacementRules = mapped
    }

    /**
     * @param argument Application specific placement rules for the volume group
     */
    @JvmName("adsaokcuceqnadki")
    public suspend fun globalPlacementRules(
        vararg
        argument: suspend PlacementKeyValuePairsArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            PlacementKeyValuePairsArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.globalPlacementRules = mapped
    }

    /**
     * @param argument Application specific placement rules for the volume group
     */
    @JvmName("gsjinnfxvqmrrgcg")
    public suspend
    fun globalPlacementRules(argument: suspend PlacementKeyValuePairsArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(PlacementKeyValuePairsArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.globalPlacementRules = mapped
    }

    /**
     * @param values Application specific placement rules for the volume group
     */
    @JvmName("ngyqhgourrjxrvvo")
    public suspend fun globalPlacementRules(vararg values: PlacementKeyValuePairsArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.globalPlacementRules = mapped
    }

    /**
     * @param value Group Description
     */
    @JvmName("yrlqwuoviupompax")
    public suspend fun groupDescription(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupDescription = mapped
    }

    internal fun build(): VolumeGroupMetaDataArgs = VolumeGroupMetaDataArgs(
        applicationIdentifier = applicationIdentifier,
        applicationType = applicationType,
        deploymentSpecId = deploymentSpecId,
        globalPlacementRules = globalPlacementRules,
        groupDescription = groupDescription,
    )
}
