@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.netapp.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Encryption settings
 * @property identity Identity used to authenticate to KeyVault. Applicable if keySource is 'Microsoft.KeyVault'.
 * @property keySource The encryption keySource (provider). Possible values (case-insensitive):  Microsoft.NetApp, Microsoft.KeyVault
 * @property keyVaultProperties Properties provided by KeVault. Applicable if keySource is 'Microsoft.KeyVault'.
 */
public data class AccountEncryptionResponse(
    public val identity: EncryptionIdentityResponse? = null,
    public val keySource: String? = null,
    public val keyVaultProperties: KeyVaultPropertiesResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.netapp.outputs.AccountEncryptionResponse):
            AccountEncryptionResponse = AccountEncryptionResponse(
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.netapp.kotlin.outputs.EncryptionIdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            keySource = javaType.keySource().map({ args0 -> args0 }).orElse(null),
            keyVaultProperties = javaType.keyVaultProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.netapp.kotlin.outputs.KeyVaultPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
