@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.netapp.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * Backup of a Volume
 * @property backupId UUID v4 used to identify the Backup
 * @property backupType Type of backup Manual or Scheduled
 * @property creationDate The creation date of the backup
 * @property failureReason Failure reason
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property label Label for backup
 * @property location Resource location
 * @property name The name of the resource
 * @property provisioningState Azure lifecycle management
 * @property size Size of backup
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property useExistingSnapshot Manual backup an already existing snapshot. This will always be false for scheduled backups and true/false for manual backups
 * @property volumeName Volume name
 */
public data class GetBackupResult(
    public val backupId: String,
    public val backupType: String,
    public val creationDate: String,
    public val failureReason: String,
    public val id: String,
    public val label: String? = null,
    public val location: String,
    public val name: String,
    public val provisioningState: String,
    public val size: Double,
    public val systemData: SystemDataResponse,
    public val type: String,
    public val useExistingSnapshot: Boolean? = null,
    public val volumeName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.netapp.outputs.GetBackupResult):
            GetBackupResult = GetBackupResult(
            backupId = javaType.backupId(),
            backupType = javaType.backupType(),
            creationDate = javaType.creationDate(),
            failureReason = javaType.failureReason(),
            id = javaType.id(),
            label = javaType.label().map({ args0 -> args0 }).orElse(null),
            location = javaType.location(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            size = javaType.size(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.netapp.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
            useExistingSnapshot = javaType.useExistingSnapshot().map({ args0 -> args0 }).orElse(null),
            volumeName = javaType.volumeName(),
        )
    }
}
