@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.kotlin.outputs.AddressPrefixItemResponse
import com.pulumi.azurenative.network.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.network.kotlin.outputs.AddressPrefixItemResponse.Companion.toKotlin as addressPrefixItemResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [AdminRule].
 */
@PulumiTagMarker
public class AdminRuleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AdminRuleArgs = AdminRuleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AdminRuleArgsBuilder.() -> Unit) {
        val builder = AdminRuleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): AdminRule {
        val builtJavaResource = com.pulumi.azurenative.network.AdminRule(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AdminRule(builtJavaResource)
    }
}

/**
 * Network admin rule.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2021-02-01-preview.
 * Other available API versions: 2021-02-01-preview, 2021-05-01-preview, 2023-04-01, 2023-05-01, 2023-06-01.
 * ## Example Usage
 * ### Create a default admin rule
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var adminRule = new AzureNative.Network.AdminRule("adminRule", new()
 *     {
 *         ConfigurationName = "myTestSecurityConfig",
 *         NetworkManagerName = "testNetworkManager",
 *         ResourceGroupName = "rg1",
 *         RuleCollectionName = "testRuleCollection",
 *         RuleName = "SampleDefaultAdminRule",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewAdminRule(ctx, "adminRule", &network.AdminRuleArgs{
 * 			ConfigurationName:  pulumi.String("myTestSecurityConfig"),
 * 			NetworkManagerName: pulumi.String("testNetworkManager"),
 * 			ResourceGroupName:  pulumi.String("rg1"),
 * 			RuleCollectionName: pulumi.String("testRuleCollection"),
 * 			RuleName:           pulumi.String("SampleDefaultAdminRule"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.AdminRule;
 * import com.pulumi.azurenative.network.AdminRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var adminRule = new AdminRule("adminRule", AdminRuleArgs.builder()
 *             .configurationName("myTestSecurityConfig")
 *             .networkManagerName("testNetworkManager")
 *             .resourceGroupName("rg1")
 *             .ruleCollectionName("testRuleCollection")
 *             .ruleName("SampleDefaultAdminRule")
 *             .build());
 *     }
 * }
 * ```
 * ### Create an admin rule
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var adminRule = new AzureNative.Network.AdminRule("adminRule", new()
 *     {
 *         Access = "Deny",
 *         ConfigurationName = "myTestSecurityConfig",
 *         Description = "This is Sample Admin Rule",
 *         DestinationPortRanges = new[]
 *         {
 *             "22",
 *         },
 *         Destinations = new[]
 *         {
 *             new AzureNative.Network.Inputs.AddressPrefixItemArgs
 *             {
 *                 AddressPrefix = "*",
 *                 AddressPrefixType = "IPPrefix",
 *             },
 *         },
 *         Direction = "Inbound",
 *         Kind = "Custom",
 *         NetworkManagerName = "testNetworkManager",
 *         Priority = 1,
 *         Protocol = "Tcp",
 *         ResourceGroupName = "rg1",
 *         RuleCollectionName = "testRuleCollection",
 *         RuleName = "SampleAdminRule",
 *         SourcePortRanges = new[]
 *         {
 *             "0-65535",
 *         },
 *         Sources = new[]
 *         {
 *             new AzureNative.Network.Inputs.AddressPrefixItemArgs
 *             {
 *                 AddressPrefix = "Internet",
 *                 AddressPrefixType = "ServiceTag",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewAdminRule(ctx, "adminRule", &network.AdminRuleArgs{
 * 			Access:            pulumi.String("Deny"),
 * 			ConfigurationName: pulumi.String("myTestSecurityConfig"),
 * 			Description:       pulumi.String("This is Sample Admin Rule"),
 * 			DestinationPortRanges: pulumi.StringArray{
 * 				pulumi.String("22"),
 * 			},
 * 			Destinations: []network.AddressPrefixItemArgs{
 * 				{
 * 					AddressPrefix:     pulumi.String("*"),
 * 					AddressPrefixType: pulumi.String("IPPrefix"),
 * 				},
 * 			},
 * 			Direction:          pulumi.String("Inbound"),
 * 			Kind:               pulumi.String("Custom"),
 * 			NetworkManagerName: pulumi.String("testNetworkManager"),
 * 			Priority:           pulumi.Int(1),
 * 			Protocol:           pulumi.String("Tcp"),
 * 			ResourceGroupName:  pulumi.String("rg1"),
 * 			RuleCollectionName: pulumi.String("testRuleCollection"),
 * 			RuleName:           pulumi.String("SampleAdminRule"),
 * 			SourcePortRanges: pulumi.StringArray{
 * 				pulumi.String("0-65535"),
 * 			},
 * 			Sources: []network.AddressPrefixItemArgs{
 * 				{
 * 					AddressPrefix:     pulumi.String("Internet"),
 * 					AddressPrefixType: pulumi.String("ServiceTag"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.AdminRule;
 * import com.pulumi.azurenative.network.AdminRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var adminRule = new AdminRule("adminRule", AdminRuleArgs.builder()
 *             .access("Deny")
 *             .configurationName("myTestSecurityConfig")
 *             .description("This is Sample Admin Rule")
 *             .destinationPortRanges("22")
 *             .destinations(Map.ofEntries(
 *                 Map.entry("addressPrefix", "*"),
 *                 Map.entry("addressPrefixType", "IPPrefix")
 *             ))
 *             .direction("Inbound")
 *             .kind("Custom")
 *             .networkManagerName("testNetworkManager")
 *             .priority(1)
 *             .protocol("Tcp")
 *             .resourceGroupName("rg1")
 *             .ruleCollectionName("testRuleCollection")
 *             .ruleName("SampleAdminRule")
 *             .sourcePortRanges("0-65535")
 *             .sources(Map.ofEntries(
 *                 Map.entry("addressPrefix", "Internet"),
 *                 Map.entry("addressPrefixType", "ServiceTag")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:AdminRule SampleAdminRule /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkManagers/{networkManagerName}/securityAdminConfigurations/{configurationName}/ruleCollections/{ruleCollectionName}/rules/{ruleName}
 * ```
 */
public class AdminRule internal constructor(
    override val javaResource: com.pulumi.azurenative.network.AdminRule,
) : KotlinCustomResource(javaResource, AdminRuleMapper) {
    /**
     * Indicates the access allowed for this particular rule
     */
    public val access: Output<String>
        get() = javaResource.access().applyValue({ args0 -> args0 })

    /**
     * A description for this rule. Restricted to 140 chars.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The destination port ranges.
     */
    public val destinationPortRanges: Output<List<String>>?
        get() = javaResource.destinationPortRanges().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The destination address prefixes. CIDR or destination IP ranges.
     */
    public val destinations: Output<List<AddressPrefixItemResponse>>?
        get() = javaResource.destinations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> addressPrefixItemResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * Indicates if the traffic matched against the rule in inbound or outbound.
     */
    public val direction: Output<String>
        get() = javaResource.direction().applyValue({ args0 -> args0 })

    /**
     * A unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * Whether the rule is custom or default.
     * Expected value is 'Custom'.
     */
    public val kind: Output<String>
        get() = javaResource.kind().applyValue({ args0 -> args0 })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The priority of the rule. The value can be between 1 and 4096. The priority number must be unique for each rule in the collection. The lower the priority number, the higher the priority of the rule.
     */
    public val priority: Output<Int>
        get() = javaResource.priority().applyValue({ args0 -> args0 })

    /**
     * Network protocol this rule applies to.
     */
    public val protocol: Output<String>
        get() = javaResource.protocol().applyValue({ args0 -> args0 })

    /**
     * The provisioning state of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Unique identifier for this resource.
     */
    public val resourceGuid: Output<String>
        get() = javaResource.resourceGuid().applyValue({ args0 -> args0 })

    /**
     * The source port ranges.
     */
    public val sourcePortRanges: Output<List<String>>?
        get() = javaResource.sourcePortRanges().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The CIDR or source IP ranges.
     */
    public val sources: Output<List<AddressPrefixItemResponse>>?
        get() = javaResource.sources().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> addressPrefixItemResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The system metadata related to this resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object AdminRuleMapper : ResourceMapper<AdminRule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.AdminRule::class == javaResource::class

    override fun map(javaResource: Resource): AdminRule = AdminRule(
        javaResource as
            com.pulumi.azurenative.network.AdminRule,
    )
}

/**
 * @see [AdminRule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AdminRule].
 */
public suspend fun adminRule(name: String, block: suspend AdminRuleResourceBuilder.() -> Unit):
    AdminRule {
    val builder = AdminRuleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AdminRule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun adminRule(name: String): AdminRule {
    val builder = AdminRuleResourceBuilder()
    builder.name(name)
    return builder.build()
}
