@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.ApplicationGatewayArgs.builder
import com.pulumi.azurenative.network.kotlin.inputs.ApplicationGatewayAuthenticationCertificateArgs
import com.pulumi.azurenative.network.kotlin.inputs.ApplicationGatewayAuthenticationCertificateArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.ApplicationGatewayAutoscaleConfigurationArgs
import com.pulumi.azurenative.network.kotlin.inputs.ApplicationGatewayAutoscaleConfigurationArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.ApplicationGatewayBackendAddressPoolArgs
import com.pulumi.azurenative.network.kotlin.inputs.ApplicationGatewayBackendAddressPoolArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.ApplicationGatewayBackendHttpSettingsArgs
import com.pulumi.azurenative.network.kotlin.inputs.ApplicationGatewayBackendHttpSettingsArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.ApplicationGatewayBackendSettingsArgs
import com.pulumi.azurenative.network.kotlin.inputs.ApplicationGatewayBackendSettingsArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.ApplicationGatewayCustomErrorArgs
import com.pulumi.azurenative.network.kotlin.inputs.ApplicationGatewayCustomErrorArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.ApplicationGatewayFrontendIPConfigurationArgs
import com.pulumi.azurenative.network.kotlin.inputs.ApplicationGatewayFrontendIPConfigurationArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.ApplicationGatewayFrontendPortArgs
import com.pulumi.azurenative.network.kotlin.inputs.ApplicationGatewayFrontendPortArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.ApplicationGatewayGlobalConfigurationArgs
import com.pulumi.azurenative.network.kotlin.inputs.ApplicationGatewayGlobalConfigurationArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.ApplicationGatewayHttpListenerArgs
import com.pulumi.azurenative.network.kotlin.inputs.ApplicationGatewayHttpListenerArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.ApplicationGatewayIPConfigurationArgs
import com.pulumi.azurenative.network.kotlin.inputs.ApplicationGatewayIPConfigurationArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.ApplicationGatewayListenerArgs
import com.pulumi.azurenative.network.kotlin.inputs.ApplicationGatewayListenerArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.ApplicationGatewayLoadDistributionPolicyArgs
import com.pulumi.azurenative.network.kotlin.inputs.ApplicationGatewayLoadDistributionPolicyArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.ApplicationGatewayPrivateLinkConfigurationArgs
import com.pulumi.azurenative.network.kotlin.inputs.ApplicationGatewayPrivateLinkConfigurationArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.ApplicationGatewayProbeArgs
import com.pulumi.azurenative.network.kotlin.inputs.ApplicationGatewayProbeArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.ApplicationGatewayRedirectConfigurationArgs
import com.pulumi.azurenative.network.kotlin.inputs.ApplicationGatewayRedirectConfigurationArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.ApplicationGatewayRequestRoutingRuleArgs
import com.pulumi.azurenative.network.kotlin.inputs.ApplicationGatewayRequestRoutingRuleArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.ApplicationGatewayRewriteRuleSetArgs
import com.pulumi.azurenative.network.kotlin.inputs.ApplicationGatewayRewriteRuleSetArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.ApplicationGatewayRoutingRuleArgs
import com.pulumi.azurenative.network.kotlin.inputs.ApplicationGatewayRoutingRuleArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.ApplicationGatewaySkuArgs
import com.pulumi.azurenative.network.kotlin.inputs.ApplicationGatewaySkuArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.ApplicationGatewaySslCertificateArgs
import com.pulumi.azurenative.network.kotlin.inputs.ApplicationGatewaySslCertificateArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.ApplicationGatewaySslPolicyArgs
import com.pulumi.azurenative.network.kotlin.inputs.ApplicationGatewaySslPolicyArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.ApplicationGatewaySslProfileArgs
import com.pulumi.azurenative.network.kotlin.inputs.ApplicationGatewaySslProfileArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.ApplicationGatewayTrustedClientCertificateArgs
import com.pulumi.azurenative.network.kotlin.inputs.ApplicationGatewayTrustedClientCertificateArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.ApplicationGatewayTrustedRootCertificateArgs
import com.pulumi.azurenative.network.kotlin.inputs.ApplicationGatewayTrustedRootCertificateArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.ApplicationGatewayUrlPathMapArgs
import com.pulumi.azurenative.network.kotlin.inputs.ApplicationGatewayUrlPathMapArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.ApplicationGatewayWebApplicationFirewallConfigurationArgs
import com.pulumi.azurenative.network.kotlin.inputs.ApplicationGatewayWebApplicationFirewallConfigurationArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.ManagedServiceIdentityArgs
import com.pulumi.azurenative.network.kotlin.inputs.ManagedServiceIdentityArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.SubResourceArgs
import com.pulumi.azurenative.network.kotlin.inputs.SubResourceArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Application gateway resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2015-05-01-preview, 2019-06-01, 2019-08-01, 2023-04-01, 2023-05-01, 2023-06-01.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:ApplicationGateway appgw /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/applicationGateways/{applicationGatewayName}
 * ```
 * @property applicationGatewayName The name of the application gateway.
 * @property authenticationCertificates Authentication certificates of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
 * @property autoscaleConfiguration Autoscale Configuration.
 * @property backendAddressPools Backend address pool of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
 * @property backendHttpSettingsCollection Backend http settings of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
 * @property backendSettingsCollection Backend settings of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
 * @property customErrorConfigurations Custom error configurations of the application gateway resource.
 * @property enableFips Whether FIPS is enabled on the application gateway resource.
 * @property enableHttp2 Whether HTTP2 is enabled on the application gateway resource.
 * @property firewallPolicy Reference to the FirewallPolicy resource.
 * @property forceFirewallPolicyAssociation If true, associates a firewall policy with an application gateway regardless whether the policy differs from the WAF Config.
 * @property frontendIPConfigurations Frontend IP addresses of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
 * @property frontendPorts Frontend ports of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
 * @property gatewayIPConfigurations Subnets of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
 * @property globalConfiguration Global Configuration.
 * @property httpListeners Http listeners of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
 * @property id Resource ID.
 * @property identity The identity of the application gateway, if configured.
 * @property listeners Listeners of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
 * @property loadDistributionPolicies Load distribution policies of the application gateway resource.
 * @property location Resource location.
 * @property privateLinkConfigurations PrivateLink configurations on application gateway.
 * @property probes Probes of the application gateway resource.
 * @property redirectConfigurations Redirect configurations of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
 * @property requestRoutingRules Request routing rules of the application gateway resource.
 * @property resourceGroupName The name of the resource group.
 * @property rewriteRuleSets Rewrite rules for the application gateway resource.
 * @property routingRules Routing rules of the application gateway resource.
 * @property sku SKU of the application gateway resource.
 * @property sslCertificates SSL certificates of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
 * @property sslPolicy SSL policy of the application gateway resource.
 * @property sslProfiles SSL profiles of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
 * @property tags Resource tags.
 * @property trustedClientCertificates Trusted client certificates of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
 * @property trustedRootCertificates Trusted Root certificates of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
 * @property urlPathMaps URL path map of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
 * @property webApplicationFirewallConfiguration Web application firewall configuration.
 * @property zones A list of availability zones denoting where the resource needs to come from.
 */
public data class ApplicationGatewayArgs(
    public val applicationGatewayName: Output<String>? = null,
    public val authenticationCertificates:
    Output<List<ApplicationGatewayAuthenticationCertificateArgs>>? = null,
    public val autoscaleConfiguration: Output<ApplicationGatewayAutoscaleConfigurationArgs>? = null,
    public val backendAddressPools: Output<List<ApplicationGatewayBackendAddressPoolArgs>>? = null,
    public val backendHttpSettingsCollection: Output<List<ApplicationGatewayBackendHttpSettingsArgs>>? =
        null,
    public val backendSettingsCollection: Output<List<ApplicationGatewayBackendSettingsArgs>>? = null,
    public val customErrorConfigurations: Output<List<ApplicationGatewayCustomErrorArgs>>? = null,
    public val enableFips: Output<Boolean>? = null,
    public val enableHttp2: Output<Boolean>? = null,
    public val firewallPolicy: Output<SubResourceArgs>? = null,
    public val forceFirewallPolicyAssociation: Output<Boolean>? = null,
    public val frontendIPConfigurations: Output<List<ApplicationGatewayFrontendIPConfigurationArgs>>? =
        null,
    public val frontendPorts: Output<List<ApplicationGatewayFrontendPortArgs>>? = null,
    public val gatewayIPConfigurations: Output<List<ApplicationGatewayIPConfigurationArgs>>? = null,
    public val globalConfiguration: Output<ApplicationGatewayGlobalConfigurationArgs>? = null,
    public val httpListeners: Output<List<ApplicationGatewayHttpListenerArgs>>? = null,
    public val id: Output<String>? = null,
    public val identity: Output<ManagedServiceIdentityArgs>? = null,
    public val listeners: Output<List<ApplicationGatewayListenerArgs>>? = null,
    public val loadDistributionPolicies: Output<List<ApplicationGatewayLoadDistributionPolicyArgs>>? =
        null,
    public val location: Output<String>? = null,
    public val privateLinkConfigurations:
    Output<List<ApplicationGatewayPrivateLinkConfigurationArgs>>? = null,
    public val probes: Output<List<ApplicationGatewayProbeArgs>>? = null,
    public val redirectConfigurations: Output<List<ApplicationGatewayRedirectConfigurationArgs>>? =
        null,
    public val requestRoutingRules: Output<List<ApplicationGatewayRequestRoutingRuleArgs>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val rewriteRuleSets: Output<List<ApplicationGatewayRewriteRuleSetArgs>>? = null,
    public val routingRules: Output<List<ApplicationGatewayRoutingRuleArgs>>? = null,
    public val sku: Output<ApplicationGatewaySkuArgs>? = null,
    public val sslCertificates: Output<List<ApplicationGatewaySslCertificateArgs>>? = null,
    public val sslPolicy: Output<ApplicationGatewaySslPolicyArgs>? = null,
    public val sslProfiles: Output<List<ApplicationGatewaySslProfileArgs>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val trustedClientCertificates:
    Output<List<ApplicationGatewayTrustedClientCertificateArgs>>? = null,
    public val trustedRootCertificates: Output<List<ApplicationGatewayTrustedRootCertificateArgs>>? =
        null,
    public val urlPathMaps: Output<List<ApplicationGatewayUrlPathMapArgs>>? = null,
    public val webApplicationFirewallConfiguration:
    Output<ApplicationGatewayWebApplicationFirewallConfigurationArgs>? = null,
    public val zones: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.ApplicationGatewayArgs> {
    override fun toJava(): com.pulumi.azurenative.network.ApplicationGatewayArgs =
        com.pulumi.azurenative.network.ApplicationGatewayArgs.builder()
            .applicationGatewayName(applicationGatewayName?.applyValue({ args0 -> args0 }))
            .authenticationCertificates(
                authenticationCertificates?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .autoscaleConfiguration(
                autoscaleConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .backendAddressPools(
                backendAddressPools?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .backendHttpSettingsCollection(
                backendHttpSettingsCollection?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .backendSettingsCollection(
                backendSettingsCollection?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .customErrorConfigurations(
                customErrorConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .enableFips(enableFips?.applyValue({ args0 -> args0 }))
            .enableHttp2(enableHttp2?.applyValue({ args0 -> args0 }))
            .firewallPolicy(firewallPolicy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .forceFirewallPolicyAssociation(forceFirewallPolicyAssociation?.applyValue({ args0 -> args0 }))
            .frontendIPConfigurations(
                frontendIPConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .frontendPorts(
                frontendPorts?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .gatewayIPConfigurations(
                gatewayIPConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .globalConfiguration(
                globalConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .httpListeners(
                httpListeners?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .id(id?.applyValue({ args0 -> args0 }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .listeners(
                listeners?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .loadDistributionPolicies(
                loadDistributionPolicies?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .privateLinkConfigurations(
                privateLinkConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .probes(probes?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .redirectConfigurations(
                redirectConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .requestRoutingRules(
                requestRoutingRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .rewriteRuleSets(
                rewriteRuleSets?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .routingRules(
                routingRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sslCertificates(
                sslCertificates?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .sslPolicy(sslPolicy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sslProfiles(
                sslProfiles?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .trustedClientCertificates(
                trustedClientCertificates?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .trustedRootCertificates(
                trustedRootCertificates?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .urlPathMaps(
                urlPathMaps?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .webApplicationFirewallConfiguration(
                webApplicationFirewallConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .zones(zones?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ApplicationGatewayArgs].
 */
@PulumiTagMarker
public class ApplicationGatewayArgsBuilder internal constructor() {
    private var applicationGatewayName: Output<String>? = null

    private var authenticationCertificates:
        Output<List<ApplicationGatewayAuthenticationCertificateArgs>>? = null

    private var autoscaleConfiguration: Output<ApplicationGatewayAutoscaleConfigurationArgs>? = null

    private var backendAddressPools: Output<List<ApplicationGatewayBackendAddressPoolArgs>>? = null

    private var backendHttpSettingsCollection:
        Output<List<ApplicationGatewayBackendHttpSettingsArgs>>? = null

    private var backendSettingsCollection: Output<List<ApplicationGatewayBackendSettingsArgs>>? = null

    private var customErrorConfigurations: Output<List<ApplicationGatewayCustomErrorArgs>>? = null

    private var enableFips: Output<Boolean>? = null

    private var enableHttp2: Output<Boolean>? = null

    private var firewallPolicy: Output<SubResourceArgs>? = null

    private var forceFirewallPolicyAssociation: Output<Boolean>? = null

    private var frontendIPConfigurations: Output<List<ApplicationGatewayFrontendIPConfigurationArgs>>? =
        null

    private var frontendPorts: Output<List<ApplicationGatewayFrontendPortArgs>>? = null

    private var gatewayIPConfigurations: Output<List<ApplicationGatewayIPConfigurationArgs>>? = null

    private var globalConfiguration: Output<ApplicationGatewayGlobalConfigurationArgs>? = null

    private var httpListeners: Output<List<ApplicationGatewayHttpListenerArgs>>? = null

    private var id: Output<String>? = null

    private var identity: Output<ManagedServiceIdentityArgs>? = null

    private var listeners: Output<List<ApplicationGatewayListenerArgs>>? = null

    private var loadDistributionPolicies: Output<List<ApplicationGatewayLoadDistributionPolicyArgs>>? =
        null

    private var location: Output<String>? = null

    private var privateLinkConfigurations:
        Output<List<ApplicationGatewayPrivateLinkConfigurationArgs>>? = null

    private var probes: Output<List<ApplicationGatewayProbeArgs>>? = null

    private var redirectConfigurations: Output<List<ApplicationGatewayRedirectConfigurationArgs>>? =
        null

    private var requestRoutingRules: Output<List<ApplicationGatewayRequestRoutingRuleArgs>>? = null

    private var resourceGroupName: Output<String>? = null

    private var rewriteRuleSets: Output<List<ApplicationGatewayRewriteRuleSetArgs>>? = null

    private var routingRules: Output<List<ApplicationGatewayRoutingRuleArgs>>? = null

    private var sku: Output<ApplicationGatewaySkuArgs>? = null

    private var sslCertificates: Output<List<ApplicationGatewaySslCertificateArgs>>? = null

    private var sslPolicy: Output<ApplicationGatewaySslPolicyArgs>? = null

    private var sslProfiles: Output<List<ApplicationGatewaySslProfileArgs>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var trustedClientCertificates:
        Output<List<ApplicationGatewayTrustedClientCertificateArgs>>? = null

    private var trustedRootCertificates: Output<List<ApplicationGatewayTrustedRootCertificateArgs>>? =
        null

    private var urlPathMaps: Output<List<ApplicationGatewayUrlPathMapArgs>>? = null

    private var webApplicationFirewallConfiguration:
        Output<ApplicationGatewayWebApplicationFirewallConfigurationArgs>? = null

    private var zones: Output<List<String>>? = null

    /**
     * @param value The name of the application gateway.
     */
    @JvmName("keegqnxcgnpkpsve")
    public suspend fun applicationGatewayName(`value`: Output<String>) {
        this.applicationGatewayName = value
    }

    /**
     * @param value Authentication certificates of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("ckgdbskidjabceph")
    public suspend
    fun authenticationCertificates(`value`: Output<List<ApplicationGatewayAuthenticationCertificateArgs>>) {
        this.authenticationCertificates = value
    }

    @JvmName("puomlcndupwkmlhc")
    public suspend fun authenticationCertificates(
        vararg
        values: Output<ApplicationGatewayAuthenticationCertificateArgs>,
    ) {
        this.authenticationCertificates = Output.all(values.asList())
    }

    /**
     * @param values Authentication certificates of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("lbkumeqwaspwuneb")
    public suspend
    fun authenticationCertificates(values: List<Output<ApplicationGatewayAuthenticationCertificateArgs>>) {
        this.authenticationCertificates = Output.all(values)
    }

    /**
     * @param value Autoscale Configuration.
     */
    @JvmName("olgdeycdrgyfveoe")
    public suspend
    fun autoscaleConfiguration(`value`: Output<ApplicationGatewayAutoscaleConfigurationArgs>) {
        this.autoscaleConfiguration = value
    }

    /**
     * @param value Backend address pool of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("eobjuyltinawqyla")
    public suspend
    fun backendAddressPools(`value`: Output<List<ApplicationGatewayBackendAddressPoolArgs>>) {
        this.backendAddressPools = value
    }

    @JvmName("nuccwilveyepflgf")
    public suspend fun backendAddressPools(
        vararg
        values: Output<ApplicationGatewayBackendAddressPoolArgs>,
    ) {
        this.backendAddressPools = Output.all(values.asList())
    }

    /**
     * @param values Backend address pool of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("owcqqrvhmiadmokk")
    public suspend
    fun backendAddressPools(values: List<Output<ApplicationGatewayBackendAddressPoolArgs>>) {
        this.backendAddressPools = Output.all(values)
    }

    /**
     * @param value Backend http settings of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("dmvwuehxieugmwxf")
    public suspend
    fun backendHttpSettingsCollection(`value`: Output<List<ApplicationGatewayBackendHttpSettingsArgs>>) {
        this.backendHttpSettingsCollection = value
    }

    @JvmName("qmsfbubfggngrmtj")
    public suspend fun backendHttpSettingsCollection(
        vararg
        values: Output<ApplicationGatewayBackendHttpSettingsArgs>,
    ) {
        this.backendHttpSettingsCollection = Output.all(values.asList())
    }

    /**
     * @param values Backend http settings of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("ursqesownkljdkty")
    public suspend
    fun backendHttpSettingsCollection(values: List<Output<ApplicationGatewayBackendHttpSettingsArgs>>) {
        this.backendHttpSettingsCollection = Output.all(values)
    }

    /**
     * @param value Backend settings of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("bxdnsalpvpfpyqem")
    public suspend
    fun backendSettingsCollection(`value`: Output<List<ApplicationGatewayBackendSettingsArgs>>) {
        this.backendSettingsCollection = value
    }

    @JvmName("rhopjgdbgmqdqtha")
    public suspend fun backendSettingsCollection(
        vararg
        values: Output<ApplicationGatewayBackendSettingsArgs>,
    ) {
        this.backendSettingsCollection = Output.all(values.asList())
    }

    /**
     * @param values Backend settings of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("mpxwisfuqhyjtaik")
    public suspend
    fun backendSettingsCollection(values: List<Output<ApplicationGatewayBackendSettingsArgs>>) {
        this.backendSettingsCollection = Output.all(values)
    }

    /**
     * @param value Custom error configurations of the application gateway resource.
     */
    @JvmName("vmdhwquasjfpgmys")
    public suspend
    fun customErrorConfigurations(`value`: Output<List<ApplicationGatewayCustomErrorArgs>>) {
        this.customErrorConfigurations = value
    }

    @JvmName("cpvvclifkimjvubh")
    public suspend fun customErrorConfigurations(
        vararg
        values: Output<ApplicationGatewayCustomErrorArgs>,
    ) {
        this.customErrorConfigurations = Output.all(values.asList())
    }

    /**
     * @param values Custom error configurations of the application gateway resource.
     */
    @JvmName("qhckdquwqamrxkfk")
    public suspend
    fun customErrorConfigurations(values: List<Output<ApplicationGatewayCustomErrorArgs>>) {
        this.customErrorConfigurations = Output.all(values)
    }

    /**
     * @param value Whether FIPS is enabled on the application gateway resource.
     */
    @JvmName("qljmotqmqgnoqipc")
    public suspend fun enableFips(`value`: Output<Boolean>) {
        this.enableFips = value
    }

    /**
     * @param value Whether HTTP2 is enabled on the application gateway resource.
     */
    @JvmName("eefymoivimwxtvmb")
    public suspend fun enableHttp2(`value`: Output<Boolean>) {
        this.enableHttp2 = value
    }

    /**
     * @param value Reference to the FirewallPolicy resource.
     */
    @JvmName("bfdylnpcahhwdjvq")
    public suspend fun firewallPolicy(`value`: Output<SubResourceArgs>) {
        this.firewallPolicy = value
    }

    /**
     * @param value If true, associates a firewall policy with an application gateway regardless whether the policy differs from the WAF Config.
     */
    @JvmName("vcitrmpcglysyyrh")
    public suspend fun forceFirewallPolicyAssociation(`value`: Output<Boolean>) {
        this.forceFirewallPolicyAssociation = value
    }

    /**
     * @param value Frontend IP addresses of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("ipadfmlorcyeuvyf")
    public suspend
    fun frontendIPConfigurations(`value`: Output<List<ApplicationGatewayFrontendIPConfigurationArgs>>) {
        this.frontendIPConfigurations = value
    }

    @JvmName("yjnipfjtucvrcvub")
    public suspend fun frontendIPConfigurations(
        vararg
        values: Output<ApplicationGatewayFrontendIPConfigurationArgs>,
    ) {
        this.frontendIPConfigurations = Output.all(values.asList())
    }

    /**
     * @param values Frontend IP addresses of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("lfbbptpiphlfnjkw")
    public suspend
    fun frontendIPConfigurations(values: List<Output<ApplicationGatewayFrontendIPConfigurationArgs>>) {
        this.frontendIPConfigurations = Output.all(values)
    }

    /**
     * @param value Frontend ports of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("ldsnkkftjehgihsg")
    public suspend fun frontendPorts(`value`: Output<List<ApplicationGatewayFrontendPortArgs>>) {
        this.frontendPorts = value
    }

    @JvmName("ikfmfbvkgokoiivs")
    public suspend fun frontendPorts(vararg values: Output<ApplicationGatewayFrontendPortArgs>) {
        this.frontendPorts = Output.all(values.asList())
    }

    /**
     * @param values Frontend ports of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("dahlqqiuqhuxrigf")
    public suspend fun frontendPorts(values: List<Output<ApplicationGatewayFrontendPortArgs>>) {
        this.frontendPorts = Output.all(values)
    }

    /**
     * @param value Subnets of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("dttcysrqpyjfkyfl")
    public suspend
    fun gatewayIPConfigurations(`value`: Output<List<ApplicationGatewayIPConfigurationArgs>>) {
        this.gatewayIPConfigurations = value
    }

    @JvmName("vorflgvcbtrxlmca")
    public suspend fun gatewayIPConfigurations(
        vararg
        values: Output<ApplicationGatewayIPConfigurationArgs>,
    ) {
        this.gatewayIPConfigurations = Output.all(values.asList())
    }

    /**
     * @param values Subnets of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("lwwextsdcahpenkg")
    public suspend
    fun gatewayIPConfigurations(values: List<Output<ApplicationGatewayIPConfigurationArgs>>) {
        this.gatewayIPConfigurations = Output.all(values)
    }

    /**
     * @param value Global Configuration.
     */
    @JvmName("frfqdvvxgouovtff")
    public suspend
    fun globalConfiguration(`value`: Output<ApplicationGatewayGlobalConfigurationArgs>) {
        this.globalConfiguration = value
    }

    /**
     * @param value Http listeners of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("xvohtoucitbfvgpy")
    public suspend fun httpListeners(`value`: Output<List<ApplicationGatewayHttpListenerArgs>>) {
        this.httpListeners = value
    }

    @JvmName("eobqhcqlcvwyrsqo")
    public suspend fun httpListeners(vararg values: Output<ApplicationGatewayHttpListenerArgs>) {
        this.httpListeners = Output.all(values.asList())
    }

    /**
     * @param values Http listeners of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("ybdaicjadxccivqv")
    public suspend fun httpListeners(values: List<Output<ApplicationGatewayHttpListenerArgs>>) {
        this.httpListeners = Output.all(values)
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("cuwdqjnfmtibmtln")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The identity of the application gateway, if configured.
     */
    @JvmName("ugowfjrfxsxfjrcr")
    public suspend fun identity(`value`: Output<ManagedServiceIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value Listeners of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("moppdfqdubgdnoua")
    public suspend fun listeners(`value`: Output<List<ApplicationGatewayListenerArgs>>) {
        this.listeners = value
    }

    @JvmName("ixqwyvuswjajgpoo")
    public suspend fun listeners(vararg values: Output<ApplicationGatewayListenerArgs>) {
        this.listeners = Output.all(values.asList())
    }

    /**
     * @param values Listeners of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("jwwoydugbltwtjif")
    public suspend fun listeners(values: List<Output<ApplicationGatewayListenerArgs>>) {
        this.listeners = Output.all(values)
    }

    /**
     * @param value Load distribution policies of the application gateway resource.
     */
    @JvmName("ropumwdmbovshyml")
    public suspend
    fun loadDistributionPolicies(`value`: Output<List<ApplicationGatewayLoadDistributionPolicyArgs>>) {
        this.loadDistributionPolicies = value
    }

    @JvmName("gvuuyysbpdfhqntv")
    public suspend fun loadDistributionPolicies(
        vararg
        values: Output<ApplicationGatewayLoadDistributionPolicyArgs>,
    ) {
        this.loadDistributionPolicies = Output.all(values.asList())
    }

    /**
     * @param values Load distribution policies of the application gateway resource.
     */
    @JvmName("mvjywowvejcurulw")
    public suspend
    fun loadDistributionPolicies(values: List<Output<ApplicationGatewayLoadDistributionPolicyArgs>>) {
        this.loadDistributionPolicies = Output.all(values)
    }

    /**
     * @param value Resource location.
     */
    @JvmName("xtbyhedoehgjtsin")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value PrivateLink configurations on application gateway.
     */
    @JvmName("vwiqvtaawbausuhk")
    public suspend
    fun privateLinkConfigurations(`value`: Output<List<ApplicationGatewayPrivateLinkConfigurationArgs>>) {
        this.privateLinkConfigurations = value
    }

    @JvmName("ljpijdflojqblant")
    public suspend fun privateLinkConfigurations(
        vararg
        values: Output<ApplicationGatewayPrivateLinkConfigurationArgs>,
    ) {
        this.privateLinkConfigurations = Output.all(values.asList())
    }

    /**
     * @param values PrivateLink configurations on application gateway.
     */
    @JvmName("mrkmjikuogflwldu")
    public suspend
    fun privateLinkConfigurations(values: List<Output<ApplicationGatewayPrivateLinkConfigurationArgs>>) {
        this.privateLinkConfigurations = Output.all(values)
    }

    /**
     * @param value Probes of the application gateway resource.
     */
    @JvmName("uehgujtaxxppifnh")
    public suspend fun probes(`value`: Output<List<ApplicationGatewayProbeArgs>>) {
        this.probes = value
    }

    @JvmName("tdjbrckgdlusujfc")
    public suspend fun probes(vararg values: Output<ApplicationGatewayProbeArgs>) {
        this.probes = Output.all(values.asList())
    }

    /**
     * @param values Probes of the application gateway resource.
     */
    @JvmName("coqrbknediwerkup")
    public suspend fun probes(values: List<Output<ApplicationGatewayProbeArgs>>) {
        this.probes = Output.all(values)
    }

    /**
     * @param value Redirect configurations of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("btrqenkkulchktvd")
    public suspend
    fun redirectConfigurations(`value`: Output<List<ApplicationGatewayRedirectConfigurationArgs>>) {
        this.redirectConfigurations = value
    }

    @JvmName("cviuwjykliowahro")
    public suspend fun redirectConfigurations(
        vararg
        values: Output<ApplicationGatewayRedirectConfigurationArgs>,
    ) {
        this.redirectConfigurations = Output.all(values.asList())
    }

    /**
     * @param values Redirect configurations of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("gyniwvqrjpfcrhba")
    public suspend
    fun redirectConfigurations(values: List<Output<ApplicationGatewayRedirectConfigurationArgs>>) {
        this.redirectConfigurations = Output.all(values)
    }

    /**
     * @param value Request routing rules of the application gateway resource.
     */
    @JvmName("weukpwrmhbupyqlv")
    public suspend
    fun requestRoutingRules(`value`: Output<List<ApplicationGatewayRequestRoutingRuleArgs>>) {
        this.requestRoutingRules = value
    }

    @JvmName("yfpbjomwuopgosie")
    public suspend fun requestRoutingRules(
        vararg
        values: Output<ApplicationGatewayRequestRoutingRuleArgs>,
    ) {
        this.requestRoutingRules = Output.all(values.asList())
    }

    /**
     * @param values Request routing rules of the application gateway resource.
     */
    @JvmName("somhictanfndteys")
    public suspend
    fun requestRoutingRules(values: List<Output<ApplicationGatewayRequestRoutingRuleArgs>>) {
        this.requestRoutingRules = Output.all(values)
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("erreaqwsrchjovjt")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Rewrite rules for the application gateway resource.
     */
    @JvmName("llyhmklonjaixwik")
    public suspend fun rewriteRuleSets(`value`: Output<List<ApplicationGatewayRewriteRuleSetArgs>>) {
        this.rewriteRuleSets = value
    }

    @JvmName("tjdaqqturqgkmqjh")
    public suspend fun rewriteRuleSets(vararg values: Output<ApplicationGatewayRewriteRuleSetArgs>) {
        this.rewriteRuleSets = Output.all(values.asList())
    }

    /**
     * @param values Rewrite rules for the application gateway resource.
     */
    @JvmName("hgbgvcjeoadncbam")
    public suspend fun rewriteRuleSets(values: List<Output<ApplicationGatewayRewriteRuleSetArgs>>) {
        this.rewriteRuleSets = Output.all(values)
    }

    /**
     * @param value Routing rules of the application gateway resource.
     */
    @JvmName("pcfltpqdilmwqrjv")
    public suspend fun routingRules(`value`: Output<List<ApplicationGatewayRoutingRuleArgs>>) {
        this.routingRules = value
    }

    @JvmName("vvdtbkmsoiqvdppq")
    public suspend fun routingRules(vararg values: Output<ApplicationGatewayRoutingRuleArgs>) {
        this.routingRules = Output.all(values.asList())
    }

    /**
     * @param values Routing rules of the application gateway resource.
     */
    @JvmName("eahbgktnrbixhqrf")
    public suspend fun routingRules(values: List<Output<ApplicationGatewayRoutingRuleArgs>>) {
        this.routingRules = Output.all(values)
    }

    /**
     * @param value SKU of the application gateway resource.
     */
    @JvmName("rsoadbpkedomjoxr")
    public suspend fun sku(`value`: Output<ApplicationGatewaySkuArgs>) {
        this.sku = value
    }

    /**
     * @param value SSL certificates of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("lnsgxoejcqhdabec")
    public suspend fun sslCertificates(`value`: Output<List<ApplicationGatewaySslCertificateArgs>>) {
        this.sslCertificates = value
    }

    @JvmName("dxuiddgtwdraorts")
    public suspend fun sslCertificates(vararg values: Output<ApplicationGatewaySslCertificateArgs>) {
        this.sslCertificates = Output.all(values.asList())
    }

    /**
     * @param values SSL certificates of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("elcpnvvcnhdbrtwl")
    public suspend fun sslCertificates(values: List<Output<ApplicationGatewaySslCertificateArgs>>) {
        this.sslCertificates = Output.all(values)
    }

    /**
     * @param value SSL policy of the application gateway resource.
     */
    @JvmName("gabnbhsxlnotsher")
    public suspend fun sslPolicy(`value`: Output<ApplicationGatewaySslPolicyArgs>) {
        this.sslPolicy = value
    }

    /**
     * @param value SSL profiles of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("dpfmauygekfkyxtt")
    public suspend fun sslProfiles(`value`: Output<List<ApplicationGatewaySslProfileArgs>>) {
        this.sslProfiles = value
    }

    @JvmName("lfbtgfhcxyrkoywc")
    public suspend fun sslProfiles(vararg values: Output<ApplicationGatewaySslProfileArgs>) {
        this.sslProfiles = Output.all(values.asList())
    }

    /**
     * @param values SSL profiles of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("iygdysdvnwvstwta")
    public suspend fun sslProfiles(values: List<Output<ApplicationGatewaySslProfileArgs>>) {
        this.sslProfiles = Output.all(values)
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("niujktafyfraeeej")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Trusted client certificates of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("vuhhnpfntsicskeq")
    public suspend
    fun trustedClientCertificates(`value`: Output<List<ApplicationGatewayTrustedClientCertificateArgs>>) {
        this.trustedClientCertificates = value
    }

    @JvmName("vhtyibgoehdwteqa")
    public suspend fun trustedClientCertificates(
        vararg
        values: Output<ApplicationGatewayTrustedClientCertificateArgs>,
    ) {
        this.trustedClientCertificates = Output.all(values.asList())
    }

    /**
     * @param values Trusted client certificates of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("kvbeudghyuboqqji")
    public suspend
    fun trustedClientCertificates(values: List<Output<ApplicationGatewayTrustedClientCertificateArgs>>) {
        this.trustedClientCertificates = Output.all(values)
    }

    /**
     * @param value Trusted Root certificates of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("jbiiijeaxokrqagu")
    public suspend
    fun trustedRootCertificates(`value`: Output<List<ApplicationGatewayTrustedRootCertificateArgs>>) {
        this.trustedRootCertificates = value
    }

    @JvmName("kvphacehveloeock")
    public suspend fun trustedRootCertificates(
        vararg
        values: Output<ApplicationGatewayTrustedRootCertificateArgs>,
    ) {
        this.trustedRootCertificates = Output.all(values.asList())
    }

    /**
     * @param values Trusted Root certificates of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("amkvgbaggthfuwji")
    public suspend
    fun trustedRootCertificates(values: List<Output<ApplicationGatewayTrustedRootCertificateArgs>>) {
        this.trustedRootCertificates = Output.all(values)
    }

    /**
     * @param value URL path map of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("boelxmjqgtviiquc")
    public suspend fun urlPathMaps(`value`: Output<List<ApplicationGatewayUrlPathMapArgs>>) {
        this.urlPathMaps = value
    }

    @JvmName("umheesaiiyllicbm")
    public suspend fun urlPathMaps(vararg values: Output<ApplicationGatewayUrlPathMapArgs>) {
        this.urlPathMaps = Output.all(values.asList())
    }

    /**
     * @param values URL path map of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("bymbkxfxpmmyfidb")
    public suspend fun urlPathMaps(values: List<Output<ApplicationGatewayUrlPathMapArgs>>) {
        this.urlPathMaps = Output.all(values)
    }

    /**
     * @param value Web application firewall configuration.
     */
    @JvmName("huoribfcirrcmqvb")
    public suspend
    fun webApplicationFirewallConfiguration(`value`: Output<ApplicationGatewayWebApplicationFirewallConfigurationArgs>) {
        this.webApplicationFirewallConfiguration = value
    }

    /**
     * @param value A list of availability zones denoting where the resource needs to come from.
     */
    @JvmName("gqeqmxxykuhgagwp")
    public suspend fun zones(`value`: Output<List<String>>) {
        this.zones = value
    }

    @JvmName("avcmrvehfdhjivob")
    public suspend fun zones(vararg values: Output<String>) {
        this.zones = Output.all(values.asList())
    }

    /**
     * @param values A list of availability zones denoting where the resource needs to come from.
     */
    @JvmName("mywqgaxjmbbwcjpi")
    public suspend fun zones(values: List<Output<String>>) {
        this.zones = Output.all(values)
    }

    /**
     * @param value The name of the application gateway.
     */
    @JvmName("pmroaklrdjaqqoiv")
    public suspend fun applicationGatewayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationGatewayName = mapped
    }

    /**
     * @param value Authentication certificates of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("cdiigxrophlmyerq")
    public suspend
    fun authenticationCertificates(`value`: List<ApplicationGatewayAuthenticationCertificateArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authenticationCertificates = mapped
    }

    /**
     * @param argument Authentication certificates of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("cotyipauvugohxaa")
    public suspend
    fun authenticationCertificates(argument: List<suspend ApplicationGatewayAuthenticationCertificateArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ApplicationGatewayAuthenticationCertificateArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.authenticationCertificates = mapped
    }

    /**
     * @param argument Authentication certificates of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("noaykxnphnrarmaa")
    public suspend fun authenticationCertificates(
        vararg
        argument: suspend ApplicationGatewayAuthenticationCertificateArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ApplicationGatewayAuthenticationCertificateArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.authenticationCertificates = mapped
    }

    /**
     * @param argument Authentication certificates of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("bqagmjrfvlcrxsfb")
    public suspend
    fun authenticationCertificates(argument: suspend ApplicationGatewayAuthenticationCertificateArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ApplicationGatewayAuthenticationCertificateArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.authenticationCertificates = mapped
    }

    /**
     * @param values Authentication certificates of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("symwddebbpnoofct")
    public suspend fun authenticationCertificates(
        vararg
        values: ApplicationGatewayAuthenticationCertificateArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationCertificates = mapped
    }

    /**
     * @param value Autoscale Configuration.
     */
    @JvmName("bpcbncffsuyxbavx")
    public suspend
    fun autoscaleConfiguration(`value`: ApplicationGatewayAutoscaleConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoscaleConfiguration = mapped
    }

    /**
     * @param argument Autoscale Configuration.
     */
    @JvmName("virhfwpkpkbtxmgw")
    public suspend
    fun autoscaleConfiguration(argument: suspend ApplicationGatewayAutoscaleConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ApplicationGatewayAutoscaleConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.autoscaleConfiguration = mapped
    }

    /**
     * @param value Backend address pool of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("oudtqflmsifpdoos")
    public suspend fun backendAddressPools(`value`: List<ApplicationGatewayBackendAddressPoolArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backendAddressPools = mapped
    }

    /**
     * @param argument Backend address pool of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("nhmbtvgaryaorgky")
    public suspend
    fun backendAddressPools(argument: List<suspend ApplicationGatewayBackendAddressPoolArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ApplicationGatewayBackendAddressPoolArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.backendAddressPools = mapped
    }

    /**
     * @param argument Backend address pool of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("edsfwuadqaepkyjq")
    public suspend fun backendAddressPools(
        vararg
        argument: suspend ApplicationGatewayBackendAddressPoolArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ApplicationGatewayBackendAddressPoolArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.backendAddressPools = mapped
    }

    /**
     * @param argument Backend address pool of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("vxqcuuesnlwemaas")
    public suspend
    fun backendAddressPools(argument: suspend ApplicationGatewayBackendAddressPoolArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ApplicationGatewayBackendAddressPoolArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.backendAddressPools = mapped
    }

    /**
     * @param values Backend address pool of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("evaaoqhayybrjtxr")
    public suspend fun backendAddressPools(vararg values: ApplicationGatewayBackendAddressPoolArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.backendAddressPools = mapped
    }

    /**
     * @param value Backend http settings of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("jjbuwajlenjuscdw")
    public suspend
    fun backendHttpSettingsCollection(`value`: List<ApplicationGatewayBackendHttpSettingsArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backendHttpSettingsCollection = mapped
    }

    /**
     * @param argument Backend http settings of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("eqaylleqmynmvefy")
    public suspend
    fun backendHttpSettingsCollection(argument: List<suspend ApplicationGatewayBackendHttpSettingsArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ApplicationGatewayBackendHttpSettingsArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.backendHttpSettingsCollection = mapped
    }

    /**
     * @param argument Backend http settings of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("jgbejfwvqycshrai")
    public suspend fun backendHttpSettingsCollection(
        vararg
        argument: suspend ApplicationGatewayBackendHttpSettingsArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ApplicationGatewayBackendHttpSettingsArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.backendHttpSettingsCollection = mapped
    }

    /**
     * @param argument Backend http settings of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("lnwfpeaaafjbmjem")
    public suspend
    fun backendHttpSettingsCollection(argument: suspend ApplicationGatewayBackendHttpSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ApplicationGatewayBackendHttpSettingsArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.backendHttpSettingsCollection = mapped
    }

    /**
     * @param values Backend http settings of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("spxygkvsdqsbymvt")
    public suspend fun backendHttpSettingsCollection(
        vararg
        values: ApplicationGatewayBackendHttpSettingsArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.backendHttpSettingsCollection = mapped
    }

    /**
     * @param value Backend settings of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("tuhewthqlykmwsov")
    public suspend
    fun backendSettingsCollection(`value`: List<ApplicationGatewayBackendSettingsArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backendSettingsCollection = mapped
    }

    /**
     * @param argument Backend settings of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("rdymcjrpptncaovi")
    public suspend
    fun backendSettingsCollection(argument: List<suspend ApplicationGatewayBackendSettingsArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ApplicationGatewayBackendSettingsArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.backendSettingsCollection = mapped
    }

    /**
     * @param argument Backend settings of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("mtjmxunyjltwyrgd")
    public suspend fun backendSettingsCollection(
        vararg
        argument: suspend ApplicationGatewayBackendSettingsArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ApplicationGatewayBackendSettingsArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.backendSettingsCollection = mapped
    }

    /**
     * @param argument Backend settings of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("kfttwrlhdxijanyj")
    public suspend
    fun backendSettingsCollection(argument: suspend ApplicationGatewayBackendSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ApplicationGatewayBackendSettingsArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.backendSettingsCollection = mapped
    }

    /**
     * @param values Backend settings of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("cmequebaebponpex")
    public suspend fun backendSettingsCollection(
        vararg
        values: ApplicationGatewayBackendSettingsArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.backendSettingsCollection = mapped
    }

    /**
     * @param value Custom error configurations of the application gateway resource.
     */
    @JvmName("wewrgqdljfnlfmei")
    public suspend fun customErrorConfigurations(`value`: List<ApplicationGatewayCustomErrorArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customErrorConfigurations = mapped
    }

    /**
     * @param argument Custom error configurations of the application gateway resource.
     */
    @JvmName("djwlfjfnjfwjccli")
    public suspend
    fun customErrorConfigurations(argument: List<suspend ApplicationGatewayCustomErrorArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ApplicationGatewayCustomErrorArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.customErrorConfigurations = mapped
    }

    /**
     * @param argument Custom error configurations of the application gateway resource.
     */
    @JvmName("fncuwjopnlhkvlpu")
    public suspend fun customErrorConfigurations(
        vararg
        argument: suspend ApplicationGatewayCustomErrorArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ApplicationGatewayCustomErrorArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.customErrorConfigurations = mapped
    }

    /**
     * @param argument Custom error configurations of the application gateway resource.
     */
    @JvmName("kncvthnruqskksbg")
    public suspend
    fun customErrorConfigurations(argument: suspend ApplicationGatewayCustomErrorArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ApplicationGatewayCustomErrorArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.customErrorConfigurations = mapped
    }

    /**
     * @param values Custom error configurations of the application gateway resource.
     */
    @JvmName("lroevtlkccwrgqvc")
    public suspend fun customErrorConfigurations(vararg values: ApplicationGatewayCustomErrorArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customErrorConfigurations = mapped
    }

    /**
     * @param value Whether FIPS is enabled on the application gateway resource.
     */
    @JvmName("qhctpbxfvuiesiii")
    public suspend fun enableFips(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableFips = mapped
    }

    /**
     * @param value Whether HTTP2 is enabled on the application gateway resource.
     */
    @JvmName("wsmwwiddxbkxusra")
    public suspend fun enableHttp2(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableHttp2 = mapped
    }

    /**
     * @param value Reference to the FirewallPolicy resource.
     */
    @JvmName("spfknrqhmxmpxmmn")
    public suspend fun firewallPolicy(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.firewallPolicy = mapped
    }

    /**
     * @param argument Reference to the FirewallPolicy resource.
     */
    @JvmName("henfuohhmyyybcfv")
    public suspend fun firewallPolicy(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.firewallPolicy = mapped
    }

    /**
     * @param value If true, associates a firewall policy with an application gateway regardless whether the policy differs from the WAF Config.
     */
    @JvmName("tikyabybawkgsvtv")
    public suspend fun forceFirewallPolicyAssociation(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forceFirewallPolicyAssociation = mapped
    }

    /**
     * @param value Frontend IP addresses of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("jtbaufxieikxjcxi")
    public suspend
    fun frontendIPConfigurations(`value`: List<ApplicationGatewayFrontendIPConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.frontendIPConfigurations = mapped
    }

    /**
     * @param argument Frontend IP addresses of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("eyjrvrcwgxgtwybl")
    public suspend
    fun frontendIPConfigurations(argument: List<suspend ApplicationGatewayFrontendIPConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ApplicationGatewayFrontendIPConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.frontendIPConfigurations = mapped
    }

    /**
     * @param argument Frontend IP addresses of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("vmjlbyvdqtkrogae")
    public suspend fun frontendIPConfigurations(
        vararg
        argument: suspend ApplicationGatewayFrontendIPConfigurationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ApplicationGatewayFrontendIPConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.frontendIPConfigurations = mapped
    }

    /**
     * @param argument Frontend IP addresses of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("cucswxtqtutreqcr")
    public suspend
    fun frontendIPConfigurations(argument: suspend ApplicationGatewayFrontendIPConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ApplicationGatewayFrontendIPConfigurationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.frontendIPConfigurations = mapped
    }

    /**
     * @param values Frontend IP addresses of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("bhxqjkxaithauvtg")
    public suspend fun frontendIPConfigurations(
        vararg
        values: ApplicationGatewayFrontendIPConfigurationArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.frontendIPConfigurations = mapped
    }

    /**
     * @param value Frontend ports of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("cyclttvlqcdxwxjb")
    public suspend fun frontendPorts(`value`: List<ApplicationGatewayFrontendPortArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.frontendPorts = mapped
    }

    /**
     * @param argument Frontend ports of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("iwqpdrbndjgganxl")
    public suspend
    fun frontendPorts(argument: List<suspend ApplicationGatewayFrontendPortArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ApplicationGatewayFrontendPortArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.frontendPorts = mapped
    }

    /**
     * @param argument Frontend ports of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("jkukgiiyvexdayyl")
    public suspend fun frontendPorts(
        vararg
        argument: suspend ApplicationGatewayFrontendPortArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ApplicationGatewayFrontendPortArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.frontendPorts = mapped
    }

    /**
     * @param argument Frontend ports of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("klisylppuijrbjbt")
    public suspend
    fun frontendPorts(argument: suspend ApplicationGatewayFrontendPortArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ApplicationGatewayFrontendPortArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.frontendPorts = mapped
    }

    /**
     * @param values Frontend ports of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("josrgdhfthhotiph")
    public suspend fun frontendPorts(vararg values: ApplicationGatewayFrontendPortArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.frontendPorts = mapped
    }

    /**
     * @param value Subnets of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("gdxvktcaslruofiy")
    public suspend
    fun gatewayIPConfigurations(`value`: List<ApplicationGatewayIPConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gatewayIPConfigurations = mapped
    }

    /**
     * @param argument Subnets of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("bvkyslbvphjxvhwk")
    public suspend
    fun gatewayIPConfigurations(argument: List<suspend ApplicationGatewayIPConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ApplicationGatewayIPConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.gatewayIPConfigurations = mapped
    }

    /**
     * @param argument Subnets of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("duffophaqsogkdxm")
    public suspend fun gatewayIPConfigurations(
        vararg
        argument: suspend ApplicationGatewayIPConfigurationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ApplicationGatewayIPConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.gatewayIPConfigurations = mapped
    }

    /**
     * @param argument Subnets of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("juuftifbmuolfyry")
    public suspend
    fun gatewayIPConfigurations(argument: suspend ApplicationGatewayIPConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ApplicationGatewayIPConfigurationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.gatewayIPConfigurations = mapped
    }

    /**
     * @param values Subnets of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("oaprsbvltcbobsvn")
    public suspend fun gatewayIPConfigurations(vararg values: ApplicationGatewayIPConfigurationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.gatewayIPConfigurations = mapped
    }

    /**
     * @param value Global Configuration.
     */
    @JvmName("eiyduqklyqgaxawh")
    public suspend fun globalConfiguration(`value`: ApplicationGatewayGlobalConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.globalConfiguration = mapped
    }

    /**
     * @param argument Global Configuration.
     */
    @JvmName("tjvubhcbmrhpntxo")
    public suspend
    fun globalConfiguration(argument: suspend ApplicationGatewayGlobalConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ApplicationGatewayGlobalConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.globalConfiguration = mapped
    }

    /**
     * @param value Http listeners of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("pmtcitrvsjpkdhlk")
    public suspend fun httpListeners(`value`: List<ApplicationGatewayHttpListenerArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpListeners = mapped
    }

    /**
     * @param argument Http listeners of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("dxdifrwqbiwjpqbl")
    public suspend
    fun httpListeners(argument: List<suspend ApplicationGatewayHttpListenerArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ApplicationGatewayHttpListenerArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.httpListeners = mapped
    }

    /**
     * @param argument Http listeners of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("hwwbnghoannjvklv")
    public suspend fun httpListeners(
        vararg
        argument: suspend ApplicationGatewayHttpListenerArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ApplicationGatewayHttpListenerArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.httpListeners = mapped
    }

    /**
     * @param argument Http listeners of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("xetktoabbojkyisd")
    public suspend
    fun httpListeners(argument: suspend ApplicationGatewayHttpListenerArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ApplicationGatewayHttpListenerArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.httpListeners = mapped
    }

    /**
     * @param values Http listeners of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("bvqelenhsyffmdji")
    public suspend fun httpListeners(vararg values: ApplicationGatewayHttpListenerArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.httpListeners = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("figyqfoirijdvkhq")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The identity of the application gateway, if configured.
     */
    @JvmName("wrpjgbqebemdfgpu")
    public suspend fun identity(`value`: ManagedServiceIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument The identity of the application gateway, if configured.
     */
    @JvmName("idtnbxcxydovayjj")
    public suspend fun identity(argument: suspend ManagedServiceIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedServiceIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value Listeners of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("xqcypfkwiwfearfo")
    public suspend fun listeners(`value`: List<ApplicationGatewayListenerArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.listeners = mapped
    }

    /**
     * @param argument Listeners of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("mdgjuhaweboxhgjr")
    public suspend
    fun listeners(argument: List<suspend ApplicationGatewayListenerArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ApplicationGatewayListenerArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.listeners = mapped
    }

    /**
     * @param argument Listeners of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("ouleensxlhciwreh")
    public suspend fun listeners(
        vararg
        argument: suspend ApplicationGatewayListenerArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ApplicationGatewayListenerArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.listeners = mapped
    }

    /**
     * @param argument Listeners of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("sqdvegajsfwwqahm")
    public suspend fun listeners(argument: suspend ApplicationGatewayListenerArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ApplicationGatewayListenerArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.listeners = mapped
    }

    /**
     * @param values Listeners of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("arpuxtpbrkkeatdf")
    public suspend fun listeners(vararg values: ApplicationGatewayListenerArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.listeners = mapped
    }

    /**
     * @param value Load distribution policies of the application gateway resource.
     */
    @JvmName("wlyykhdxpdapvotd")
    public suspend
    fun loadDistributionPolicies(`value`: List<ApplicationGatewayLoadDistributionPolicyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadDistributionPolicies = mapped
    }

    /**
     * @param argument Load distribution policies of the application gateway resource.
     */
    @JvmName("mlhuiiwkprgmjriv")
    public suspend
    fun loadDistributionPolicies(argument: List<suspend ApplicationGatewayLoadDistributionPolicyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ApplicationGatewayLoadDistributionPolicyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.loadDistributionPolicies = mapped
    }

    /**
     * @param argument Load distribution policies of the application gateway resource.
     */
    @JvmName("jjajiliophkrvodt")
    public suspend fun loadDistributionPolicies(
        vararg
        argument: suspend ApplicationGatewayLoadDistributionPolicyArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ApplicationGatewayLoadDistributionPolicyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.loadDistributionPolicies = mapped
    }

    /**
     * @param argument Load distribution policies of the application gateway resource.
     */
    @JvmName("uqhuiulxlplvctgs")
    public suspend
    fun loadDistributionPolicies(argument: suspend ApplicationGatewayLoadDistributionPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ApplicationGatewayLoadDistributionPolicyArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.loadDistributionPolicies = mapped
    }

    /**
     * @param values Load distribution policies of the application gateway resource.
     */
    @JvmName("irkaxlaqtouwmsvf")
    public suspend fun loadDistributionPolicies(
        vararg
        values: ApplicationGatewayLoadDistributionPolicyArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.loadDistributionPolicies = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("wcjxsoedbvvymqeq")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value PrivateLink configurations on application gateway.
     */
    @JvmName("trxiygwkwkecxeei")
    public suspend
    fun privateLinkConfigurations(`value`: List<ApplicationGatewayPrivateLinkConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateLinkConfigurations = mapped
    }

    /**
     * @param argument PrivateLink configurations on application gateway.
     */
    @JvmName("luwmjdlqbvqfttpi")
    public suspend
    fun privateLinkConfigurations(argument: List<suspend ApplicationGatewayPrivateLinkConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ApplicationGatewayPrivateLinkConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.privateLinkConfigurations = mapped
    }

    /**
     * @param argument PrivateLink configurations on application gateway.
     */
    @JvmName("tfvbnwhccmddaxtk")
    public suspend fun privateLinkConfigurations(
        vararg
        argument: suspend ApplicationGatewayPrivateLinkConfigurationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ApplicationGatewayPrivateLinkConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.privateLinkConfigurations = mapped
    }

    /**
     * @param argument PrivateLink configurations on application gateway.
     */
    @JvmName("cjxgcgoynjlbglkb")
    public suspend
    fun privateLinkConfigurations(argument: suspend ApplicationGatewayPrivateLinkConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ApplicationGatewayPrivateLinkConfigurationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.privateLinkConfigurations = mapped
    }

    /**
     * @param values PrivateLink configurations on application gateway.
     */
    @JvmName("lpseqwameeixdwnf")
    public suspend fun privateLinkConfigurations(
        vararg
        values: ApplicationGatewayPrivateLinkConfigurationArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateLinkConfigurations = mapped
    }

    /**
     * @param value Probes of the application gateway resource.
     */
    @JvmName("tektmturchpcjvas")
    public suspend fun probes(`value`: List<ApplicationGatewayProbeArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.probes = mapped
    }

    /**
     * @param argument Probes of the application gateway resource.
     */
    @JvmName("dtmswbqndlxrlyqf")
    public suspend fun probes(argument: List<suspend ApplicationGatewayProbeArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ApplicationGatewayProbeArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.probes = mapped
    }

    /**
     * @param argument Probes of the application gateway resource.
     */
    @JvmName("pyawkbueglaabqhb")
    public suspend fun probes(
        vararg
        argument: suspend ApplicationGatewayProbeArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ApplicationGatewayProbeArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.probes = mapped
    }

    /**
     * @param argument Probes of the application gateway resource.
     */
    @JvmName("qsnpxspkkdhbrtgy")
    public suspend fun probes(argument: suspend ApplicationGatewayProbeArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ApplicationGatewayProbeArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.probes = mapped
    }

    /**
     * @param values Probes of the application gateway resource.
     */
    @JvmName("csurpcomyguaqkox")
    public suspend fun probes(vararg values: ApplicationGatewayProbeArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.probes = mapped
    }

    /**
     * @param value Redirect configurations of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("tbfgwujlewyjumjb")
    public suspend
    fun redirectConfigurations(`value`: List<ApplicationGatewayRedirectConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.redirectConfigurations = mapped
    }

    /**
     * @param argument Redirect configurations of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("cvmucusqqjuawguo")
    public suspend
    fun redirectConfigurations(argument: List<suspend ApplicationGatewayRedirectConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ApplicationGatewayRedirectConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.redirectConfigurations = mapped
    }

    /**
     * @param argument Redirect configurations of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("slslqtrlkibpawft")
    public suspend fun redirectConfigurations(
        vararg
        argument: suspend ApplicationGatewayRedirectConfigurationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ApplicationGatewayRedirectConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.redirectConfigurations = mapped
    }

    /**
     * @param argument Redirect configurations of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("wuqvhalinwtjjvxf")
    public suspend
    fun redirectConfigurations(argument: suspend ApplicationGatewayRedirectConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ApplicationGatewayRedirectConfigurationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.redirectConfigurations = mapped
    }

    /**
     * @param values Redirect configurations of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("jgnbcvtyigxbucbk")
    public suspend fun redirectConfigurations(
        vararg
        values: ApplicationGatewayRedirectConfigurationArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.redirectConfigurations = mapped
    }

    /**
     * @param value Request routing rules of the application gateway resource.
     */
    @JvmName("hoetdafygbkvlhlb")
    public suspend fun requestRoutingRules(`value`: List<ApplicationGatewayRequestRoutingRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requestRoutingRules = mapped
    }

    /**
     * @param argument Request routing rules of the application gateway resource.
     */
    @JvmName("punvooshhwphcqag")
    public suspend
    fun requestRoutingRules(argument: List<suspend ApplicationGatewayRequestRoutingRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ApplicationGatewayRequestRoutingRuleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.requestRoutingRules = mapped
    }

    /**
     * @param argument Request routing rules of the application gateway resource.
     */
    @JvmName("hpviouckyuxwrsol")
    public suspend fun requestRoutingRules(
        vararg
        argument: suspend ApplicationGatewayRequestRoutingRuleArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ApplicationGatewayRequestRoutingRuleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.requestRoutingRules = mapped
    }

    /**
     * @param argument Request routing rules of the application gateway resource.
     */
    @JvmName("pqypdfvxnjsdwnag")
    public suspend
    fun requestRoutingRules(argument: suspend ApplicationGatewayRequestRoutingRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ApplicationGatewayRequestRoutingRuleArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.requestRoutingRules = mapped
    }

    /**
     * @param values Request routing rules of the application gateway resource.
     */
    @JvmName("mqoputmoranxaplp")
    public suspend fun requestRoutingRules(vararg values: ApplicationGatewayRequestRoutingRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.requestRoutingRules = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("ffiqfjhghukgrveu")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Rewrite rules for the application gateway resource.
     */
    @JvmName("dwnratklgjmdccds")
    public suspend fun rewriteRuleSets(`value`: List<ApplicationGatewayRewriteRuleSetArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rewriteRuleSets = mapped
    }

    /**
     * @param argument Rewrite rules for the application gateway resource.
     */
    @JvmName("kkcesotwrrqjtbbf")
    public suspend
    fun rewriteRuleSets(argument: List<suspend ApplicationGatewayRewriteRuleSetArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ApplicationGatewayRewriteRuleSetArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.rewriteRuleSets = mapped
    }

    /**
     * @param argument Rewrite rules for the application gateway resource.
     */
    @JvmName("hnkqclbfmyjkymft")
    public suspend fun rewriteRuleSets(
        vararg
        argument: suspend ApplicationGatewayRewriteRuleSetArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ApplicationGatewayRewriteRuleSetArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.rewriteRuleSets = mapped
    }

    /**
     * @param argument Rewrite rules for the application gateway resource.
     */
    @JvmName("ngendijydsmdntrq")
    public suspend
    fun rewriteRuleSets(argument: suspend ApplicationGatewayRewriteRuleSetArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ApplicationGatewayRewriteRuleSetArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.rewriteRuleSets = mapped
    }

    /**
     * @param values Rewrite rules for the application gateway resource.
     */
    @JvmName("kpeffdxloimhacex")
    public suspend fun rewriteRuleSets(vararg values: ApplicationGatewayRewriteRuleSetArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rewriteRuleSets = mapped
    }

    /**
     * @param value Routing rules of the application gateway resource.
     */
    @JvmName("hxgdcbuskumooemc")
    public suspend fun routingRules(`value`: List<ApplicationGatewayRoutingRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routingRules = mapped
    }

    /**
     * @param argument Routing rules of the application gateway resource.
     */
    @JvmName("bdbrtlxsclkgalju")
    public suspend
    fun routingRules(argument: List<suspend ApplicationGatewayRoutingRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ApplicationGatewayRoutingRuleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.routingRules = mapped
    }

    /**
     * @param argument Routing rules of the application gateway resource.
     */
    @JvmName("wvouheinvrygtcrr")
    public suspend fun routingRules(
        vararg
        argument: suspend ApplicationGatewayRoutingRuleArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ApplicationGatewayRoutingRuleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.routingRules = mapped
    }

    /**
     * @param argument Routing rules of the application gateway resource.
     */
    @JvmName("srmuahxhdwagrryi")
    public suspend
    fun routingRules(argument: suspend ApplicationGatewayRoutingRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ApplicationGatewayRoutingRuleArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.routingRules = mapped
    }

    /**
     * @param values Routing rules of the application gateway resource.
     */
    @JvmName("parkhgmugbidlnvd")
    public suspend fun routingRules(vararg values: ApplicationGatewayRoutingRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.routingRules = mapped
    }

    /**
     * @param value SKU of the application gateway resource.
     */
    @JvmName("gbkjdllgmjondpga")
    public suspend fun sku(`value`: ApplicationGatewaySkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument SKU of the application gateway resource.
     */
    @JvmName("ibqpnoovopchqywl")
    public suspend fun sku(argument: suspend ApplicationGatewaySkuArgsBuilder.() -> Unit) {
        val toBeMapped = ApplicationGatewaySkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value SSL certificates of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("cgmjqdbjwbdlpvcu")
    public suspend fun sslCertificates(`value`: List<ApplicationGatewaySslCertificateArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sslCertificates = mapped
    }

    /**
     * @param argument SSL certificates of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("uujicikubepjqcyr")
    public suspend
    fun sslCertificates(argument: List<suspend ApplicationGatewaySslCertificateArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ApplicationGatewaySslCertificateArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.sslCertificates = mapped
    }

    /**
     * @param argument SSL certificates of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("twhnyuptoqsobgtu")
    public suspend fun sslCertificates(
        vararg
        argument: suspend ApplicationGatewaySslCertificateArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ApplicationGatewaySslCertificateArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.sslCertificates = mapped
    }

    /**
     * @param argument SSL certificates of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("ucyubgpabqekjepq")
    public suspend
    fun sslCertificates(argument: suspend ApplicationGatewaySslCertificateArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ApplicationGatewaySslCertificateArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.sslCertificates = mapped
    }

    /**
     * @param values SSL certificates of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("hgmkrksiwobitkkf")
    public suspend fun sslCertificates(vararg values: ApplicationGatewaySslCertificateArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sslCertificates = mapped
    }

    /**
     * @param value SSL policy of the application gateway resource.
     */
    @JvmName("scmflsvlbsqvvehf")
    public suspend fun sslPolicy(`value`: ApplicationGatewaySslPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sslPolicy = mapped
    }

    /**
     * @param argument SSL policy of the application gateway resource.
     */
    @JvmName("uayssjxranftpgms")
    public suspend
    fun sslPolicy(argument: suspend ApplicationGatewaySslPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = ApplicationGatewaySslPolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sslPolicy = mapped
    }

    /**
     * @param value SSL profiles of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("flpkaufqqkupginj")
    public suspend fun sslProfiles(`value`: List<ApplicationGatewaySslProfileArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sslProfiles = mapped
    }

    /**
     * @param argument SSL profiles of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("tsxbxfgwcljjvxnm")
    public suspend
    fun sslProfiles(argument: List<suspend ApplicationGatewaySslProfileArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ApplicationGatewaySslProfileArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.sslProfiles = mapped
    }

    /**
     * @param argument SSL profiles of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("brmsjlmgowsqffut")
    public suspend fun sslProfiles(
        vararg
        argument: suspend ApplicationGatewaySslProfileArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ApplicationGatewaySslProfileArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.sslProfiles = mapped
    }

    /**
     * @param argument SSL profiles of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("bsdhnqxixjkviaqe")
    public suspend
    fun sslProfiles(argument: suspend ApplicationGatewaySslProfileArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ApplicationGatewaySslProfileArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.sslProfiles = mapped
    }

    /**
     * @param values SSL profiles of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("rrujkwojmyyrcwng")
    public suspend fun sslProfiles(vararg values: ApplicationGatewaySslProfileArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sslProfiles = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("wjvywjyamxjkwwfe")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("joxvqidhsqnsvdep")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Trusted client certificates of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("qaagxdhrafhokweh")
    public suspend
    fun trustedClientCertificates(`value`: List<ApplicationGatewayTrustedClientCertificateArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trustedClientCertificates = mapped
    }

    /**
     * @param argument Trusted client certificates of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("uijaolfiklurxjer")
    public suspend
    fun trustedClientCertificates(argument: List<suspend ApplicationGatewayTrustedClientCertificateArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ApplicationGatewayTrustedClientCertificateArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.trustedClientCertificates = mapped
    }

    /**
     * @param argument Trusted client certificates of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("tomjpfneopdrttou")
    public suspend fun trustedClientCertificates(
        vararg
        argument: suspend ApplicationGatewayTrustedClientCertificateArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ApplicationGatewayTrustedClientCertificateArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.trustedClientCertificates = mapped
    }

    /**
     * @param argument Trusted client certificates of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("bybejranvnetlcjq")
    public suspend
    fun trustedClientCertificates(argument: suspend ApplicationGatewayTrustedClientCertificateArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ApplicationGatewayTrustedClientCertificateArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.trustedClientCertificates = mapped
    }

    /**
     * @param values Trusted client certificates of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("uipugysmofivqyog")
    public suspend fun trustedClientCertificates(
        vararg
        values: ApplicationGatewayTrustedClientCertificateArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.trustedClientCertificates = mapped
    }

    /**
     * @param value Trusted Root certificates of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("wbaeimcxwklmxucq")
    public suspend
    fun trustedRootCertificates(`value`: List<ApplicationGatewayTrustedRootCertificateArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trustedRootCertificates = mapped
    }

    /**
     * @param argument Trusted Root certificates of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("xfvriglpakorawkf")
    public suspend
    fun trustedRootCertificates(argument: List<suspend ApplicationGatewayTrustedRootCertificateArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ApplicationGatewayTrustedRootCertificateArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.trustedRootCertificates = mapped
    }

    /**
     * @param argument Trusted Root certificates of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("oqchlvphorsnnivk")
    public suspend fun trustedRootCertificates(
        vararg
        argument: suspend ApplicationGatewayTrustedRootCertificateArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ApplicationGatewayTrustedRootCertificateArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.trustedRootCertificates = mapped
    }

    /**
     * @param argument Trusted Root certificates of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("gfylywdbqrlojscl")
    public suspend
    fun trustedRootCertificates(argument: suspend ApplicationGatewayTrustedRootCertificateArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ApplicationGatewayTrustedRootCertificateArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.trustedRootCertificates = mapped
    }

    /**
     * @param values Trusted Root certificates of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("tbvvffwgjjavgafj")
    public suspend fun trustedRootCertificates(
        vararg
        values: ApplicationGatewayTrustedRootCertificateArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.trustedRootCertificates = mapped
    }

    /**
     * @param value URL path map of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("pfvouritcfofqlja")
    public suspend fun urlPathMaps(`value`: List<ApplicationGatewayUrlPathMapArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.urlPathMaps = mapped
    }

    /**
     * @param argument URL path map of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("lsgpkhypfqrcbvdd")
    public suspend
    fun urlPathMaps(argument: List<suspend ApplicationGatewayUrlPathMapArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ApplicationGatewayUrlPathMapArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.urlPathMaps = mapped
    }

    /**
     * @param argument URL path map of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("sdploqdvvewriiae")
    public suspend fun urlPathMaps(
        vararg
        argument: suspend ApplicationGatewayUrlPathMapArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ApplicationGatewayUrlPathMapArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.urlPathMaps = mapped
    }

    /**
     * @param argument URL path map of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("iwyvfdmckfedecas")
    public suspend
    fun urlPathMaps(argument: suspend ApplicationGatewayUrlPathMapArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ApplicationGatewayUrlPathMapArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.urlPathMaps = mapped
    }

    /**
     * @param values URL path map of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    @JvmName("dgjrtksatouppvwj")
    public suspend fun urlPathMaps(vararg values: ApplicationGatewayUrlPathMapArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.urlPathMaps = mapped
    }

    /**
     * @param value Web application firewall configuration.
     */
    @JvmName("mhcbeuwlyinsnjfl")
    public suspend
    fun webApplicationFirewallConfiguration(`value`: ApplicationGatewayWebApplicationFirewallConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.webApplicationFirewallConfiguration = mapped
    }

    /**
     * @param argument Web application firewall configuration.
     */
    @JvmName("wvkqhmoxnriieeaf")
    public suspend
    fun webApplicationFirewallConfiguration(argument: suspend ApplicationGatewayWebApplicationFirewallConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            ApplicationGatewayWebApplicationFirewallConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.webApplicationFirewallConfiguration = mapped
    }

    /**
     * @param value A list of availability zones denoting where the resource needs to come from.
     */
    @JvmName("yeatycftnpfsisvx")
    public suspend fun zones(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zones = mapped
    }

    /**
     * @param values A list of availability zones denoting where the resource needs to come from.
     */
    @JvmName("dptwcqwsxqywqtnx")
    public suspend fun zones(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.zones = mapped
    }

    internal fun build(): ApplicationGatewayArgs = ApplicationGatewayArgs(
        applicationGatewayName = applicationGatewayName,
        authenticationCertificates = authenticationCertificates,
        autoscaleConfiguration = autoscaleConfiguration,
        backendAddressPools = backendAddressPools,
        backendHttpSettingsCollection = backendHttpSettingsCollection,
        backendSettingsCollection = backendSettingsCollection,
        customErrorConfigurations = customErrorConfigurations,
        enableFips = enableFips,
        enableHttp2 = enableHttp2,
        firewallPolicy = firewallPolicy,
        forceFirewallPolicyAssociation = forceFirewallPolicyAssociation,
        frontendIPConfigurations = frontendIPConfigurations,
        frontendPorts = frontendPorts,
        gatewayIPConfigurations = gatewayIPConfigurations,
        globalConfiguration = globalConfiguration,
        httpListeners = httpListeners,
        id = id,
        identity = identity,
        listeners = listeners,
        loadDistributionPolicies = loadDistributionPolicies,
        location = location,
        privateLinkConfigurations = privateLinkConfigurations,
        probes = probes,
        redirectConfigurations = redirectConfigurations,
        requestRoutingRules = requestRoutingRules,
        resourceGroupName = resourceGroupName,
        rewriteRuleSets = rewriteRuleSets,
        routingRules = routingRules,
        sku = sku,
        sslCertificates = sslCertificates,
        sslPolicy = sslPolicy,
        sslProfiles = sslProfiles,
        tags = tags,
        trustedClientCertificates = trustedClientCertificates,
        trustedRootCertificates = trustedRootCertificates,
        urlPathMaps = urlPathMaps,
        webApplicationFirewallConfiguration = webApplicationFirewallConfiguration,
        zones = zones,
    )
}
