@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.BastionHostArgs.builder
import com.pulumi.azurenative.network.kotlin.inputs.BastionHostIPConfigurationArgs
import com.pulumi.azurenative.network.kotlin.inputs.BastionHostIPConfigurationArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.SkuArgs
import com.pulumi.azurenative.network.kotlin.inputs.SkuArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Bastion Host resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2023-04-01, 2023-05-01, 2023-06-01.
 * ## Example Usage
 * ### Create Bastion Host
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var bastionHost = new AzureNative.Network.BastionHost("bastionHost", new()
 *     {
 *         BastionHostName = "bastionhosttenant",
 *         IpConfigurations = new[]
 *         {
 *             new AzureNative.Network.Inputs.BastionHostIPConfigurationArgs
 *             {
 *                 Name = "bastionHostIpConfiguration",
 *                 PublicIPAddress = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/pipName",
 *                 },
 *                 Subnet = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet2/subnets/BastionHostSubnet",
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewBastionHost(ctx, "bastionHost", &network.BastionHostArgs{
 * 			BastionHostName: pulumi.String("bastionhosttenant"),
 * 			IpConfigurations: []network.BastionHostIPConfigurationArgs{
 * 				{
 * 					Name: pulumi.String("bastionHostIpConfiguration"),
 * 					PublicIPAddress: {
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/pipName"),
 * 					},
 * 					Subnet: {
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet2/subnets/BastionHostSubnet"),
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.BastionHost;
 * import com.pulumi.azurenative.network.BastionHostArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var bastionHost = new BastionHost("bastionHost", BastionHostArgs.builder()
 *             .bastionHostName("bastionhosttenant")
 *             .ipConfigurations(Map.ofEntries(
 *                 Map.entry("name", "bastionHostIpConfiguration"),
 *                 Map.entry("publicIPAddress", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/pipName")),
 *                 Map.entry("subnet", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet2/subnets/BastionHostSubnet"))
 *             ))
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:BastionHost bastionhost /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/bastionHosts/{bastionHostName}
 * ```
 * @property bastionHostName The name of the Bastion Host.
 * @property disableCopyPaste Enable/Disable Copy/Paste feature of the Bastion Host resource.
 * @property dnsName FQDN for the endpoint on which bastion host is accessible.
 * @property enableFileCopy Enable/Disable File Copy feature of the Bastion Host resource.
 * @property enableIpConnect Enable/Disable IP Connect feature of the Bastion Host resource.
 * @property enableKerberos Enable/Disable Kerberos feature of the Bastion Host resource.
 * @property enableShareableLink Enable/Disable Shareable Link of the Bastion Host resource.
 * @property enableTunneling Enable/Disable Tunneling feature of the Bastion Host resource.
 * @property id Resource ID.
 * @property ipConfigurations IP configuration of the Bastion Host resource.
 * @property location Resource location.
 * @property resourceGroupName The name of the resource group.
 * @property scaleUnits The scale units for the Bastion Host resource.
 * @property sku The sku of this Bastion Host.
 * @property tags Resource tags.
 */
public data class BastionHostArgs(
    public val bastionHostName: Output<String>? = null,
    public val disableCopyPaste: Output<Boolean>? = null,
    public val dnsName: Output<String>? = null,
    public val enableFileCopy: Output<Boolean>? = null,
    public val enableIpConnect: Output<Boolean>? = null,
    public val enableKerberos: Output<Boolean>? = null,
    public val enableShareableLink: Output<Boolean>? = null,
    public val enableTunneling: Output<Boolean>? = null,
    public val id: Output<String>? = null,
    public val ipConfigurations: Output<List<BastionHostIPConfigurationArgs>>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val scaleUnits: Output<Int>? = null,
    public val sku: Output<SkuArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.BastionHostArgs> {
    override fun toJava(): com.pulumi.azurenative.network.BastionHostArgs =
        com.pulumi.azurenative.network.BastionHostArgs.builder()
            .bastionHostName(bastionHostName?.applyValue({ args0 -> args0 }))
            .disableCopyPaste(disableCopyPaste?.applyValue({ args0 -> args0 }))
            .dnsName(dnsName?.applyValue({ args0 -> args0 }))
            .enableFileCopy(enableFileCopy?.applyValue({ args0 -> args0 }))
            .enableIpConnect(enableIpConnect?.applyValue({ args0 -> args0 }))
            .enableKerberos(enableKerberos?.applyValue({ args0 -> args0 }))
            .enableShareableLink(enableShareableLink?.applyValue({ args0 -> args0 }))
            .enableTunneling(enableTunneling?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .ipConfigurations(
                ipConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .scaleUnits(scaleUnits?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [BastionHostArgs].
 */
@PulumiTagMarker
public class BastionHostArgsBuilder internal constructor() {
    private var bastionHostName: Output<String>? = null

    private var disableCopyPaste: Output<Boolean>? = null

    private var dnsName: Output<String>? = null

    private var enableFileCopy: Output<Boolean>? = null

    private var enableIpConnect: Output<Boolean>? = null

    private var enableKerberos: Output<Boolean>? = null

    private var enableShareableLink: Output<Boolean>? = null

    private var enableTunneling: Output<Boolean>? = null

    private var id: Output<String>? = null

    private var ipConfigurations: Output<List<BastionHostIPConfigurationArgs>>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var scaleUnits: Output<Int>? = null

    private var sku: Output<SkuArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of the Bastion Host.
     */
    @JvmName("qbvlejgdinpgdjyb")
    public suspend fun bastionHostName(`value`: Output<String>) {
        this.bastionHostName = value
    }

    /**
     * @param value Enable/Disable Copy/Paste feature of the Bastion Host resource.
     */
    @JvmName("sysjgfbtxblfbarf")
    public suspend fun disableCopyPaste(`value`: Output<Boolean>) {
        this.disableCopyPaste = value
    }

    /**
     * @param value FQDN for the endpoint on which bastion host is accessible.
     */
    @JvmName("hudrbnqriclgqdas")
    public suspend fun dnsName(`value`: Output<String>) {
        this.dnsName = value
    }

    /**
     * @param value Enable/Disable File Copy feature of the Bastion Host resource.
     */
    @JvmName("rhmcdayieiwwwglk")
    public suspend fun enableFileCopy(`value`: Output<Boolean>) {
        this.enableFileCopy = value
    }

    /**
     * @param value Enable/Disable IP Connect feature of the Bastion Host resource.
     */
    @JvmName("ctuyiwehihwlqump")
    public suspend fun enableIpConnect(`value`: Output<Boolean>) {
        this.enableIpConnect = value
    }

    /**
     * @param value Enable/Disable Kerberos feature of the Bastion Host resource.
     */
    @JvmName("tkewxwbycjqrxcdk")
    public suspend fun enableKerberos(`value`: Output<Boolean>) {
        this.enableKerberos = value
    }

    /**
     * @param value Enable/Disable Shareable Link of the Bastion Host resource.
     */
    @JvmName("cysxgsdqthsomyhs")
    public suspend fun enableShareableLink(`value`: Output<Boolean>) {
        this.enableShareableLink = value
    }

    /**
     * @param value Enable/Disable Tunneling feature of the Bastion Host resource.
     */
    @JvmName("gqsbxpyjmntvcybs")
    public suspend fun enableTunneling(`value`: Output<Boolean>) {
        this.enableTunneling = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("vmgqgkckfaddnyve")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value IP configuration of the Bastion Host resource.
     */
    @JvmName("qpsjekognluslpxx")
    public suspend fun ipConfigurations(`value`: Output<List<BastionHostIPConfigurationArgs>>) {
        this.ipConfigurations = value
    }

    @JvmName("antiixeyfthermly")
    public suspend fun ipConfigurations(vararg values: Output<BastionHostIPConfigurationArgs>) {
        this.ipConfigurations = Output.all(values.asList())
    }

    /**
     * @param values IP configuration of the Bastion Host resource.
     */
    @JvmName("nvvshqtoitibbwjh")
    public suspend fun ipConfigurations(values: List<Output<BastionHostIPConfigurationArgs>>) {
        this.ipConfigurations = Output.all(values)
    }

    /**
     * @param value Resource location.
     */
    @JvmName("pjloejgsmmnftexx")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("hafeielkoaummlti")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The scale units for the Bastion Host resource.
     */
    @JvmName("komlxsvkskuivjhe")
    public suspend fun scaleUnits(`value`: Output<Int>) {
        this.scaleUnits = value
    }

    /**
     * @param value The sku of this Bastion Host.
     */
    @JvmName("jhocyughkqcjcrlg")
    public suspend fun sku(`value`: Output<SkuArgs>) {
        this.sku = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("nosvodhxyyvcyfsu")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the Bastion Host.
     */
    @JvmName("npmtvmgyrnklllmb")
    public suspend fun bastionHostName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bastionHostName = mapped
    }

    /**
     * @param value Enable/Disable Copy/Paste feature of the Bastion Host resource.
     */
    @JvmName("sqcvjsdludcixatf")
    public suspend fun disableCopyPaste(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableCopyPaste = mapped
    }

    /**
     * @param value FQDN for the endpoint on which bastion host is accessible.
     */
    @JvmName("idleepujpkhjtnqo")
    public suspend fun dnsName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dnsName = mapped
    }

    /**
     * @param value Enable/Disable File Copy feature of the Bastion Host resource.
     */
    @JvmName("ltvjwysaddooagaq")
    public suspend fun enableFileCopy(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableFileCopy = mapped
    }

    /**
     * @param value Enable/Disable IP Connect feature of the Bastion Host resource.
     */
    @JvmName("itftnprmafwgtakk")
    public suspend fun enableIpConnect(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableIpConnect = mapped
    }

    /**
     * @param value Enable/Disable Kerberos feature of the Bastion Host resource.
     */
    @JvmName("txoyudjyyrpslyfo")
    public suspend fun enableKerberos(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableKerberos = mapped
    }

    /**
     * @param value Enable/Disable Shareable Link of the Bastion Host resource.
     */
    @JvmName("shbjkljisnrgbing")
    public suspend fun enableShareableLink(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableShareableLink = mapped
    }

    /**
     * @param value Enable/Disable Tunneling feature of the Bastion Host resource.
     */
    @JvmName("voarcmgpfynkhdku")
    public suspend fun enableTunneling(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableTunneling = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("frnrtxrxwujinmwh")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value IP configuration of the Bastion Host resource.
     */
    @JvmName("fvqkfrdenkyxccaf")
    public suspend fun ipConfigurations(`value`: List<BastionHostIPConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipConfigurations = mapped
    }

    /**
     * @param argument IP configuration of the Bastion Host resource.
     */
    @JvmName("ijhvvuvafkctxbja")
    public suspend
    fun ipConfigurations(argument: List<suspend BastionHostIPConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            BastionHostIPConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ipConfigurations = mapped
    }

    /**
     * @param argument IP configuration of the Bastion Host resource.
     */
    @JvmName("ucagekvqbsaxyvtg")
    public suspend fun ipConfigurations(
        vararg
        argument: suspend BastionHostIPConfigurationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            BastionHostIPConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ipConfigurations = mapped
    }

    /**
     * @param argument IP configuration of the Bastion Host resource.
     */
    @JvmName("hbugpshfnsyutyuv")
    public suspend
    fun ipConfigurations(argument: suspend BastionHostIPConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            BastionHostIPConfigurationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.ipConfigurations = mapped
    }

    /**
     * @param values IP configuration of the Bastion Host resource.
     */
    @JvmName("fmsrhjjutbnnjcgw")
    public suspend fun ipConfigurations(vararg values: BastionHostIPConfigurationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipConfigurations = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("ukegxcohfumwjxci")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("wuafaksgjgdkasru")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The scale units for the Bastion Host resource.
     */
    @JvmName("ptmbdmvumwimpieo")
    public suspend fun scaleUnits(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scaleUnits = mapped
    }

    /**
     * @param value The sku of this Bastion Host.
     */
    @JvmName("endmcgggeycfibfo")
    public suspend fun sku(`value`: SkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument The sku of this Bastion Host.
     */
    @JvmName("hpobddaloaxipeut")
    public suspend fun sku(argument: suspend SkuArgsBuilder.() -> Unit) {
        val toBeMapped = SkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("tqcbahjjspwflefs")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("llwinqfcyksgumyb")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): BastionHostArgs = BastionHostArgs(
        bastionHostName = bastionHostName,
        disableCopyPaste = disableCopyPaste,
        dnsName = dnsName,
        enableFileCopy = enableFileCopy,
        enableIpConnect = enableIpConnect,
        enableKerberos = enableKerberos,
        enableShareableLink = enableShareableLink,
        enableTunneling = enableTunneling,
        id = id,
        ipConfigurations = ipConfigurations,
        location = location,
        resourceGroupName = resourceGroupName,
        scaleUnits = scaleUnits,
        sku = sku,
        tags = tags,
    )
}
