@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse
import com.pulumi.azurenative.network.kotlin.outputs.VpnServerConfigurationPolicyGroupMemberResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin as subResourceResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.VpnServerConfigurationPolicyGroupMemberResponse.Companion.toKotlin as vpnServerConfigurationPolicyGroupMemberResponseToKotlin

/**
 * Builder for [ConfigurationPolicyGroup].
 */
@PulumiTagMarker
public class ConfigurationPolicyGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ConfigurationPolicyGroupArgs = ConfigurationPolicyGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ConfigurationPolicyGroupArgsBuilder.() -> Unit) {
        val builder = ConfigurationPolicyGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ConfigurationPolicyGroup {
        val builtJavaResource =
            com.pulumi.azurenative.network.ConfigurationPolicyGroup(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ConfigurationPolicyGroup(builtJavaResource)
    }
}

/**
 * VpnServerConfigurationPolicyGroup Resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2022-01-01.
 * Other available API versions: 2023-04-01, 2023-05-01, 2023-06-01.
 * ## Example Usage
 * ### ConfigurationPolicyGroupPut
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var configurationPolicyGroup = new AzureNative.Network.ConfigurationPolicyGroup("configurationPolicyGroup", new()
 *     {
 *         ConfigurationPolicyGroupName = "policyGroup1",
 *         IsDefault = true,
 *         PolicyMembers = new[]
 *         {
 *             new AzureNative.Network.Inputs.VpnServerConfigurationPolicyGroupMemberArgs
 *             {
 *                 AttributeType = "RadiusAzureGroupId",
 *                 AttributeValue = "6ad1bd08",
 *                 Name = "policy1",
 *             },
 *             new AzureNative.Network.Inputs.VpnServerConfigurationPolicyGroupMemberArgs
 *             {
 *                 AttributeType = "CertificateGroupId",
 *                 AttributeValue = "red.com",
 *                 Name = "policy2",
 *             },
 *         },
 *         Priority = 0,
 *         ResourceGroupName = "rg1",
 *         VpnServerConfigurationName = "vpnServerConfiguration1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewConfigurationPolicyGroup(ctx, "configurationPolicyGroup", &network.ConfigurationPolicyGroupArgs{
 * 			ConfigurationPolicyGroupName: pulumi.String("policyGroup1"),
 * 			IsDefault:                    pulumi.Bool(true),
 * 			PolicyMembers: []network.VpnServerConfigurationPolicyGroupMemberArgs{
 * 				{
 * 					AttributeType:  pulumi.String("RadiusAzureGroupId"),
 * 					AttributeValue: pulumi.String("6ad1bd08"),
 * 					Name:           pulumi.String("policy1"),
 * 				},
 * 				{
 * 					AttributeType:  pulumi.String("CertificateGroupId"),
 * 					AttributeValue: pulumi.String("red.com"),
 * 					Name:           pulumi.String("policy2"),
 * 				},
 * 			},
 * 			Priority:                   pulumi.Int(0),
 * 			ResourceGroupName:          pulumi.String("rg1"),
 * 			VpnServerConfigurationName: pulumi.String("vpnServerConfiguration1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.ConfigurationPolicyGroup;
 * import com.pulumi.azurenative.network.ConfigurationPolicyGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var configurationPolicyGroup = new ConfigurationPolicyGroup("configurationPolicyGroup", ConfigurationPolicyGroupArgs.builder()
 *             .configurationPolicyGroupName("policyGroup1")
 *             .isDefault(true)
 *             .policyMembers(
 *                 Map.ofEntries(
 *                     Map.entry("attributeType", "RadiusAzureGroupId"),
 *                     Map.entry("attributeValue", "6ad1bd08"),
 *                     Map.entry("name", "policy1")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("attributeType", "CertificateGroupId"),
 *                     Map.entry("attributeValue", "red.com"),
 *                     Map.entry("name", "policy2")
 *                 ))
 *             .priority(0)
 *             .resourceGroupName("rg1")
 *             .vpnServerConfigurationName("vpnServerConfiguration1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:ConfigurationPolicyGroup policyGroup1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/vpnServerConfigurations/{vpnServerConfigurationName}/configurationPolicyGroups/{configurationPolicyGroupName}
 * ```
 */
public class ConfigurationPolicyGroup internal constructor(
    override val javaResource: com.pulumi.azurenative.network.ConfigurationPolicyGroup,
) : KotlinCustomResource(javaResource, ConfigurationPolicyGroupMapper) {
    /**
     * A unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * Shows if this is a Default VpnServerConfigurationPolicyGroup or not.
     */
    public val isDefault: Output<Boolean>?
        get() = javaResource.isDefault().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    public val name: Output<String>?
        get() = javaResource.name().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * List of references to P2SConnectionConfigurations.
     */
    public val p2SConnectionConfigurations: Output<List<SubResourceResponse>>
        get() = javaResource.p2SConnectionConfigurations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> subResourceResponseToKotlin(args0) })
            })
        })

    /**
     * Multiple PolicyMembers for VpnServerConfigurationPolicyGroup.
     */
    public val policyMembers: Output<List<VpnServerConfigurationPolicyGroupMemberResponse>>?
        get() = javaResource.policyMembers().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        vpnServerConfigurationPolicyGroupMemberResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Priority for VpnServerConfigurationPolicyGroup.
     */
    public val priority: Output<Int>?
        get() = javaResource.priority().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The provisioning state of the VpnServerConfigurationPolicyGroup resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ConfigurationPolicyGroupMapper : ResourceMapper<ConfigurationPolicyGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.ConfigurationPolicyGroup::class == javaResource::class

    override fun map(javaResource: Resource): ConfigurationPolicyGroup =
        ConfigurationPolicyGroup(
            javaResource as
                com.pulumi.azurenative.network.ConfigurationPolicyGroup,
        )
}

/**
 * @see [ConfigurationPolicyGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ConfigurationPolicyGroup].
 */
public suspend fun configurationPolicyGroup(
    name: String,
    block: suspend ConfigurationPolicyGroupResourceBuilder.() -> Unit,
): ConfigurationPolicyGroup {
    val builder = ConfigurationPolicyGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ConfigurationPolicyGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun configurationPolicyGroup(name: String): ConfigurationPolicyGroup {
    val builder = ConfigurationPolicyGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
