@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.kotlin.outputs.ConnectivityGroupItemResponse
import com.pulumi.azurenative.network.kotlin.outputs.HubResponse
import com.pulumi.azurenative.network.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.network.kotlin.outputs.ConnectivityGroupItemResponse.Companion.toKotlin as connectivityGroupItemResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.HubResponse.Companion.toKotlin as hubResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [ConnectivityConfiguration].
 */
@PulumiTagMarker
public class ConnectivityConfigurationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ConnectivityConfigurationArgs = ConnectivityConfigurationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ConnectivityConfigurationArgsBuilder.() -> Unit) {
        val builder = ConnectivityConfigurationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ConnectivityConfiguration {
        val builtJavaResource =
            com.pulumi.azurenative.network.ConnectivityConfiguration(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ConnectivityConfiguration(builtJavaResource)
    }
}

/**
 * The network manager connectivity configuration resource
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2021-02-01-preview.
 * Other available API versions: 2021-02-01-preview, 2021-05-01-preview, 2023-04-01, 2023-05-01, 2023-06-01.
 * ## Example Usage
 * ### ConnectivityConfigurationsPut
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var connectivityConfiguration = new AzureNative.Network.ConnectivityConfiguration("connectivityConfiguration", new()
 *     {
 *         AppliesToGroups = new[]
 *         {
 *             new AzureNative.Network.Inputs.ConnectivityGroupItemArgs
 *             {
 *                 GroupConnectivity = "None",
 *                 IsGlobal = "False",
 *                 NetworkGroupId = "subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkManagers/testNetworkManager/networkGroups/group1",
 *                 UseHubGateway = "True",
 *             },
 *         },
 *         ConfigurationName = "myTestConnectivityConfig",
 *         ConnectivityTopology = "HubAndSpoke",
 *         DeleteExistingPeering = "True",
 *         Description = "Sample Configuration",
 *         Hubs = new[]
 *         {
 *             new AzureNative.Network.Inputs.HubArgs
 *             {
 *                 ResourceId = "subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/myTestConnectivityConfig",
 *                 ResourceType = "Microsoft.Network/virtualNetworks",
 *             },
 *         },
 *         IsGlobal = "True",
 *         NetworkManagerName = "testNetworkManager",
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewConnectivityConfiguration(ctx, "connectivityConfiguration", &network.ConnectivityConfigurationArgs{
 * 			AppliesToGroups: []network.ConnectivityGroupItemArgs{
 * 				{
 * 					GroupConnectivity: pulumi.String("None"),
 * 					IsGlobal:          pulumi.String("False"),
 * 					NetworkGroupId:    pulumi.String("subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkManagers/testNetworkManager/networkGroups/group1"),
 * 					UseHubGateway:     pulumi.String("True"),
 * 				},
 * 			},
 * 			ConfigurationName:     pulumi.String("myTestConnectivityConfig"),
 * 			ConnectivityTopology:  pulumi.String("HubAndSpoke"),
 * 			DeleteExistingPeering: pulumi.String("True"),
 * 			Description:           pulumi.String("Sample Configuration"),
 * 			Hubs: []network.HubArgs{
 * 				{
 * 					ResourceId:   pulumi.String("subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/myTestConnectivityConfig"),
 * 					ResourceType: pulumi.String("Microsoft.Network/virtualNetworks"),
 * 				},
 * 			},
 * 			IsGlobal:           pulumi.String("True"),
 * 			NetworkManagerName: pulumi.String("testNetworkManager"),
 * 			ResourceGroupName:  pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.ConnectivityConfiguration;
 * import com.pulumi.azurenative.network.ConnectivityConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var connectivityConfiguration = new ConnectivityConfiguration("connectivityConfiguration", ConnectivityConfigurationArgs.builder()
 *             .appliesToGroups(Map.ofEntries(
 *                 Map.entry("groupConnectivity", "None"),
 *                 Map.entry("isGlobal", "False"),
 *                 Map.entry("networkGroupId", "subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkManagers/testNetworkManager/networkGroups/group1"),
 *                 Map.entry("useHubGateway", "True")
 *             ))
 *             .configurationName("myTestConnectivityConfig")
 *             .connectivityTopology("HubAndSpoke")
 *             .deleteExistingPeering("True")
 *             .description("Sample Configuration")
 *             .hubs(Map.ofEntries(
 *                 Map.entry("resourceId", "subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/myTestConnectivityConfig"),
 *                 Map.entry("resourceType", "Microsoft.Network/virtualNetworks")
 *             ))
 *             .isGlobal("True")
 *             .networkManagerName("testNetworkManager")
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:ConnectivityConfiguration myTestConnectivityConfig /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkManagers/{networkManagerName}/connectivityConfigurations/{configurationName}
 * ```
 */
public class ConnectivityConfiguration internal constructor(
    override val javaResource: com.pulumi.azurenative.network.ConnectivityConfiguration,
) : KotlinCustomResource(javaResource, ConnectivityConfigurationMapper) {
    /**
     * Groups for configuration
     */
    public val appliesToGroups: Output<List<ConnectivityGroupItemResponse>>
        get() = javaResource.appliesToGroups().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> connectivityGroupItemResponseToKotlin(args0) })
            })
        })

    /**
     * Connectivity topology type.
     */
    public val connectivityTopology: Output<String>
        get() = javaResource.connectivityTopology().applyValue({ args0 -> args0 })

    /**
     * Flag if need to remove current existing peerings.
     */
    public val deleteExistingPeering: Output<String>?
        get() = javaResource.deleteExistingPeering().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A description of the connectivity configuration.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * List of hubItems
     */
    public val hubs: Output<List<HubResponse>>?
        get() = javaResource.hubs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> hubResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * Flag if global mesh is supported.
     */
    public val isGlobal: Output<String>?
        get() = javaResource.isGlobal().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioning state of the connectivity configuration resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Unique identifier for this resource.
     */
    public val resourceGuid: Output<String>
        get() = javaResource.resourceGuid().applyValue({ args0 -> args0 })

    /**
     * The system metadata related to this resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ConnectivityConfigurationMapper : ResourceMapper<ConnectivityConfiguration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.ConnectivityConfiguration::class == javaResource::class

    override fun map(javaResource: Resource): ConnectivityConfiguration =
        ConnectivityConfiguration(
            javaResource as
                com.pulumi.azurenative.network.ConnectivityConfiguration,
        )
}

/**
 * @see [ConnectivityConfiguration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ConnectivityConfiguration].
 */
public suspend fun connectivityConfiguration(
    name: String,
    block: suspend ConnectivityConfigurationResourceBuilder.() -> Unit,
): ConnectivityConfiguration {
    val builder = ConnectivityConfigurationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ConnectivityConfiguration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun connectivityConfiguration(name: String): ConnectivityConfiguration {
    val builder = ConnectivityConfigurationResourceBuilder()
    builder.name(name)
    return builder.build()
}
