@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.ConnectivityConfigurationArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.ConnectivityTopology
import com.pulumi.azurenative.network.kotlin.enums.DeleteExistingPeering
import com.pulumi.azurenative.network.kotlin.enums.IsGlobal
import com.pulumi.azurenative.network.kotlin.inputs.ConnectivityGroupItemArgs
import com.pulumi.azurenative.network.kotlin.inputs.ConnectivityGroupItemArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.HubArgs
import com.pulumi.azurenative.network.kotlin.inputs.HubArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The network manager connectivity configuration resource
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2021-02-01-preview.
 * Other available API versions: 2021-02-01-preview, 2021-05-01-preview, 2023-04-01, 2023-05-01, 2023-06-01.
 * ## Example Usage
 * ### ConnectivityConfigurationsPut
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var connectivityConfiguration = new AzureNative.Network.ConnectivityConfiguration("connectivityConfiguration", new()
 *     {
 *         AppliesToGroups = new[]
 *         {
 *             new AzureNative.Network.Inputs.ConnectivityGroupItemArgs
 *             {
 *                 GroupConnectivity = "None",
 *                 IsGlobal = "False",
 *                 NetworkGroupId = "subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkManagers/testNetworkManager/networkGroups/group1",
 *                 UseHubGateway = "True",
 *             },
 *         },
 *         ConfigurationName = "myTestConnectivityConfig",
 *         ConnectivityTopology = "HubAndSpoke",
 *         DeleteExistingPeering = "True",
 *         Description = "Sample Configuration",
 *         Hubs = new[]
 *         {
 *             new AzureNative.Network.Inputs.HubArgs
 *             {
 *                 ResourceId = "subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/myTestConnectivityConfig",
 *                 ResourceType = "Microsoft.Network/virtualNetworks",
 *             },
 *         },
 *         IsGlobal = "True",
 *         NetworkManagerName = "testNetworkManager",
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewConnectivityConfiguration(ctx, "connectivityConfiguration", &network.ConnectivityConfigurationArgs{
 * 			AppliesToGroups: []network.ConnectivityGroupItemArgs{
 * 				{
 * 					GroupConnectivity: pulumi.String("None"),
 * 					IsGlobal:          pulumi.String("False"),
 * 					NetworkGroupId:    pulumi.String("subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkManagers/testNetworkManager/networkGroups/group1"),
 * 					UseHubGateway:     pulumi.String("True"),
 * 				},
 * 			},
 * 			ConfigurationName:     pulumi.String("myTestConnectivityConfig"),
 * 			ConnectivityTopology:  pulumi.String("HubAndSpoke"),
 * 			DeleteExistingPeering: pulumi.String("True"),
 * 			Description:           pulumi.String("Sample Configuration"),
 * 			Hubs: []network.HubArgs{
 * 				{
 * 					ResourceId:   pulumi.String("subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/myTestConnectivityConfig"),
 * 					ResourceType: pulumi.String("Microsoft.Network/virtualNetworks"),
 * 				},
 * 			},
 * 			IsGlobal:           pulumi.String("True"),
 * 			NetworkManagerName: pulumi.String("testNetworkManager"),
 * 			ResourceGroupName:  pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.ConnectivityConfiguration;
 * import com.pulumi.azurenative.network.ConnectivityConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var connectivityConfiguration = new ConnectivityConfiguration("connectivityConfiguration", ConnectivityConfigurationArgs.builder()
 *             .appliesToGroups(Map.ofEntries(
 *                 Map.entry("groupConnectivity", "None"),
 *                 Map.entry("isGlobal", "False"),
 *                 Map.entry("networkGroupId", "subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkManagers/testNetworkManager/networkGroups/group1"),
 *                 Map.entry("useHubGateway", "True")
 *             ))
 *             .configurationName("myTestConnectivityConfig")
 *             .connectivityTopology("HubAndSpoke")
 *             .deleteExistingPeering("True")
 *             .description("Sample Configuration")
 *             .hubs(Map.ofEntries(
 *                 Map.entry("resourceId", "subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/myTestConnectivityConfig"),
 *                 Map.entry("resourceType", "Microsoft.Network/virtualNetworks")
 *             ))
 *             .isGlobal("True")
 *             .networkManagerName("testNetworkManager")
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:ConnectivityConfiguration myTestConnectivityConfig /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkManagers/{networkManagerName}/connectivityConfigurations/{configurationName}
 * ```
 * @property appliesToGroups Groups for configuration
 * @property configurationName The name of the network manager connectivity configuration.
 * @property connectivityTopology Connectivity topology type.
 * @property deleteExistingPeering Flag if need to remove current existing peerings.
 * @property description A description of the connectivity configuration.
 * @property hubs List of hubItems
 * @property isGlobal Flag if global mesh is supported.
 * @property networkManagerName The name of the network manager.
 * @property resourceGroupName The name of the resource group.
 */
public data class ConnectivityConfigurationArgs(
    public val appliesToGroups: Output<List<ConnectivityGroupItemArgs>>? = null,
    public val configurationName: Output<String>? = null,
    public val connectivityTopology: Output<Either<String, ConnectivityTopology>>? = null,
    public val deleteExistingPeering: Output<Either<String, DeleteExistingPeering>>? = null,
    public val description: Output<String>? = null,
    public val hubs: Output<List<HubArgs>>? = null,
    public val isGlobal: Output<Either<String, IsGlobal>>? = null,
    public val networkManagerName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.ConnectivityConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.network.ConnectivityConfigurationArgs =
        com.pulumi.azurenative.network.ConnectivityConfigurationArgs.builder()
            .appliesToGroups(
                appliesToGroups?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .configurationName(configurationName?.applyValue({ args0 -> args0 }))
            .connectivityTopology(
                connectivityTopology?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .deleteExistingPeering(
                deleteExistingPeering?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .hubs(hubs?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .isGlobal(
                isGlobal?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .networkManagerName(networkManagerName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConnectivityConfigurationArgs].
 */
@PulumiTagMarker
public class ConnectivityConfigurationArgsBuilder internal constructor() {
    private var appliesToGroups: Output<List<ConnectivityGroupItemArgs>>? = null

    private var configurationName: Output<String>? = null

    private var connectivityTopology: Output<Either<String, ConnectivityTopology>>? = null

    private var deleteExistingPeering: Output<Either<String, DeleteExistingPeering>>? = null

    private var description: Output<String>? = null

    private var hubs: Output<List<HubArgs>>? = null

    private var isGlobal: Output<Either<String, IsGlobal>>? = null

    private var networkManagerName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value Groups for configuration
     */
    @JvmName("exogdfapotlatmyt")
    public suspend fun appliesToGroups(`value`: Output<List<ConnectivityGroupItemArgs>>) {
        this.appliesToGroups = value
    }

    @JvmName("vjgoeabjatocljkw")
    public suspend fun appliesToGroups(vararg values: Output<ConnectivityGroupItemArgs>) {
        this.appliesToGroups = Output.all(values.asList())
    }

    /**
     * @param values Groups for configuration
     */
    @JvmName("lhpdadsnswwksajo")
    public suspend fun appliesToGroups(values: List<Output<ConnectivityGroupItemArgs>>) {
        this.appliesToGroups = Output.all(values)
    }

    /**
     * @param value The name of the network manager connectivity configuration.
     */
    @JvmName("dfceyrlstdotrscn")
    public suspend fun configurationName(`value`: Output<String>) {
        this.configurationName = value
    }

    /**
     * @param value Connectivity topology type.
     */
    @JvmName("qdkkqyunqnqogosc")
    public suspend fun connectivityTopology(`value`: Output<Either<String, ConnectivityTopology>>) {
        this.connectivityTopology = value
    }

    /**
     * @param value Flag if need to remove current existing peerings.
     */
    @JvmName("oijasgynlfxktnex")
    public suspend fun deleteExistingPeering(`value`: Output<Either<String, DeleteExistingPeering>>) {
        this.deleteExistingPeering = value
    }

    /**
     * @param value A description of the connectivity configuration.
     */
    @JvmName("tsomfkctiglgpjqg")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value List of hubItems
     */
    @JvmName("kpwvwnhlvhvdgple")
    public suspend fun hubs(`value`: Output<List<HubArgs>>) {
        this.hubs = value
    }

    @JvmName("blhhbdyisnhkrvwl")
    public suspend fun hubs(vararg values: Output<HubArgs>) {
        this.hubs = Output.all(values.asList())
    }

    /**
     * @param values List of hubItems
     */
    @JvmName("xfjydakbraakamhi")
    public suspend fun hubs(values: List<Output<HubArgs>>) {
        this.hubs = Output.all(values)
    }

    /**
     * @param value Flag if global mesh is supported.
     */
    @JvmName("mdtwpunenhtuvgvs")
    public suspend fun isGlobal(`value`: Output<Either<String, IsGlobal>>) {
        this.isGlobal = value
    }

    /**
     * @param value The name of the network manager.
     */
    @JvmName("gaboykrmhvyudqbk")
    public suspend fun networkManagerName(`value`: Output<String>) {
        this.networkManagerName = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("gvxoxrkjkqimyhfn")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Groups for configuration
     */
    @JvmName("nicyeyuxnorbsbvw")
    public suspend fun appliesToGroups(`value`: List<ConnectivityGroupItemArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appliesToGroups = mapped
    }

    /**
     * @param argument Groups for configuration
     */
    @JvmName("ecvdsyfmpwwmgakh")
    public suspend
    fun appliesToGroups(argument: List<suspend ConnectivityGroupItemArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ConnectivityGroupItemArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.appliesToGroups = mapped
    }

    /**
     * @param argument Groups for configuration
     */
    @JvmName("ifxefhghnjmruede")
    public suspend fun appliesToGroups(
        vararg
        argument: suspend ConnectivityGroupItemArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ConnectivityGroupItemArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.appliesToGroups = mapped
    }

    /**
     * @param argument Groups for configuration
     */
    @JvmName("wmhwdhrgywlurqpi")
    public suspend
    fun appliesToGroups(argument: suspend ConnectivityGroupItemArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ConnectivityGroupItemArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.appliesToGroups = mapped
    }

    /**
     * @param values Groups for configuration
     */
    @JvmName("gxfuvehnldejaxqj")
    public suspend fun appliesToGroups(vararg values: ConnectivityGroupItemArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.appliesToGroups = mapped
    }

    /**
     * @param value The name of the network manager connectivity configuration.
     */
    @JvmName("amdxwyabvblthpcc")
    public suspend fun configurationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configurationName = mapped
    }

    /**
     * @param value Connectivity topology type.
     */
    @JvmName("yrjtwokrgbthinsp")
    public suspend fun connectivityTopology(`value`: Either<String, ConnectivityTopology>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectivityTopology = mapped
    }

    /**
     * @param value Connectivity topology type.
     */
    @JvmName("vgqlsuodhknvqpde")
    public fun connectivityTopology(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ConnectivityTopology>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.connectivityTopology = mapped
    }

    /**
     * @param value Connectivity topology type.
     */
    @JvmName("ihykgpmbbvkglbum")
    public fun connectivityTopology(`value`: ConnectivityTopology) {
        val toBeMapped = Either.ofRight<String, ConnectivityTopology>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.connectivityTopology = mapped
    }

    /**
     * @param value Flag if need to remove current existing peerings.
     */
    @JvmName("cuvawsanfxlmrnhl")
    public suspend fun deleteExistingPeering(`value`: Either<String, DeleteExistingPeering>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deleteExistingPeering = mapped
    }

    /**
     * @param value Flag if need to remove current existing peerings.
     */
    @JvmName("tcsyrmcrgxhfquif")
    public fun deleteExistingPeering(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DeleteExistingPeering>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deleteExistingPeering = mapped
    }

    /**
     * @param value Flag if need to remove current existing peerings.
     */
    @JvmName("eimquaoinqflevxw")
    public fun deleteExistingPeering(`value`: DeleteExistingPeering) {
        val toBeMapped = Either.ofRight<String, DeleteExistingPeering>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deleteExistingPeering = mapped
    }

    /**
     * @param value A description of the connectivity configuration.
     */
    @JvmName("wlxnnwbocaqmeshg")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value List of hubItems
     */
    @JvmName("sbmepmjvpxadwnhk")
    public suspend fun hubs(`value`: List<HubArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hubs = mapped
    }

    /**
     * @param argument List of hubItems
     */
    @JvmName("idvowohuvlmxrefj")
    public suspend fun hubs(argument: List<suspend HubArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { HubArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.hubs = mapped
    }

    /**
     * @param argument List of hubItems
     */
    @JvmName("dofronfjwlubdmeg")
    public suspend fun hubs(vararg argument: suspend HubArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { HubArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.hubs = mapped
    }

    /**
     * @param argument List of hubItems
     */
    @JvmName("ulnofucsrxbdbgrg")
    public suspend fun hubs(argument: suspend HubArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(HubArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.hubs = mapped
    }

    /**
     * @param values List of hubItems
     */
    @JvmName("lrtcnarbiqqwiqxq")
    public suspend fun hubs(vararg values: HubArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hubs = mapped
    }

    /**
     * @param value Flag if global mesh is supported.
     */
    @JvmName("spsbthvnkrjewmgs")
    public suspend fun isGlobal(`value`: Either<String, IsGlobal>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isGlobal = mapped
    }

    /**
     * @param value Flag if global mesh is supported.
     */
    @JvmName("acggsqutvmxorata")
    public fun isGlobal(`value`: String) {
        val toBeMapped = Either.ofLeft<String, IsGlobal>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.isGlobal = mapped
    }

    /**
     * @param value Flag if global mesh is supported.
     */
    @JvmName("julffagqesdghfoi")
    public fun isGlobal(`value`: IsGlobal) {
        val toBeMapped = Either.ofRight<String, IsGlobal>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.isGlobal = mapped
    }

    /**
     * @param value The name of the network manager.
     */
    @JvmName("pyaybsqbleqvrxch")
    public suspend fun networkManagerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkManagerName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("vpdbsfjlvhkuoigl")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): ConnectivityConfigurationArgs = ConnectivityConfigurationArgs(
        appliesToGroups = appliesToGroups,
        configurationName = configurationName,
        connectivityTopology = connectivityTopology,
        deleteExistingPeering = deleteExistingPeering,
        description = description,
        hubs = hubs,
        isGlobal = isGlobal,
        networkManagerName = networkManagerName,
        resourceGroupName = resourceGroupName,
    )
}
