@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.DdosCustomPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A DDoS custom policy in a resource group.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2022-01-01, 2023-04-01, 2023-05-01, 2023-06-01.
 * ## Example Usage
 * ### Create DDoS custom policy
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var ddosCustomPolicy = new AzureNative.Network.DdosCustomPolicy("ddosCustomPolicy", new()
 *     {
 *         DdosCustomPolicyName = "test-ddos-custom-policy",
 *         Location = "centraluseuap",
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewDdosCustomPolicy(ctx, "ddosCustomPolicy", &network.DdosCustomPolicyArgs{
 * 			DdosCustomPolicyName: pulumi.String("test-ddos-custom-policy"),
 * 			Location:             pulumi.String("centraluseuap"),
 * 			ResourceGroupName:    pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.DdosCustomPolicy;
 * import com.pulumi.azurenative.network.DdosCustomPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var ddosCustomPolicy = new DdosCustomPolicy("ddosCustomPolicy", DdosCustomPolicyArgs.builder()
 *             .ddosCustomPolicyName("test-ddos-custom-policy")
 *             .location("centraluseuap")
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:DdosCustomPolicy test-ddos-custom-policy /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/ddosCustomPolicies/{ddosCustomPolicyName}
 * ```
 * @property ddosCustomPolicyName The name of the DDoS custom policy.
 * @property id Resource ID.
 * @property location Resource location.
 * @property resourceGroupName The name of the resource group.
 * @property tags Resource tags.
 */
public data class DdosCustomPolicyArgs(
    public val ddosCustomPolicyName: Output<String>? = null,
    public val id: Output<String>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.DdosCustomPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.network.DdosCustomPolicyArgs =
        com.pulumi.azurenative.network.DdosCustomPolicyArgs.builder()
            .ddosCustomPolicyName(ddosCustomPolicyName?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [DdosCustomPolicyArgs].
 */
@PulumiTagMarker
public class DdosCustomPolicyArgsBuilder internal constructor() {
    private var ddosCustomPolicyName: Output<String>? = null

    private var id: Output<String>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of the DDoS custom policy.
     */
    @JvmName("afbiocmpihplaict")
    public suspend fun ddosCustomPolicyName(`value`: Output<String>) {
        this.ddosCustomPolicyName = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("ughulibqdjhmudgs")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Resource location.
     */
    @JvmName("hytvwrlbngxfikkm")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("cplonvowwcbwxuug")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("fqbuqvegchkjmadf")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the DDoS custom policy.
     */
    @JvmName("qqnnghemddlolfqe")
    public suspend fun ddosCustomPolicyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ddosCustomPolicyName = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("gslgdobdoweghurr")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("kgicsjbaexydkchg")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("lybbjajctcpqqwin")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("vgsepixknjkkdroj")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("iwxltghrxwdmkcls")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): DdosCustomPolicyArgs = DdosCustomPolicyArgs(
        ddosCustomPolicyName = ddosCustomPolicyName,
        id = id,
        location = location,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
