@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.kotlin.outputs.NetworkInterfaceResponse
import com.pulumi.azurenative.network.kotlin.outputs.QosDefinitionResponse
import com.pulumi.azurenative.network.kotlin.outputs.QosIpRangeResponse
import com.pulumi.azurenative.network.kotlin.outputs.QosPortRangeResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.network.kotlin.outputs.NetworkInterfaceResponse.Companion.toKotlin as networkInterfaceResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.QosDefinitionResponse.Companion.toKotlin as qosDefinitionResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.QosIpRangeResponse.Companion.toKotlin as qosIpRangeResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.QosPortRangeResponse.Companion.toKotlin as qosPortRangeResponseToKotlin

/**
 * Builder for [DscpConfiguration].
 */
@PulumiTagMarker
public class DscpConfigurationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DscpConfigurationArgs = DscpConfigurationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DscpConfigurationArgsBuilder.() -> Unit) {
        val builder = DscpConfigurationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): DscpConfiguration {
        val builtJavaResource =
            com.pulumi.azurenative.network.DscpConfiguration(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return DscpConfiguration(builtJavaResource)
    }
}

/**
 * Differentiated Services Code Point configuration for any given network interface
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2023-04-01, 2023-05-01, 2023-06-01.
 * ## Example Usage
 * ### Create DSCP Configuration
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var dscpConfiguration = new AzureNative.Network.DscpConfiguration("dscpConfiguration", new()
 *     {
 *         DscpConfigurationName = "mydscpconfig",
 *         Location = "eastus",
 *         QosDefinitionCollection = new[]
 *         {
 *             new AzureNative.Network.Inputs.QosDefinitionArgs
 *             {
 *                 DestinationIpRanges = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.QosIpRangeArgs
 *                     {
 *                         EndIP = "127.0.10.2",
 *                         StartIP = "127.0.10.1",
 *                     },
 *                 },
 *                 DestinationPortRanges = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.QosPortRangeArgs
 *                     {
 *                         End = 15,
 *                         Start = 15,
 *                     },
 *                 },
 *                 Markings = new[]
 *                 {
 *                     1,
 *                 },
 *                 Protocol = "Tcp",
 *                 SourceIpRanges = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.QosIpRangeArgs
 *                     {
 *                         EndIP = "127.0.0.2",
 *                         StartIP = "127.0.0.1",
 *                     },
 *                 },
 *                 SourcePortRanges = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.QosPortRangeArgs
 *                     {
 *                         End = 11,
 *                         Start = 10,
 *                     },
 *                     new AzureNative.Network.Inputs.QosPortRangeArgs
 *                     {
 *                         End = 21,
 *                         Start = 20,
 *                     },
 *                 },
 *             },
 *             new AzureNative.Network.Inputs.QosDefinitionArgs
 *             {
 *                 DestinationIpRanges = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.QosIpRangeArgs
 *                     {
 *                         EndIP = "12.0.10.2",
 *                         StartIP = "12.0.10.1",
 *                     },
 *                 },
 *                 DestinationPortRanges = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.QosPortRangeArgs
 *                     {
 *                         End = 52,
 *                         Start = 51,
 *                     },
 *                 },
 *                 Markings = new[]
 *                 {
 *                     2,
 *                 },
 *                 Protocol = "Udp",
 *                 SourceIpRanges = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.QosIpRangeArgs
 *                     {
 *                         EndIP = "12.0.0.2",
 *                         StartIP = "12.0.0.1",
 *                     },
 *                 },
 *                 SourcePortRanges = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.QosPortRangeArgs
 *                     {
 *                         End = 12,
 *                         Start = 11,
 *                     },
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewDscpConfiguration(ctx, "dscpConfiguration", &network.DscpConfigurationArgs{
 * 			DscpConfigurationName: pulumi.String("mydscpconfig"),
 * 			Location:              pulumi.String("eastus"),
 * 			QosDefinitionCollection: []network.QosDefinitionArgs{
 * 				{
 * 					DestinationIpRanges: network.QosIpRangeArray{
 * 						{
 * 							EndIP:   pulumi.String("127.0.10.2"),
 * 							StartIP: pulumi.String("127.0.10.1"),
 * 						},
 * 					},
 * 					DestinationPortRanges: network.QosPortRangeArray{
 * 						{
 * 							End:   pulumi.Int(15),
 * 							Start: pulumi.Int(15),
 * 						},
 * 					},
 * 					Markings: pulumi.IntArray{
 * 						pulumi.Int(1),
 * 					},
 * 					Protocol: pulumi.String("Tcp"),
 * 					SourceIpRanges: network.QosIpRangeArray{
 * 						{
 * 							EndIP:   pulumi.String("127.0.0.2"),
 * 							StartIP: pulumi.String("127.0.0.1"),
 * 						},
 * 					},
 * 					SourcePortRanges: network.QosPortRangeArray{
 * 						{
 * 							End:   pulumi.Int(11),
 * 							Start: pulumi.Int(10),
 * 						},
 * 						{
 * 							End:   pulumi.Int(21),
 * 							Start: pulumi.Int(20),
 * 						},
 * 					},
 * 				},
 * 				{
 * 					DestinationIpRanges: network.QosIpRangeArray{
 * 						{
 * 							EndIP:   pulumi.String("12.0.10.2"),
 * 							StartIP: pulumi.String("12.0.10.1"),
 * 						},
 * 					},
 * 					DestinationPortRanges: network.QosPortRangeArray{
 * 						{
 * 							End:   pulumi.Int(52),
 * 							Start: pulumi.Int(51),
 * 						},
 * 					},
 * 					Markings: pulumi.IntArray{
 * 						pulumi.Int(2),
 * 					},
 * 					Protocol: pulumi.String("Udp"),
 * 					SourceIpRanges: network.QosIpRangeArray{
 * 						{
 * 							EndIP:   pulumi.String("12.0.0.2"),
 * 							StartIP: pulumi.String("12.0.0.1"),
 * 						},
 * 					},
 * 					SourcePortRanges: network.QosPortRangeArray{
 * 						{
 * 							End:   pulumi.Int(12),
 * 							Start: pulumi.Int(11),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.DscpConfiguration;
 * import com.pulumi.azurenative.network.DscpConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dscpConfiguration = new DscpConfiguration("dscpConfiguration", DscpConfigurationArgs.builder()
 *             .dscpConfigurationName("mydscpconfig")
 *             .location("eastus")
 *             .qosDefinitionCollection(
 *                 Map.ofEntries(
 *                     Map.entry("destinationIpRanges", Map.ofEntries(
 *                         Map.entry("endIP", "127.0.10.2"),
 *                         Map.entry("startIP", "127.0.10.1")
 *                     )),
 *                     Map.entry("destinationPortRanges", Map.ofEntries(
 *                         Map.entry("end", 15),
 *                         Map.entry("start", 15)
 *                     )),
 *                     Map.entry("markings", 1),
 *                     Map.entry("protocol", "Tcp"),
 *                     Map.entry("sourceIpRanges", Map.ofEntries(
 *                         Map.entry("endIP", "127.0.0.2"),
 *                         Map.entry("startIP", "127.0.0.1")
 *                     )),
 *                     Map.entry("sourcePortRanges",
 *                         Map.ofEntries(
 *                             Map.entry("end", 11),
 *                             Map.entry("start", 10)
 *                         ),
 *                         Map.ofEntries(
 *                             Map.entry("end", 21),
 *                             Map.entry("start", 20)
 *                         ))
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("destinationIpRanges", Map.ofEntries(
 *                         Map.entry("endIP", "12.0.10.2"),
 *                         Map.entry("startIP", "12.0.10.1")
 *                     )),
 *                     Map.entry("destinationPortRanges", Map.ofEntries(
 *                         Map.entry("end", 52),
 *                         Map.entry("start", 51)
 *                     )),
 *                     Map.entry("markings", 2),
 *                     Map.entry("protocol", "Udp"),
 *                     Map.entry("sourceIpRanges", Map.ofEntries(
 *                         Map.entry("endIP", "12.0.0.2"),
 *                         Map.entry("startIP", "12.0.0.1")
 *                     )),
 *                     Map.entry("sourcePortRanges", Map.ofEntries(
 *                         Map.entry("end", 12),
 *                         Map.entry("start", 11)
 *                     ))
 *                 ))
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:DscpConfiguration mydscpConfig /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dscpConfigurations/{dscpConfigurationName}
 * ```
 */
public class DscpConfiguration internal constructor(
    override val javaResource: com.pulumi.azurenative.network.DscpConfiguration,
) : KotlinCustomResource(javaResource, DscpConfigurationMapper) {
    /**
     * Associated Network Interfaces to the DSCP Configuration.
     */
    public val associatedNetworkInterfaces: Output<List<NetworkInterfaceResponse>>
        get() = javaResource.associatedNetworkInterfaces().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> networkInterfaceResponseToKotlin(args0) })
            })
        })

    /**
     * Destination IP ranges.
     */
    public val destinationIpRanges: Output<List<QosIpRangeResponse>>?
        get() = javaResource.destinationIpRanges().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        qosIpRangeResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Destination port ranges.
     */
    public val destinationPortRanges: Output<List<QosPortRangeResponse>>?
        get() = javaResource.destinationPortRanges().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        qosPortRangeResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * A unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * Resource location.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * List of markings to be used in the configuration.
     */
    public val markings: Output<List<Int>>?
        get() = javaResource.markings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * RNM supported protocol types.
     */
    public val protocol: Output<String>?
        get() = javaResource.protocol().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The provisioning state of the DSCP Configuration resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Qos Collection ID generated by RNM.
     */
    public val qosCollectionId: Output<String>
        get() = javaResource.qosCollectionId().applyValue({ args0 -> args0 })

    /**
     * QoS object definitions
     */
    public val qosDefinitionCollection: Output<List<QosDefinitionResponse>>?
        get() = javaResource.qosDefinitionCollection().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        qosDefinitionResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The resource GUID property of the DSCP Configuration resource.
     */
    public val resourceGuid: Output<String>
        get() = javaResource.resourceGuid().applyValue({ args0 -> args0 })

    /**
     * Source IP ranges.
     */
    public val sourceIpRanges: Output<List<QosIpRangeResponse>>?
        get() = javaResource.sourceIpRanges().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        qosIpRangeResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Sources port ranges.
     */
    public val sourcePortRanges: Output<List<QosPortRangeResponse>>?
        get() = javaResource.sourcePortRanges().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        qosPortRangeResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object DscpConfigurationMapper : ResourceMapper<DscpConfiguration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.DscpConfiguration::class == javaResource::class

    override fun map(javaResource: Resource): DscpConfiguration = DscpConfiguration(
        javaResource as
            com.pulumi.azurenative.network.DscpConfiguration,
    )
}

/**
 * @see [DscpConfiguration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DscpConfiguration].
 */
public suspend fun dscpConfiguration(
    name: String,
    block: suspend DscpConfigurationResourceBuilder.() -> Unit,
): DscpConfiguration {
    val builder = DscpConfigurationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DscpConfiguration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun dscpConfiguration(name: String): DscpConfiguration {
    val builder = DscpConfigurationResourceBuilder()
    builder.name(name)
    return builder.build()
}
