@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.DscpConfigurationArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.ProtocolType
import com.pulumi.azurenative.network.kotlin.inputs.QosDefinitionArgs
import com.pulumi.azurenative.network.kotlin.inputs.QosDefinitionArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.QosIpRangeArgs
import com.pulumi.azurenative.network.kotlin.inputs.QosIpRangeArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.QosPortRangeArgs
import com.pulumi.azurenative.network.kotlin.inputs.QosPortRangeArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Differentiated Services Code Point configuration for any given network interface
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2023-04-01, 2023-05-01, 2023-06-01.
 * ## Example Usage
 * ### Create DSCP Configuration
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var dscpConfiguration = new AzureNative.Network.DscpConfiguration("dscpConfiguration", new()
 *     {
 *         DscpConfigurationName = "mydscpconfig",
 *         Location = "eastus",
 *         QosDefinitionCollection = new[]
 *         {
 *             new AzureNative.Network.Inputs.QosDefinitionArgs
 *             {
 *                 DestinationIpRanges = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.QosIpRangeArgs
 *                     {
 *                         EndIP = "127.0.10.2",
 *                         StartIP = "127.0.10.1",
 *                     },
 *                 },
 *                 DestinationPortRanges = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.QosPortRangeArgs
 *                     {
 *                         End = 15,
 *                         Start = 15,
 *                     },
 *                 },
 *                 Markings = new[]
 *                 {
 *                     1,
 *                 },
 *                 Protocol = "Tcp",
 *                 SourceIpRanges = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.QosIpRangeArgs
 *                     {
 *                         EndIP = "127.0.0.2",
 *                         StartIP = "127.0.0.1",
 *                     },
 *                 },
 *                 SourcePortRanges = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.QosPortRangeArgs
 *                     {
 *                         End = 11,
 *                         Start = 10,
 *                     },
 *                     new AzureNative.Network.Inputs.QosPortRangeArgs
 *                     {
 *                         End = 21,
 *                         Start = 20,
 *                     },
 *                 },
 *             },
 *             new AzureNative.Network.Inputs.QosDefinitionArgs
 *             {
 *                 DestinationIpRanges = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.QosIpRangeArgs
 *                     {
 *                         EndIP = "12.0.10.2",
 *                         StartIP = "12.0.10.1",
 *                     },
 *                 },
 *                 DestinationPortRanges = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.QosPortRangeArgs
 *                     {
 *                         End = 52,
 *                         Start = 51,
 *                     },
 *                 },
 *                 Markings = new[]
 *                 {
 *                     2,
 *                 },
 *                 Protocol = "Udp",
 *                 SourceIpRanges = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.QosIpRangeArgs
 *                     {
 *                         EndIP = "12.0.0.2",
 *                         StartIP = "12.0.0.1",
 *                     },
 *                 },
 *                 SourcePortRanges = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.QosPortRangeArgs
 *                     {
 *                         End = 12,
 *                         Start = 11,
 *                     },
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewDscpConfiguration(ctx, "dscpConfiguration", &network.DscpConfigurationArgs{
 * 			DscpConfigurationName: pulumi.String("mydscpconfig"),
 * 			Location:              pulumi.String("eastus"),
 * 			QosDefinitionCollection: []network.QosDefinitionArgs{
 * 				{
 * 					DestinationIpRanges: network.QosIpRangeArray{
 * 						{
 * 							EndIP:   pulumi.String("127.0.10.2"),
 * 							StartIP: pulumi.String("127.0.10.1"),
 * 						},
 * 					},
 * 					DestinationPortRanges: network.QosPortRangeArray{
 * 						{
 * 							End:   pulumi.Int(15),
 * 							Start: pulumi.Int(15),
 * 						},
 * 					},
 * 					Markings: pulumi.IntArray{
 * 						pulumi.Int(1),
 * 					},
 * 					Protocol: pulumi.String("Tcp"),
 * 					SourceIpRanges: network.QosIpRangeArray{
 * 						{
 * 							EndIP:   pulumi.String("127.0.0.2"),
 * 							StartIP: pulumi.String("127.0.0.1"),
 * 						},
 * 					},
 * 					SourcePortRanges: network.QosPortRangeArray{
 * 						{
 * 							End:   pulumi.Int(11),
 * 							Start: pulumi.Int(10),
 * 						},
 * 						{
 * 							End:   pulumi.Int(21),
 * 							Start: pulumi.Int(20),
 * 						},
 * 					},
 * 				},
 * 				{
 * 					DestinationIpRanges: network.QosIpRangeArray{
 * 						{
 * 							EndIP:   pulumi.String("12.0.10.2"),
 * 							StartIP: pulumi.String("12.0.10.1"),
 * 						},
 * 					},
 * 					DestinationPortRanges: network.QosPortRangeArray{
 * 						{
 * 							End:   pulumi.Int(52),
 * 							Start: pulumi.Int(51),
 * 						},
 * 					},
 * 					Markings: pulumi.IntArray{
 * 						pulumi.Int(2),
 * 					},
 * 					Protocol: pulumi.String("Udp"),
 * 					SourceIpRanges: network.QosIpRangeArray{
 * 						{
 * 							EndIP:   pulumi.String("12.0.0.2"),
 * 							StartIP: pulumi.String("12.0.0.1"),
 * 						},
 * 					},
 * 					SourcePortRanges: network.QosPortRangeArray{
 * 						{
 * 							End:   pulumi.Int(12),
 * 							Start: pulumi.Int(11),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.DscpConfiguration;
 * import com.pulumi.azurenative.network.DscpConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dscpConfiguration = new DscpConfiguration("dscpConfiguration", DscpConfigurationArgs.builder()
 *             .dscpConfigurationName("mydscpconfig")
 *             .location("eastus")
 *             .qosDefinitionCollection(
 *                 Map.ofEntries(
 *                     Map.entry("destinationIpRanges", Map.ofEntries(
 *                         Map.entry("endIP", "127.0.10.2"),
 *                         Map.entry("startIP", "127.0.10.1")
 *                     )),
 *                     Map.entry("destinationPortRanges", Map.ofEntries(
 *                         Map.entry("end", 15),
 *                         Map.entry("start", 15)
 *                     )),
 *                     Map.entry("markings", 1),
 *                     Map.entry("protocol", "Tcp"),
 *                     Map.entry("sourceIpRanges", Map.ofEntries(
 *                         Map.entry("endIP", "127.0.0.2"),
 *                         Map.entry("startIP", "127.0.0.1")
 *                     )),
 *                     Map.entry("sourcePortRanges",
 *                         Map.ofEntries(
 *                             Map.entry("end", 11),
 *                             Map.entry("start", 10)
 *                         ),
 *                         Map.ofEntries(
 *                             Map.entry("end", 21),
 *                             Map.entry("start", 20)
 *                         ))
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("destinationIpRanges", Map.ofEntries(
 *                         Map.entry("endIP", "12.0.10.2"),
 *                         Map.entry("startIP", "12.0.10.1")
 *                     )),
 *                     Map.entry("destinationPortRanges", Map.ofEntries(
 *                         Map.entry("end", 52),
 *                         Map.entry("start", 51)
 *                     )),
 *                     Map.entry("markings", 2),
 *                     Map.entry("protocol", "Udp"),
 *                     Map.entry("sourceIpRanges", Map.ofEntries(
 *                         Map.entry("endIP", "12.0.0.2"),
 *                         Map.entry("startIP", "12.0.0.1")
 *                     )),
 *                     Map.entry("sourcePortRanges", Map.ofEntries(
 *                         Map.entry("end", 12),
 *                         Map.entry("start", 11)
 *                     ))
 *                 ))
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:DscpConfiguration mydscpConfig /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dscpConfigurations/{dscpConfigurationName}
 * ```
 * @property destinationIpRanges Destination IP ranges.
 * @property destinationPortRanges Destination port ranges.
 * @property dscpConfigurationName The name of the resource.
 * @property id Resource ID.
 * @property location Resource location.
 * @property markings List of markings to be used in the configuration.
 * @property protocol RNM supported protocol types.
 * @property qosDefinitionCollection QoS object definitions
 * @property resourceGroupName The name of the resource group.
 * @property sourceIpRanges Source IP ranges.
 * @property sourcePortRanges Sources port ranges.
 * @property tags Resource tags.
 */
public data class DscpConfigurationArgs(
    public val destinationIpRanges: Output<List<QosIpRangeArgs>>? = null,
    public val destinationPortRanges: Output<List<QosPortRangeArgs>>? = null,
    public val dscpConfigurationName: Output<String>? = null,
    public val id: Output<String>? = null,
    public val location: Output<String>? = null,
    public val markings: Output<List<Int>>? = null,
    public val protocol: Output<Either<String, ProtocolType>>? = null,
    public val qosDefinitionCollection: Output<List<QosDefinitionArgs>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sourceIpRanges: Output<List<QosIpRangeArgs>>? = null,
    public val sourcePortRanges: Output<List<QosPortRangeArgs>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.DscpConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.network.DscpConfigurationArgs =
        com.pulumi.azurenative.network.DscpConfigurationArgs.builder()
            .destinationIpRanges(
                destinationIpRanges?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .destinationPortRanges(
                destinationPortRanges?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .dscpConfigurationName(dscpConfigurationName?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .markings(markings?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .protocol(
                protocol?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .qosDefinitionCollection(
                qosDefinitionCollection?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sourceIpRanges(
                sourceIpRanges?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .sourcePortRanges(
                sourcePortRanges?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [DscpConfigurationArgs].
 */
@PulumiTagMarker
public class DscpConfigurationArgsBuilder internal constructor() {
    private var destinationIpRanges: Output<List<QosIpRangeArgs>>? = null

    private var destinationPortRanges: Output<List<QosPortRangeArgs>>? = null

    private var dscpConfigurationName: Output<String>? = null

    private var id: Output<String>? = null

    private var location: Output<String>? = null

    private var markings: Output<List<Int>>? = null

    private var protocol: Output<Either<String, ProtocolType>>? = null

    private var qosDefinitionCollection: Output<List<QosDefinitionArgs>>? = null

    private var resourceGroupName: Output<String>? = null

    private var sourceIpRanges: Output<List<QosIpRangeArgs>>? = null

    private var sourcePortRanges: Output<List<QosPortRangeArgs>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Destination IP ranges.
     */
    @JvmName("ldgrfnsrjghquyrb")
    public suspend fun destinationIpRanges(`value`: Output<List<QosIpRangeArgs>>) {
        this.destinationIpRanges = value
    }

    @JvmName("yphkttykdnyidwfd")
    public suspend fun destinationIpRanges(vararg values: Output<QosIpRangeArgs>) {
        this.destinationIpRanges = Output.all(values.asList())
    }

    /**
     * @param values Destination IP ranges.
     */
    @JvmName("cgcmitdcqftmiici")
    public suspend fun destinationIpRanges(values: List<Output<QosIpRangeArgs>>) {
        this.destinationIpRanges = Output.all(values)
    }

    /**
     * @param value Destination port ranges.
     */
    @JvmName("qhojsffmxywhtigg")
    public suspend fun destinationPortRanges(`value`: Output<List<QosPortRangeArgs>>) {
        this.destinationPortRanges = value
    }

    @JvmName("pxhfjnyiymaxanba")
    public suspend fun destinationPortRanges(vararg values: Output<QosPortRangeArgs>) {
        this.destinationPortRanges = Output.all(values.asList())
    }

    /**
     * @param values Destination port ranges.
     */
    @JvmName("otuwauxdxposjlwf")
    public suspend fun destinationPortRanges(values: List<Output<QosPortRangeArgs>>) {
        this.destinationPortRanges = Output.all(values)
    }

    /**
     * @param value The name of the resource.
     */
    @JvmName("ibmqckcnpmqkikeu")
    public suspend fun dscpConfigurationName(`value`: Output<String>) {
        this.dscpConfigurationName = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("hduxnhaghismhuwr")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Resource location.
     */
    @JvmName("qspqwhktpwhlatpt")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value List of markings to be used in the configuration.
     */
    @JvmName("svpurarjygmrclpm")
    public suspend fun markings(`value`: Output<List<Int>>) {
        this.markings = value
    }

    @JvmName("yvliewmlfpafccje")
    public suspend fun markings(vararg values: Output<Int>) {
        this.markings = Output.all(values.asList())
    }

    /**
     * @param values List of markings to be used in the configuration.
     */
    @JvmName("hysewwfqevbroxry")
    public suspend fun markings(values: List<Output<Int>>) {
        this.markings = Output.all(values)
    }

    /**
     * @param value RNM supported protocol types.
     */
    @JvmName("fwoegnkkrwdruotk")
    public suspend fun protocol(`value`: Output<Either<String, ProtocolType>>) {
        this.protocol = value
    }

    /**
     * @param value QoS object definitions
     */
    @JvmName("xdvulajewvsyjobx")
    public suspend fun qosDefinitionCollection(`value`: Output<List<QosDefinitionArgs>>) {
        this.qosDefinitionCollection = value
    }

    @JvmName("osckpvlstryvqgph")
    public suspend fun qosDefinitionCollection(vararg values: Output<QosDefinitionArgs>) {
        this.qosDefinitionCollection = Output.all(values.asList())
    }

    /**
     * @param values QoS object definitions
     */
    @JvmName("cxwdlevdimytpfhe")
    public suspend fun qosDefinitionCollection(values: List<Output<QosDefinitionArgs>>) {
        this.qosDefinitionCollection = Output.all(values)
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("ynoefkgprvvafqlq")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Source IP ranges.
     */
    @JvmName("ajgglftsiytjhcjv")
    public suspend fun sourceIpRanges(`value`: Output<List<QosIpRangeArgs>>) {
        this.sourceIpRanges = value
    }

    @JvmName("hmshmskinlggrquk")
    public suspend fun sourceIpRanges(vararg values: Output<QosIpRangeArgs>) {
        this.sourceIpRanges = Output.all(values.asList())
    }

    /**
     * @param values Source IP ranges.
     */
    @JvmName("scwgpnlgyvmcsxva")
    public suspend fun sourceIpRanges(values: List<Output<QosIpRangeArgs>>) {
        this.sourceIpRanges = Output.all(values)
    }

    /**
     * @param value Sources port ranges.
     */
    @JvmName("kokbsprhlwporiad")
    public suspend fun sourcePortRanges(`value`: Output<List<QosPortRangeArgs>>) {
        this.sourcePortRanges = value
    }

    @JvmName("wlgxaqsqewmkqjjw")
    public suspend fun sourcePortRanges(vararg values: Output<QosPortRangeArgs>) {
        this.sourcePortRanges = Output.all(values.asList())
    }

    /**
     * @param values Sources port ranges.
     */
    @JvmName("vxfsajaddhybkkns")
    public suspend fun sourcePortRanges(values: List<Output<QosPortRangeArgs>>) {
        this.sourcePortRanges = Output.all(values)
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("vftliibfbkkqpeyj")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Destination IP ranges.
     */
    @JvmName("clsxqelqqomggaar")
    public suspend fun destinationIpRanges(`value`: List<QosIpRangeArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationIpRanges = mapped
    }

    /**
     * @param argument Destination IP ranges.
     */
    @JvmName("cpreermhcpkxmfah")
    public suspend fun destinationIpRanges(argument: List<suspend QosIpRangeArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { QosIpRangeArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.destinationIpRanges = mapped
    }

    /**
     * @param argument Destination IP ranges.
     */
    @JvmName("uoxrfilkbhwnuiia")
    public suspend fun destinationIpRanges(
        vararg
        argument: suspend QosIpRangeArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map { QosIpRangeArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.destinationIpRanges = mapped
    }

    /**
     * @param argument Destination IP ranges.
     */
    @JvmName("tqiilwojysdwdsta")
    public suspend fun destinationIpRanges(argument: suspend QosIpRangeArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(QosIpRangeArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.destinationIpRanges = mapped
    }

    /**
     * @param values Destination IP ranges.
     */
    @JvmName("merpberdpybycfap")
    public suspend fun destinationIpRanges(vararg values: QosIpRangeArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destinationIpRanges = mapped
    }

    /**
     * @param value Destination port ranges.
     */
    @JvmName("ulhunjocmtisgapq")
    public suspend fun destinationPortRanges(`value`: List<QosPortRangeArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationPortRanges = mapped
    }

    /**
     * @param argument Destination port ranges.
     */
    @JvmName("gsrrxnkpxifqmnnb")
    public suspend
    fun destinationPortRanges(argument: List<suspend QosPortRangeArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            QosPortRangeArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.destinationPortRanges = mapped
    }

    /**
     * @param argument Destination port ranges.
     */
    @JvmName("henphtmraekjiwrc")
    public suspend fun destinationPortRanges(
        vararg
        argument: suspend QosPortRangeArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            QosPortRangeArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.destinationPortRanges = mapped
    }

    /**
     * @param argument Destination port ranges.
     */
    @JvmName("qdbkjmjwjfhildej")
    public suspend fun destinationPortRanges(argument: suspend QosPortRangeArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(QosPortRangeArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.destinationPortRanges = mapped
    }

    /**
     * @param values Destination port ranges.
     */
    @JvmName("lysmrehaafcymbhj")
    public suspend fun destinationPortRanges(vararg values: QosPortRangeArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destinationPortRanges = mapped
    }

    /**
     * @param value The name of the resource.
     */
    @JvmName("dqeoldyvdrssfcjk")
    public suspend fun dscpConfigurationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dscpConfigurationName = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("ikdjnqvbnefveqhx")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("ciuwlkxpvmgctqwa")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value List of markings to be used in the configuration.
     */
    @JvmName("benebwsgeaeswvia")
    public suspend fun markings(`value`: List<Int>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.markings = mapped
    }

    /**
     * @param values List of markings to be used in the configuration.
     */
    @JvmName("lfdinsenccdyhlky")
    public suspend fun markings(vararg values: Int) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.markings = mapped
    }

    /**
     * @param value RNM supported protocol types.
     */
    @JvmName("yuoahgrwuymcdefd")
    public suspend fun protocol(`value`: Either<String, ProtocolType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value RNM supported protocol types.
     */
    @JvmName("tttwwhuqsfaxbept")
    public fun protocol(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ProtocolType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value RNM supported protocol types.
     */
    @JvmName("sfaktbkqdvidecap")
    public fun protocol(`value`: ProtocolType) {
        val toBeMapped = Either.ofRight<String, ProtocolType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value QoS object definitions
     */
    @JvmName("mijurmhmxsbpwcph")
    public suspend fun qosDefinitionCollection(`value`: List<QosDefinitionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.qosDefinitionCollection = mapped
    }

    /**
     * @param argument QoS object definitions
     */
    @JvmName("ljynrjdgmrcecvmg")
    public suspend
    fun qosDefinitionCollection(argument: List<suspend QosDefinitionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            QosDefinitionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.qosDefinitionCollection = mapped
    }

    /**
     * @param argument QoS object definitions
     */
    @JvmName("hpjfeqfjygnueues")
    public suspend fun qosDefinitionCollection(
        vararg
        argument: suspend QosDefinitionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            QosDefinitionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.qosDefinitionCollection = mapped
    }

    /**
     * @param argument QoS object definitions
     */
    @JvmName("qupqwbywbuxhorsu")
    public suspend
    fun qosDefinitionCollection(argument: suspend QosDefinitionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(QosDefinitionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.qosDefinitionCollection = mapped
    }

    /**
     * @param values QoS object definitions
     */
    @JvmName("jjswjpdtswqdektf")
    public suspend fun qosDefinitionCollection(vararg values: QosDefinitionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.qosDefinitionCollection = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("pisppuwsjmdmpxxu")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Source IP ranges.
     */
    @JvmName("mdslkuplxdxqraox")
    public suspend fun sourceIpRanges(`value`: List<QosIpRangeArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceIpRanges = mapped
    }

    /**
     * @param argument Source IP ranges.
     */
    @JvmName("dgvvildgjdqeuikk")
    public suspend fun sourceIpRanges(argument: List<suspend QosIpRangeArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { QosIpRangeArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.sourceIpRanges = mapped
    }

    /**
     * @param argument Source IP ranges.
     */
    @JvmName("nmtsgmdnejqalehb")
    public suspend fun sourceIpRanges(vararg argument: suspend QosIpRangeArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { QosIpRangeArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.sourceIpRanges = mapped
    }

    /**
     * @param argument Source IP ranges.
     */
    @JvmName("gjjsdfslasolcpot")
    public suspend fun sourceIpRanges(argument: suspend QosIpRangeArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(QosIpRangeArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.sourceIpRanges = mapped
    }

    /**
     * @param values Source IP ranges.
     */
    @JvmName("bhmtyetrgjhgusbd")
    public suspend fun sourceIpRanges(vararg values: QosIpRangeArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceIpRanges = mapped
    }

    /**
     * @param value Sources port ranges.
     */
    @JvmName("xcigrwfsigyftnah")
    public suspend fun sourcePortRanges(`value`: List<QosPortRangeArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourcePortRanges = mapped
    }

    /**
     * @param argument Sources port ranges.
     */
    @JvmName("toqppqwreqvyllex")
    public suspend fun sourcePortRanges(argument: List<suspend QosPortRangeArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            QosPortRangeArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.sourcePortRanges = mapped
    }

    /**
     * @param argument Sources port ranges.
     */
    @JvmName("mxpucnyocbsxwisp")
    public suspend fun sourcePortRanges(vararg argument: suspend QosPortRangeArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            QosPortRangeArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.sourcePortRanges = mapped
    }

    /**
     * @param argument Sources port ranges.
     */
    @JvmName("qbngdlnuxlvkjsbf")
    public suspend fun sourcePortRanges(argument: suspend QosPortRangeArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(QosPortRangeArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.sourcePortRanges = mapped
    }

    /**
     * @param values Sources port ranges.
     */
    @JvmName("txqdqiarnlmtwanr")
    public suspend fun sourcePortRanges(vararg values: QosPortRangeArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourcePortRanges = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("ogvbxswihfmjvkdg")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("xtanmmtrxacbpnpq")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): DscpConfigurationArgs = DscpConfigurationArgs(
        destinationIpRanges = destinationIpRanges,
        destinationPortRanges = destinationPortRanges,
        dscpConfigurationName = dscpConfigurationName,
        id = id,
        location = location,
        markings = markings,
        protocol = protocol,
        qosDefinitionCollection = qosDefinitionCollection,
        resourceGroupName = resourceGroupName,
        sourceIpRanges = sourceIpRanges,
        sourcePortRanges = sourcePortRanges,
        tags = tags,
    )
}
